/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.parser.environment;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import lpg.runtime.Monitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.examples.common.utils.XMIUtils;
import org.eclipse.ocl.examples.modelregistry.environment.AbstractModelResolver;
import org.eclipse.ocl.examples.modelregistry.environment.FileHandle;
import org.eclipse.ocl.examples.parser.environment.CSTEnvironment;
import org.eclipse.ocl.examples.parser.environment.ICSTEnvironment;
import org.eclipse.ocl.examples.parser.environment.ICSTFileAnalyzer;
import org.eclipse.ocl.examples.parser.environment.ICSTFileEnvironment;
import org.eclipse.ocl.examples.parser.environment.ICSTNodeEnvironment;
import org.eclipse.ocl.examples.parser.environment.ICSTRootEnvironment;
import org.eclipse.ocl.examples.parser.environment.UnresolvedEnvironment;
import org.eclipse.ocl.examples.parser.utils.LPGProgressMonitor;
import org.eclipse.ocl.lpg.AbstractParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CSTFileEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E, R extends ICSTRootEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>, V extends ICSTNodeEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>, CST extends CSTNode>
extends CSTEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E, V>
implements ICSTFileEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    protected final EPackage.Registry registry;
    protected final XMIResource ast;
    protected final AbstractModelResolver resolver;
    private TypeResolver<C, O, P> typeResolver;

    private CSTFileEnvironment(EPackage.Registry registry, FileHandle file, ResourceSet resourceSet, XMIResource astResource) {
        super(null);
        assert (astResource != null);
        this.ast = astResource;
        this.typeResolver = this.createTypeResolver((Resource)this.ast);
        this.registry = registry;
        if (file != null) {
            this.resolver = new AbstractModelResolver(file);
            this.resolver.setResourceSet(resourceSet);
        } else {
            this.resolver = null;
        }
    }

    protected CSTFileEnvironment(FileHandle file, ResourceSet resourceSet, XMIResource astResource) {
        this(resourceSet.getPackageRegistry(), file, resourceSet, astResource);
    }

    @Override
    public abstract ICSTFileAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E, R> createAnalyzer(Monitor var1);

    protected abstract R createRootEnvironment(XMIResource var1, CST var2);

    protected abstract TypeResolver<C, O, P> createTypeResolver(Resource var1);

    @Override
    public XMIResource getASTResource() {
        return this.ast;
    }

    protected abstract String getContentTypeIdentifier();

    @Override
    public FileHandle getFile() {
        return this.getResolver().getHandle();
    }

    @Override
    public ICSTFileEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getFileEnvironment() {
        return this;
    }

    @Override
    public EPackage.Registry getRegistry() {
        return this.registry;
    }

    @Override
    public AbstractModelResolver getResolver() {
        return this.resolver;
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.resolver.getResourceSet();
    }

    public TypeResolver<C, O, P> getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public void initializePackageNs(EPackage ePackage) {
        ePackage.setNsPrefix(ePackage.getName());
        ePackage.setNsURI(UnresolvedEnvironment.computePackageNs(this.resolver.getHandle(), ePackage));
    }

    protected abstract boolean isNamed(E var1, String var2);

    @Override
    public ICSTRootEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parse(Reader reader, FileHandle file, IProgressMonitor monitor) throws IOException, CoreException {
        R rootEnvironment;
        LPGProgressMonitor lpgMonitor = new LPGProgressMonitor(monitor);
        ICSTFileAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E, R> analyzer = this.createAnalyzer(lpgMonitor);
        if (reader == null) {
            reader = new InputStreamReader(file.getContents());
        } else if (!file.exists()) {
            return null;
        }
        analyzer.reset(reader, file.getName());
        AbstractParser parser = this.getParser();
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        parser.getLexer().lexer(parser.getIPrsStream());
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        CSTNode cst = parser.parser((Monitor)lpgMonitor, -1);
        if (cst == null) {
            return null;
        }
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        try {
            this.reset();
            rootEnvironment = this.createRootEnvironment(this.ast, cst);
        }
        catch (ClassCastException e) {
            return null;
        }
        if (!analyzer.analyze(rootEnvironment)) {
            return null;
        }
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        this.postParse(rootEnvironment);
        return rootEnvironment;
    }

    protected void postParse(R rootEnvironment) {
        rootEnvironment.postParse();
        XMIUtils.assignLinearIds((Resource)this.ast, (String)"ast");
    }

    public void reset() {
        this.ast.unload();
        this.typeResolver = this.createTypeResolver((Resource)this.ast);
        EList eAdapters = this.ast.eAdapters();
        if (!eAdapters.isEmpty()) {
            for (Adapter eAdapter : new ArrayList(eAdapters)) {
                if (!(eAdapter instanceof ICSTEnvironment)) continue;
                eAdapters.remove(eAdapter);
            }
        }
    }

    public void setParent(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        throw new UnsupportedOperationException();
    }
}

