/**
 * <copyright>
 * 
 * Copyright (c) 2008,2010 E.D.Willink and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * E.D.Willink - initial API and implementation
 * 
 * </copyright>
 *
 * $Id: EditorItemProviderAdapterFactory.java,v 1.2 2010/04/08 06:24:58 ewillink Exp $
 */
package org.eclipse.ocl.examples.editor.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.ocl.examples.editor.util.EditorAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class EditorItemProviderAdapterFactory extends EditorAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EditorItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.examples.editor.EcoreLabelElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EcoreLabelElementItemProvider ecoreLabelElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.examples.editor.EcoreLabelElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEcoreLabelElementAdapter() {
		if (ecoreLabelElementItemProvider == null) {
			ecoreLabelElementItemProvider = new EcoreLabelElementItemProvider(this);
		}

		return ecoreLabelElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.examples.editor.EcoreNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EcoreNodeItemProvider ecoreNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.examples.editor.EcoreNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEcoreNodeAdapter() {
		if (ecoreNodeItemProvider == null) {
			ecoreNodeItemProvider = new EcoreNodeItemProvider(this);
		}

		return ecoreNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.examples.editor.EditorDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EditorDefinitionItemProvider editorDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.examples.editor.EditorDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEditorDefinitionAdapter() {
		if (editorDefinitionItemProvider == null) {
			editorDefinitionItemProvider = new EditorDefinitionItemProvider(this);
		}

		return editorDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.examples.editor.FoldingBehavior} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FoldingBehaviorItemProvider foldingBehaviorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.examples.editor.FoldingBehavior}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFoldingBehaviorAdapter() {
		if (foldingBehaviorItemProvider == null) {
			foldingBehaviorItemProvider = new FoldingBehaviorItemProvider(this);
		}

		return foldingBehaviorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.examples.editor.JavaLabelElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JavaLabelElementItemProvider javaLabelElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.examples.editor.JavaLabelElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJavaLabelElementAdapter() {
		if (javaLabelElementItemProvider == null) {
			javaLabelElementItemProvider = new JavaLabelElementItemProvider(this);
		}

		return javaLabelElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.examples.editor.JavaNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JavaNodeItemProvider javaNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.examples.editor.JavaNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJavaNodeAdapter() {
		if (javaNodeItemProvider == null) {
			javaNodeItemProvider = new JavaNodeItemProvider(this);
		}

		return javaNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.examples.editor.LabelBehavior} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelBehaviorItemProvider labelBehaviorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.examples.editor.LabelBehavior}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelBehaviorAdapter() {
		if (labelBehaviorItemProvider == null) {
			labelBehaviorItemProvider = new LabelBehaviorItemProvider(this);
		}

		return labelBehaviorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.examples.editor.OutlineBehavior} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OutlineBehaviorItemProvider outlineBehaviorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.examples.editor.OutlineBehavior}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOutlineBehaviorAdapter() {
		if (outlineBehaviorItemProvider == null) {
			outlineBehaviorItemProvider = new OutlineBehaviorItemProvider(this);
		}

		return outlineBehaviorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.examples.editor.OutlineElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OutlineElementItemProvider outlineElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.examples.editor.OutlineElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOutlineElementAdapter() {
		if (outlineElementItemProvider == null) {
			outlineElementItemProvider = new OutlineElementItemProvider(this);
		}

		return outlineElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.examples.editor.OutlineGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OutlineGroupItemProvider outlineGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.examples.editor.OutlineGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOutlineGroupAdapter() {
		if (outlineGroupItemProvider == null) {
			outlineGroupItemProvider = new OutlineGroupItemProvider(this);
		}

		return outlineGroupItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (ecoreLabelElementItemProvider != null) ecoreLabelElementItemProvider.dispose();
		if (ecoreNodeItemProvider != null) ecoreNodeItemProvider.dispose();
		if (editorDefinitionItemProvider != null) editorDefinitionItemProvider.dispose();
		if (foldingBehaviorItemProvider != null) foldingBehaviorItemProvider.dispose();
		if (javaLabelElementItemProvider != null) javaLabelElementItemProvider.dispose();
		if (javaNodeItemProvider != null) javaNodeItemProvider.dispose();
		if (labelBehaviorItemProvider != null) labelBehaviorItemProvider.dispose();
		if (outlineBehaviorItemProvider != null) outlineBehaviorItemProvider.dispose();
		if (outlineElementItemProvider != null) outlineElementItemProvider.dispose();
		if (outlineGroupItemProvider != null) outlineGroupItemProvider.dispose();
	}

}
