/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclstdlib.cs2pivot;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.common.utils.EcoreUtils;
import org.eclipse.ocl.examples.pivot.AssociativityKind;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.Library;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.OperationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PackageCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateableElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.BasePreOrderVisitor;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.BasicContinuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuations;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Dependency;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.SingleContinuation;
import org.eclipse.ocl.examples.xtext.essentialocl.cs2pivot.EssentialOCLPreOrderVisitor;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.LibClassCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.LibIterationCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.LibOperationCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.LibPropertyCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.LibRootPackageCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.MetaTypeName;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.PrecedenceCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.util.AbstractExtendingDelegatingOCLstdlibCSVisitor;
import org.eclipse.xtext.common.types.JvmType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLstdlibPreOrderVisitor
extends AbstractExtendingDelegatingOCLstdlibCSVisitor<Continuation<?>, CS2PivotConversion, EssentialOCLPreOrderVisitor> {
    public OCLstdlibPreOrderVisitor(CS2PivotConversion context) {
        super(new EssentialOCLPreOrderVisitor(context), context);
    }

    @Override
    public Continuation<?> visitLibClassCS(LibClassCS csLibClass) {
        EClass eClass = null;
        MetaTypeName metaType = csLibClass.getMetaTypeName();
        if (metaType != null && !metaType.eIsProxy()) {
            String metaTypeName = metaType.getName();
            eClass = (EClass)EcoreUtils.getNamedElement((Collection)PivotPackage.eINSTANCE.getEClassifiers(), (String)metaTypeName);
        }
        if (eClass == null) {
            eClass = PivotPackage.Literals.CLASS;
        }
        Class instanceClass = eClass.getInstanceClass();
        Type type = (Type)((CS2PivotConversion)this.context).refreshNamedElement(instanceClass, eClass, (NamedElementCS)csLibClass);
        type.setMoniker(csLibClass.getMoniker());
        Continuation continuation = (Continuation)super.visitLibClassCS(csLibClass);
        if (type instanceof CollectionType) {
            continuation = Continuations.combine((Continuation[])new Continuation[]{continuation, new CollectionElementTypeContinuation((CS2PivotConversion)this.context, csLibClass)});
        } else if (type instanceof ClassifierType) {
            continuation = Continuations.combine((Continuation[])new Continuation[]{continuation, new ClassifierInstanceTypeContinuation((CS2PivotConversion)this.context, csLibClass)});
        }
        return continuation;
    }

    @Override
    public Continuation<?> visitLibIterationCS(LibIterationCS csIteration) {
        return new LibIterationContinuation((CS2PivotConversion)this.context, csIteration);
    }

    @Override
    public Continuation<?> visitLibOperationCS(LibOperationCS csOperation) {
        return new LibOperationContinuation((CS2PivotConversion)this.context, csOperation);
    }

    @Override
    public Continuation<?> visitLibPropertyCS(LibPropertyCS csProperty) {
        return new LibPropertyContinuation((CS2PivotConversion)this.context, csProperty);
    }

    @Override
    public Continuation<?> visitLibRootPackageCS(LibRootPackageCS csLibRootPackage) {
        Library pivotElement = (Library)((CS2PivotConversion)this.context).refreshPackage(Library.class, PivotPackage.Literals.LIBRARY, (PackageCS)csLibRootPackage);
        Continuation superContinuation = (Continuation)super.visitLibRootPackageCS(csLibRootPackage);
        LibraryPrecedenceContinuation localContinuation = new LibraryPrecedenceContinuation((CS2PivotConversion)this.context, csLibRootPackage);
        return Continuations.combine((Continuation[])new Continuation[]{superContinuation, localContinuation});
    }

    @Override
    public Continuation<?> visitPrecedenceCS(PrecedenceCS csPrecedence) {
        Precedence pivotPrecedence = (Precedence)((CS2PivotConversion)this.context).refreshNamedElement(Precedence.class, PivotPackage.Literals.PRECEDENCE, (NamedElementCS)csPrecedence);
        pivotPrecedence.setAssociativity(csPrecedence.isRightAssociative() ? AssociativityKind.RIGHT : AssociativityKind.LEFT);
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ClassifierInstanceTypeContinuation
    extends SingleContinuation<LibClassCS> {
        public ClassifierInstanceTypeContinuation(CS2PivotConversion context, LibClassCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[]{context.getPackagesHaveTypesInterDependency()});
        }

        public BasicContinuation<?> execute() {
            TemplateParameter templateParameter;
            EList parameters;
            ClassifierType type = (ClassifierType)PivotUtil.getPivot(ClassifierType.class, (Pivotable)((Pivotable)this.csElement));
            TemplateSignature ownedTemplateSignature = type.getOwnedTemplateSignature();
            if (ownedTemplateSignature != null && (parameters = ownedTemplateSignature.getParameters()).size() > 0 && (templateParameter = (TemplateParameter)parameters.get(0)) != null) {
                type.setInstanceType((Type)templateParameter.getParameteredElement());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CollectionElementTypeContinuation
    extends SingleContinuation<LibClassCS> {
        public CollectionElementTypeContinuation(CS2PivotConversion context, LibClassCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[]{context.getPackagesHaveTypesInterDependency()});
        }

        public BasicContinuation<?> execute() {
            EList parameters;
            CollectionType type = (CollectionType)PivotUtil.getPivot(CollectionType.class, (Pivotable)((Pivotable)this.csElement));
            TemplateSignature ownedTemplateSignature = type.getOwnedTemplateSignature();
            if (ownedTemplateSignature != null && (parameters = ownedTemplateSignature.getParameters()).size() > 0) {
                type.setElementType((Type)((TemplateParameter)parameters.get(0)).getParameteredElement());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LibIterationContinuation
    extends BasePreOrderVisitor.OperationContinuation<LibIterationCS> {
        public LibIterationContinuation(CS2PivotConversion context, LibIterationCS csElement) {
            super(context, (OperationCS)csElement);
        }

        public BasicContinuation<?> execute() {
            String moniker = ((LibIterationCS)this.csElement).getMoniker();
            Iteration pivotIteration = (Iteration)this.context.refreshTypedMultiplicityElement(Iteration.class, PivotPackage.Literals.ITERATION, (TypedElementCS)this.csElement);
            pivotIteration.setMoniker(moniker);
            this.context.refreshTemplateSignature((TemplateableElementCS)this.csElement, (TemplateableElement)pivotIteration);
            this.refreshParameters((List)((LibIterationCS)this.csElement).getOwnedIterator(), (List)pivotIteration.getOwnedIterators());
            this.refreshParameters((List)((LibIterationCS)this.csElement).getOwnedAccumulator(), (List)pivotIteration.getOwnedAccumulators());
            this.refreshParameters((List)((LibIterationCS)this.csElement).getOwnedParameter(), (List)pivotIteration.getOwnedParameters());
            this.context.getOperationsHaveTemplateParametersInterDependency().setSatisfied((Object)this);
            JvmType implementation = ((LibIterationCS)this.csElement).getImplementation();
            if (implementation != null) {
                pivotIteration.setImplementationClass(implementation.getIdentifier());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LibOperationContinuation
    extends BasePreOrderVisitor.OperationContinuation<LibOperationCS> {
        public LibOperationContinuation(CS2PivotConversion context, LibOperationCS csElement) {
            super(context, (OperationCS)csElement);
        }

        public BasicContinuation<?> execute() {
            BasicContinuation continuation = super.execute();
            Operation pivotElement = (Operation)PivotUtil.getPivot(Operation.class, (Pivotable)((Pivotable)this.csElement));
            Precedence precedence = ((LibOperationCS)this.csElement).getPrecedence();
            if (precedence != null && precedence.eIsProxy()) {
                precedence = null;
            }
            pivotElement.setPrecedence(precedence);
            pivotElement.setIsStatic(((LibOperationCS)this.csElement).isStatic());
            JvmType implementation = ((LibOperationCS)this.csElement).getImplementation();
            if (implementation != null) {
                pivotElement.setImplementationClass(implementation.getIdentifier());
            }
            return continuation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LibPropertyContinuation
    extends SingleContinuation<LibPropertyCS> {
        public LibPropertyContinuation(CS2PivotConversion context, LibPropertyCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[]{context.getTypesHaveSignaturesInterDependency()});
        }

        public BasicContinuation<?> execute() {
            Property pivotElement = (Property)PivotUtil.getPivot(Property.class, (Pivotable)((Pivotable)this.csElement));
            pivotElement.setIsStatic(((LibPropertyCS)this.csElement).isStatic());
            JvmType implementation = ((LibPropertyCS)this.csElement).getImplementation();
            if (implementation != null) {
                pivotElement.setImplementationClass(implementation.getIdentifier());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LibraryPrecedenceContinuation
    extends SingleContinuation<LibRootPackageCS> {
        private LibraryPrecedenceContinuation(CS2PivotConversion context, LibRootPackageCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[0]);
        }

        public BasicContinuation<?> execute() {
            Library pivotElement = (Library)PivotUtil.getPivot(Library.class, (Pivotable)((Pivotable)this.csElement));
            this.context.refreshPivotList(Precedence.class, (List)pivotElement.getOwnedPrecedences(), ((LibRootPackageCS)this.csElement).getOwnedPrecedence());
            return null;
        }
    }
}

