/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library;

import org.eclipse.ocl.examples.library.AbstractFeature;
import org.eclipse.ocl.examples.library.IterationManager;
import org.eclipse.ocl.examples.library.LibraryIteration;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.values.impl.BagValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.OrderedSetValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.SequenceValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.SetValueImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIteration<ACC extends Value>
extends AbstractFeature
implements LibraryIteration {
    protected CollectionValue.Accumulator createAccumulationValue(ValueFactory valueFactory, boolean isOrdered, boolean isUnique) {
        if (isOrdered) {
            if (isUnique) {
                return new OrderedSetValueImpl.Accumulator(valueFactory);
            }
            return new SequenceValueImpl.Accumulator(valueFactory);
        }
        if (isUnique) {
            return new SetValueImpl.Accumulator(valueFactory);
        }
        return new BagValueImpl.Accumulator(valueFactory);
    }

    public Value evaluate(EvaluationVisitor evaluationVisitor, Value sourceValue, CallExp callExp) {
        try {
            CollectionValue collectionValue = sourceValue.asCollectionValue();
            return this.evaluate(evaluationVisitor, collectionValue, (LoopExp)callExp);
        }
        catch (InvalidValueException e) {
            return evaluationVisitor.throwInvalidEvaluation(e);
        }
    }

    protected Value evaluateIteration(IterationManager<ACC> iterationManager) {
        while (iterationManager.hasCurrent()) {
            Value resultVal = this.updateAccumulator(iterationManager);
            if (resultVal != null) {
                return resultVal;
            }
            iterationManager.advance();
        }
        return this.resolveTerminalValue(iterationManager);
    }

    protected Value resolveTerminalValue(IterationManager<ACC> iterationManager) {
        return iterationManager.getAccumulatorValue();
    }

    protected abstract Value updateAccumulator(IterationManager<ACC> var1);
}

