/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.ocl.examples.library.AbstractIteration;
import org.eclipse.ocl.examples.library.IterationManager;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsUniqueIteration
extends AbstractIteration<CollectionValue.Accumulator> {
    public static final IsUniqueIteration INSTANCE = new IsUniqueIteration();

    @Override
    public Value evaluate(EvaluationVisitor evaluationVisitor, CollectionValue sourceVal, LoopExp iteratorExp) {
        ValueFactory valueFactory = evaluationVisitor.getValueFactory();
        CollectionValue.Accumulator accumulatorValue = this.createAccumulationValue(valueFactory, true, false);
        return this.evaluateIteration(new IterationManager<CollectionValue.Accumulator>(evaluationVisitor, iteratorExp, sourceVal, accumulatorValue));
    }

    @Override
    protected Value resolveTerminalValue(IterationManager<CollectionValue.Accumulator> iterationManager) {
        return iterationManager.getTrue();
    }

    @Override
    protected Value updateAccumulator(IterationManager<CollectionValue.Accumulator> iterationManager) {
        CollectionValue.Accumulator accumulatorValue = iterationManager.getAccumulatorValue();
        Value bodyVal = iterationManager.getBodyValue();
        try {
            if (accumulatorValue.includes(bodyVal).isTrue()) {
                return iterationManager.getFalse();
            }
            accumulatorValue.add(bodyVal);
            return null;
        }
        catch (InvalidValueException e) {
            return iterationManager.throwInvalidEvaluation(e);
        }
    }
}

