/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.logical;

import org.eclipse.ocl.examples.library.AbstractBinaryOperation;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.values.BooleanValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;

public class BooleanOrOperation
extends AbstractBinaryOperation {
    public static final BooleanOrOperation INSTANCE = new BooleanOrOperation();

    public BooleanValue evaluate(EvaluationVisitor evaluationVisitor, Value sourceVal, OperationCallExp operationCall) throws InvalidValueException {
        ValueFactory valueFactory = evaluationVisitor.getValueFactory();
        if (sourceVal.isTrue()) {
            return valueFactory.getTrue();
        }
        Value argVal = this.evaluateArgument(evaluationVisitor, operationCall, 0);
        return this.evaluate(valueFactory, sourceVal, argVal);
    }

    public BooleanValue evaluate(ValueFactory valueFactory, Value left, Value right) throws InvalidValueException {
        if (left.isTrue() || right.isTrue()) {
            return valueFactory.getTrue();
        }
        return valueFactory.booleanValueOf(left.asBoolean() || right.asBoolean());
    }
}

