/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.oclany;

import org.eclipse.ocl.examples.library.AbstractOperation;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.TypeValue;
import org.eclipse.ocl.examples.pivot.values.Value;

public class OclAnyOclAsTypeOperation
extends AbstractOperation {
    public static final OclAnyOclAsTypeOperation INSTANCE = new OclAnyOclAsTypeOperation();

    public Value evaluate(EvaluationVisitor evaluationVisitor, Value sourceVal, OperationCallExp operationCall) throws InvalidValueException {
        TypeManager typeManager = evaluationVisitor.getTypeManager();
        Type sourceType = sourceVal.getType(typeManager, operationCall.getSource().getType());
        if (sourceType == null) {
            return evaluationVisitor.throwInvalidEvaluation(null, (OclExpression)operationCall, (Object)sourceType, EvaluatorMessages.MissingSourceType, new Object[0]);
        }
        Value argVal = this.evaluateArgument(evaluationVisitor, operationCall, 0);
        TypeValue typeVal = argVal.asTypeValue();
        Type argType = typeVal.getInstanceType();
        if (typeManager.conformsTo(sourceType, argType, null)) {
            return sourceVal;
        }
        return evaluationVisitor.throwInvalidEvaluation(null, (OclExpression)operationCall, (Object)argType, EvaluatorMessages.IncompatibleArgumentType, new Object[]{argType});
    }
}

