/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.string;

import org.eclipse.ocl.examples.library.AbstractBinaryOperation;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;

public class StringIndexOfOperation
extends AbstractBinaryOperation {
    public static final StringIndexOfOperation INSTANCE = new StringIndexOfOperation();

    public Value evaluate(ValueFactory valueFactory, Value left, Value right) throws InvalidValueException {
        String leftString = left.asString();
        String rightString = right.asString();
        if (leftString.length() <= 0) {
            return valueFactory.integerValueOf(0L);
        }
        if (rightString.length() <= 0) {
            return valueFactory.integerValueOf(1L);
        }
        int index = leftString.indexOf(rightString);
        if (index >= 0) {
            return valueFactory.integerValueOf((long)(index + 1));
        }
        return valueFactory.integerValueOf(0L);
    }
}

