/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.string;

import org.eclipse.ocl.examples.library.AbstractTernaryOperation;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;

public class StringSubstringOperation
extends AbstractTernaryOperation {
    public static final StringSubstringOperation INSTANCE = new StringSubstringOperation();

    public Value evaluate(ValueFactory valueFactory, Value source, Value arg1, Value arg2) throws InvalidValueException {
        String sourceString = source.asString();
        Integer startInteger = arg1.asInteger();
        Integer endInteger = arg2.asInteger();
        int size = sourceString.length();
        int lower = startInteger;
        int upper = endInteger;
        if (lower > 0 && lower <= upper && upper <= size) {
            return valueFactory.stringValueOf(sourceString.substring(lower - 1, upper));
        }
        return valueFactory.throwInvalidValueException(EvaluatorMessages.IndexesOutOfRange, new Object[]{lower, upper, size});
    }
}

