/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclinecore.services;

import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.essentialocl.services.EssentialOCLValueConverterService;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractNullSafeConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLinEcoreValueConverterService
extends EssentialOCLValueConverterService {
    private static IntegerConverter integerConverter = null;
    private static PrimitiveTypeIdentifierConverter primitiveTypeIdentifier = null;
    private static UnquotedStringConverter unquotedStringConverter = null;
    private static UpperConverter upperConverter = null;

    @ValueConverter(rule="LOWER")
    public IValueConverter<Integer> LOWER() {
        if (integerConverter == null) {
            integerConverter = new IntegerConverter();
        }
        return integerConverter;
    }

    @ValueConverter(rule="PrimitiveTypeIdentifier")
    public IValueConverter<String> PrimitiveTypeIdentifier() {
        if (primitiveTypeIdentifier == null) {
            primitiveTypeIdentifier = new PrimitiveTypeIdentifierConverter();
        }
        return primitiveTypeIdentifier;
    }

    @ValueConverter(rule="UNQUOTED_STRING")
    public IValueConverter<String> UNQUOTED_STRING() {
        if (unquotedStringConverter == null) {
            unquotedStringConverter = new UnquotedStringConverter();
        }
        return unquotedStringConverter;
    }

    @ValueConverter(rule="UPPER")
    public IValueConverter<Integer> UPPER() {
        if (upperConverter == null) {
            upperConverter = new UpperConverter();
        }
        return upperConverter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class IntegerConverter
    extends AbstractNullSafeConverter<Integer> {
        protected IntegerConverter() {
        }

        public Integer internalToValue(String string, INode node) {
            if (Strings.isEmpty((String)string)) {
                throw new ValueConverterException("Couldn't convert empty string to integer", node, null);
            }
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException e) {
                throw new ValueConverterException("Couldn't convert '" + string + "' to integer", node, (Exception)e);
            }
        }

        public String internalToString(Integer value) {
            return value.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrimitiveTypeIdentifierConverter
    extends AbstractNullSafeConverter<String> {
        protected PrimitiveTypeIdentifierConverter() {
        }

        public String internalToValue(String string, INode node) {
            return string;
        }

        public String internalToString(String value) {
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class UnquotedStringConverter
    extends AbstractNullSafeConverter<String> {
        protected UnquotedStringConverter() {
        }

        protected String internalToValue(String string, INode node) {
            try {
                return PivotUtil.convertFromOCLString((String)string.substring(1, string.length() - 1));
            }
            catch (IllegalArgumentException e) {
                throw new ValueConverterException(e.getMessage(), node, (Exception)e);
            }
        }

        protected String internalToString(String value) {
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class UpperConverter
    extends AbstractNullSafeConverter<Integer> {
        protected UpperConverter() {
        }

        public Integer internalToValue(String string, INode node) {
            if (Strings.isEmpty((String)string)) {
                throw new ValueConverterException("Couldn't convert empty string to integer", node, null);
            }
            try {
                if ("*".equals(string)) {
                    return -1;
                }
                return Integer.valueOf(string);
            }
            catch (NumberFormatException e) {
                throw new ValueConverterException("Couldn't convert '" + string + "' to integer", node, (Exception)e);
            }
        }

        public String internalToString(Integer value) {
            return value >= 0 ? value.toString() : "*";
        }
    }
}

