/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.cs2pivot;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.baseCST.AnnotationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassifierCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ConstraintCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.DataTypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.DocumentationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.EnumerationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.EnumerationLiteralCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ImportCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.LambdaTypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.LibraryCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.MonikeredElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.OperationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PackageCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ParameterableElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PrimitiveTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.RootPackageCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.StructuralFeatureCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateBindingCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateSignatureCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateableElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TuplePartCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TupleTypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.WildcardTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.impl.TypedTypeRefCSImpl;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.AbstractDependency;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.BasicContinuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuations;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Dependency;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.InterDependency;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.SingleContinuation;
import org.eclipse.ocl.examples.xtext.base.util.AbstractExtendingBaseCSVisitor;
import org.eclipse.ocl.examples.xtext.base.util.VisitableCS;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasePreOrderVisitor
extends AbstractExtendingBaseCSVisitor<Continuation<?>, CS2PivotConversion> {
    public BasePreOrderVisitor(CS2PivotConversion context) {
        super(context);
    }

    protected BasicContinuation<?> refreshClassifier(ClassifierCS csClassifier, Class pivotElement) {
        if (csClassifier.eIsSet((EStructuralFeature)BaseCSTPackage.Literals.CLASSIFIER_CS__INSTANCE_CLASS_NAME)) {
            pivotElement.setInstanceClassName(csClassifier.getInstanceClassName());
        } else {
            pivotElement.eUnset((EStructuralFeature)PivotPackage.Literals.TYPE__INSTANCE_CLASS_NAME);
        }
        String newInstanceClassName = csClassifier.getInstanceClassName();
        String oldInstanceClassName = pivotElement.getInstanceClassName();
        if (!(newInstanceClassName == oldInstanceClassName || newInstanceClassName != null && newInstanceClassName.equals(oldInstanceClassName))) {
            pivotElement.setInstanceClassName(newInstanceClassName);
        }
        if (csClassifier.getOwnedTemplateSignature() != null) {
            return new TemplateSignatureContinuation((CS2PivotConversion)((Object)this.context), (NamedElement)pivotElement, csClassifier);
        }
        if (pivotElement.getOwnedTemplateSignature() != null) {
            pivotElement.setOwnedTemplateSignature(null);
        }
        return null;
    }

    protected void refreshEnumerationLiterals(EnumerationCS csEnumeration, Enumeration pivotElement) {
        ArrayList<EnumerationLiteral> newPivotLiterals = new ArrayList<EnumerationLiteral>();
        for (EnumerationLiteralCS csEnumerationLiteral : csEnumeration.getOwnedLiterals()) {
            String moniker = csEnumerationLiteral.getMoniker();
            EnumerationLiteral pivotEnumerationLiteral = ((CS2PivotConversion)((Object)this.context)).refreshNamedElement(EnumerationLiteral.class, PivotPackage.Literals.ENUMERATION_LITERAL, csEnumerationLiteral);
            pivotEnumerationLiteral.setMoniker(moniker);
            newPivotLiterals.add(pivotEnumerationLiteral);
            pivotEnumerationLiteral.setValue(BigInteger.valueOf(csEnumerationLiteral.getValue()));
        }
        ((CS2PivotConversion)((Object)this.context)).refreshList((List)pivotElement.getOwnedLiterals(), newPivotLiterals);
    }

    protected void refreshProperties(ClassCS csClass, Class pivotElement) {
        ArrayList<Property> newPivotProperties = new ArrayList<Property>();
        for (StructuralFeatureCS csProperty : csClass.getOwnedProperty()) {
            String moniker = csProperty.getMoniker();
            Property pivotProperty = ((CS2PivotConversion)((Object)this.context)).refreshNamedElement(Property.class, PivotPackage.Literals.PROPERTY, csProperty);
            pivotProperty.setMoniker(moniker);
            newPivotProperties.add(pivotProperty);
        }
        ((CS2PivotConversion)((Object)this.context)).refreshList((List)pivotElement.getOwnedAttributes(), newPivotProperties);
    }

    @Override
    public Continuation<?> visiting(VisitableCS visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for CS2Pivot PreOrder pass");
    }

    @Override
    public Continuation<?> visitAnnotationCS(AnnotationCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitClassCS(ClassCS csClass) {
        Class pivotElement = ((CS2PivotConversion)((Object)this.context)).refreshNamedElement(Class.class, PivotPackage.Literals.CLASS, csClass);
        EList<String> qualifiers = csClass.getQualifier();
        pivotElement.setIsAbstract(qualifiers.contains("abstract"));
        pivotElement.setIsInterface(qualifiers.contains("interface"));
        pivotElement.setIsStatic(qualifiers.contains("static"));
        this.refreshProperties(csClass, pivotElement);
        Continuations continuations = new Continuations();
        continuations.add(this.refreshClassifier(csClass, pivotElement));
        continuations.add(new ClassContentContinuation((CS2PivotConversion)((Object)this.context), pivotElement, csClass));
        if (!(pivotElement instanceof AnyType)) {
            continuations.add(new ClassSupersContinuation((CS2PivotConversion)((Object)this.context), pivotElement, csClass));
        }
        return continuations.getContinuation();
    }

    @Override
    public Continuation<?> visitConstraintCS(ConstraintCS csConstraint) {
        return null;
    }

    @Override
    public Continuation<?> visitDataTypeCS(DataTypeCS csDataType) {
        DataType pivotElement = ((CS2PivotConversion)((Object)this.context)).refreshNamedElement(DataType.class, PivotPackage.Literals.DATA_TYPE, csDataType);
        EList<String> qualifiers = csDataType.getQualifier();
        pivotElement.setIsSerializable(qualifiers.contains("serializable"));
        return this.refreshClassifier(csDataType, (Class)pivotElement);
    }

    @Override
    public Continuation<?> visitDocumentationCS(DocumentationCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitEnumerationCS(EnumerationCS csEnumeration) {
        Enumeration pivotElement = ((CS2PivotConversion)((Object)this.context)).refreshNamedElement(Enumeration.class, PivotPackage.Literals.ENUMERATION, csEnumeration);
        this.refreshEnumerationLiterals(csEnumeration, pivotElement);
        EList<String> qualifiers = csEnumeration.getQualifier();
        pivotElement.setIsSerializable(qualifiers.contains("serializable"));
        return this.refreshClassifier(csEnumeration, (Class)pivotElement);
    }

    @Override
    public Continuation<?> visitEnumerationLiteralCS(EnumerationLiteralCS csEnumerationLiteral) {
        return null;
    }

    @Override
    public Continuation<?> visitLambdaTypeCS(LambdaTypeCS csLambdaType) {
        return new LambdaContinuation((CS2PivotConversion)((Object)this.context), csLambdaType);
    }

    @Override
    public Continuation<?> visitModelElementCS(ModelElementCS csModelElement) {
        return null;
    }

    @Override
    public Continuation<?> visitOperationCS(OperationCS csOperation) {
        return new OperationContinuation<OperationCS>((CS2PivotConversion)((Object)this.context), csOperation);
    }

    @Override
    public Continuation<?> visitPackageCS(PackageCS csPackage) {
        String oldNsURI;
        String newNsURI;
        String oldNsPrefix;
        Package pivotElement = ((CS2PivotConversion)((Object)this.context)).refreshPackage(Package.class, PivotPackage.Literals.PACKAGE, csPackage);
        String newNsPrefix = csPackage.getNsPrefix();
        if (!(newNsPrefix == (oldNsPrefix = pivotElement.getNsPrefix()) || newNsPrefix != null && newNsPrefix.equals(oldNsPrefix))) {
            pivotElement.setNsPrefix(newNsPrefix);
        }
        if (!((newNsURI = csPackage.getNsURI()) == (oldNsURI = pivotElement.getNsURI()) || newNsURI != null && newNsURI.equals(oldNsURI))) {
            pivotElement.setNsURI(newNsURI);
        }
        return new PackageContentContinuation((CS2PivotConversion)((Object)this.context), csPackage);
    }

    @Override
    public Continuation<?> visitPrimitiveTypeRefCS(PrimitiveTypeRefCS csPrimitiveTypeRef) {
        return new PrimitiveTypeRefContinuation((CS2PivotConversion)((Object)this.context), csPrimitiveTypeRef);
    }

    @Override
    public Continuation<?> visitRootPackageCS(RootPackageCS object) {
        for (LibraryCS csLibrary : object.getOwnedLibrary()) {
            csLibrary.getPackage();
        }
        for (ImportCS csImport : object.getOwnedImport()) {
            csImport.getNamespace();
        }
        return (Continuation)super.visitRootPackageCS(object);
    }

    @Override
    public Continuation<?> visitStructuralFeatureCS(StructuralFeatureCS csStructuralFeature) {
        Property pivotElement = ((CS2PivotConversion)((Object)this.context)).refreshTypedMultiplicityElement(Property.class, PivotPackage.Literals.PROPERTY, csStructuralFeature);
        EList<String> qualifiers = csStructuralFeature.getQualifier();
        pivotElement.setIsComposite(qualifiers.contains("composes"));
        pivotElement.setIsDerived(qualifiers.contains("derived"));
        pivotElement.setIsID(qualifiers.contains("id"));
        pivotElement.setIsReadOnly(qualifiers.contains("readonly"));
        pivotElement.setIsResolveProxies(ElementUtil.getQualifier(qualifiers, "resolve", "!resolve", true));
        pivotElement.setIsStatic(qualifiers.contains("static"));
        pivotElement.setIsTransient(qualifiers.contains("transient"));
        pivotElement.setIsUnsettable(qualifiers.contains("unsettable"));
        pivotElement.setIsVolatile(qualifiers.contains("volatile"));
        if (csStructuralFeature.eIsSet((EStructuralFeature)BaseCSTPackage.Literals.STRUCTURAL_FEATURE_CS__DEFAULT)) {
            pivotElement.setDefault(csStructuralFeature.getDefault());
        } else {
            pivotElement.eUnset((EStructuralFeature)PivotPackage.Literals.PROPERTY__DEFAULT);
        }
        return null;
    }

    @Override
    public Continuation<?> visitTemplateBindingCS(TemplateBindingCS csTemplateBinding) {
        if (csTemplateBinding.getOwnedParameterSubstitution().isEmpty()) {
            return null;
        }
        return new TemplateBindingContinuation((CS2PivotConversion)((Object)this.context), csTemplateBinding);
    }

    @Override
    public Continuation<?> visitTemplateSignatureCS(TemplateSignatureCS csTemplateSignature) {
        return null;
    }

    @Override
    public Continuation<?> visitTupleTypeCS(TupleTypeCS csTupleType) {
        return new TupleContinuation((CS2PivotConversion)((Object)this.context), csTupleType);
    }

    @Override
    public Continuation<?> visitTypedTypeRefCS(TypedTypeRefCS csTypedTypeRef) {
        return new TypeRefContinuation((CS2PivotConversion)((Object)this.context), csTypedTypeRef);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ClassContentContinuation
    extends SingleContinuation<ClassCS> {
        public ClassContentContinuation(CS2PivotConversion context, Class pivotParent, ClassCS csElement) {
            super(context, (Element)pivotParent, null, csElement, context.getOperationsHaveTemplateParametersInterDependency());
        }

        @Override
        public BasicContinuation<?> execute() {
            Class pivotElement = (Class)PivotUtil.getPivot(Class.class, (Pivotable)((Pivotable)this.csElement));
            ArrayList<Operation> newPivotOperations = new ArrayList<Operation>();
            for (OperationCS csOperation : ((ClassCS)this.csElement).getOwnedOperation()) {
                Operation pivotOperation = (Operation)PivotUtil.getPivot(Operation.class, (Pivotable)csOperation);
                newPivotOperations.add(pivotOperation);
            }
            this.context.refreshList((List)pivotElement.getOwnedOperations(), newPivotOperations);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ClassSupersContinuation
    extends SingleContinuation<ClassCS> {
        public ClassSupersContinuation(CS2PivotConversion context, Class pivotParent, ClassCS csElement) {
            super(context, (Element)pivotParent, null, csElement, new Dependency[0]);
        }

        @Override
        public boolean canExecute() {
            if (!super.canExecute()) {
                return false;
            }
            for (TypedRefCS csSuperType : ((ClassCS)this.csElement).getOwnedSuperType()) {
                if (csSuperType.getPivot() != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public BasicContinuation<?> execute() {
            Class pivotElement = (Class)PivotUtil.getPivot(Class.class, (Pivotable)((Pivotable)this.csElement));
            EList superClasses = pivotElement.getSuperClasses();
            this.context.refreshList(Class.class, superClasses, (List<? extends MonikeredElementCS>)((ClassCS)this.csElement).getOwnedSuperType());
            if (superClasses.isEmpty()) {
                Class classType;
                ClassifierType classifierType = this.context.getTypeManager().getClassifierType();
                if (classifierType != null) {
                    superClasses.add(classifierType);
                }
                if ((classType = (Class)this.context.getTypeManager().getPivotType("Class")) != null) {
                    superClasses.add(classType);
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LambdaContinuation
    extends SingleContinuation<LambdaTypeCS> {
        public LambdaContinuation(CS2PivotConversion context, LambdaTypeCS csElement) {
            super(context, null, null, csElement, context.getPackagesHaveTypesInterDependency());
        }

        @Override
        public boolean canExecute() {
            if (!super.canExecute()) {
                return false;
            }
            if (((LambdaTypeCS)this.csElement).getOwnedContextType().getPivot() == null) {
                return false;
            }
            if (((LambdaTypeCS)this.csElement).getOwnedResultType().getPivot() == null) {
                return false;
            }
            for (TypedRefCS csParameterType : ((LambdaTypeCS)this.csElement).getOwnedParameterType()) {
                if (csParameterType.getPivot() != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public BasicContinuation<?> execute() {
            String moniker = ((LambdaTypeCS)this.csElement).getMoniker();
            Type contextType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)((LambdaTypeCS)this.csElement).getOwnedContextType());
            Type resultType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)((LambdaTypeCS)this.csElement).getOwnedResultType());
            ArrayList<Type> parameterTypes = new ArrayList<Type>();
            for (TypedRefCS csParameterType : ((LambdaTypeCS)this.csElement).getOwnedParameterType()) {
                Type parameterType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csParameterType);
                parameterTypes.add(parameterType);
            }
            LambdaType lambdaType = this.context.getTypeManager().getLambdaType(((LambdaTypeCS)this.csElement).getName(), contextType, parameterTypes, resultType, null, moniker);
            this.context.reusePivotElement((ModelElementCS)this.csElement, (Element)lambdaType);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OperationContinuation<T extends OperationCS>
    extends SingleContinuation<T> {
        public OperationContinuation(CS2PivotConversion context, T csElement) {
            super(context, null, null, csElement, context.getTypesHaveSignaturesInterDependency());
            context.getOperationsHaveTemplateParametersInterDependency().addDependency(this);
        }

        @Override
        public BasicContinuation<?> execute() {
            String moniker = ((OperationCS)this.csElement).getMoniker();
            Operation pivotOperation = this.context.refreshTypedMultiplicityElement(Operation.class, PivotPackage.Literals.OPERATION, (TypedElementCS)this.csElement);
            pivotOperation.setMoniker(moniker);
            this.context.refreshTemplateSignature((TemplateableElementCS)this.csElement, (TemplateableElement)pivotOperation);
            this.refreshParameters((List<ParameterCS>)((OperationCS)this.csElement).getOwnedParameter(), (List<Parameter>)pivotOperation.getOwnedParameters());
            this.context.refreshList(Type.class, pivotOperation.getRaisedExceptions(), (List<? extends MonikeredElementCS>)((OperationCS)this.csElement).getOwnedException());
            this.context.getOperationsHaveTemplateParametersInterDependency().setSatisfied(this);
            return null;
        }

        protected void refreshParameters(List<ParameterCS> csParameters, List<Parameter> pivotParameters) {
            ArrayList<Parameter> newPivotParameters = new ArrayList<Parameter>();
            for (ParameterCS csParameter : csParameters) {
                String moniker = csParameter.getMoniker();
                Parameter pivotParameter = this.context.refreshTypedMultiplicityElement(Parameter.class, PivotPackage.Literals.PARAMETER, csParameter);
                pivotParameter.setMoniker(moniker);
                newPivotParameters.add(pivotParameter);
            }
            this.context.refreshList(pivotParameters, newPivotParameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PackageContentContinuation
    extends SingleContinuation<PackageCS> {
        private PackageContentContinuation(CS2PivotConversion context, PackageCS csElement) {
            super(context, null, null, csElement, new Dependency[0]);
            context.getPackagesHaveTypesInterDependency().addDependency(this);
        }

        @Override
        public BasicContinuation<?> execute() {
            Package pivotElement = (Package)PivotUtil.getPivot(Package.class, (Pivotable)((Pivotable)this.csElement));
            this.context.refreshPivotList(Type.class, pivotElement.getOwnedTypes(), (List<? extends ModelElementCS>)((PackageCS)this.csElement).getOwnedType());
            this.context.refreshPivotList(Package.class, pivotElement.getNestedPackages(), (List<? extends ModelElementCS>)((PackageCS)this.csElement).getOwnedNestedPackage());
            this.context.getPackagesHaveTypesInterDependency().setSatisfied(this);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrimitiveTypeRefContinuation
    extends SingleContinuation<PrimitiveTypeRefCS> {
        public PrimitiveTypeRefContinuation(CS2PivotConversion context, PrimitiveTypeRefCS csElement) {
            super(context, null, null, csElement, context.getPackagesHaveTypesInterDependency());
        }

        @Override
        public BasicContinuation<?> execute() {
            Type type = this.context.getTypeManager().getLibraryType(((PrimitiveTypeRefCS)this.csElement).getName());
            this.context.reusePivotElement((ModelElementCS)this.csElement, (Element)type);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TemplateBindingContinuation
    extends SingleContinuation<TemplateBindingCS> {
        public TemplateBindingContinuation(CS2PivotConversion context, TemplateBindingCS csElement) {
            super(context, csElement.getOwningTemplateBindableElement().getPivot(), (EStructuralFeature)PivotPackage.Literals.TEMPLATEABLE_ELEMENT__TEMPLATE_BINDING, csElement, context.getPackagesHaveTypesInterDependency());
            context.getTypesHaveSpecializationsInterDependency().addDependency(this);
        }

        @Override
        public boolean canExecute() {
            Type unspecializedPivotElement;
            if (!super.canExecute()) {
                return false;
            }
            TypedTypeRefCS csParameterizedTypeRef = ((TemplateBindingCS)this.csElement).getOwningTemplateBindableElement();
            if (csParameterizedTypeRef instanceof TypedTypeRefCSImpl && (unspecializedPivotElement = ((TypedTypeRefCSImpl)csParameterizedTypeRef).basicGetType()) == null) {
                return false;
            }
            for (TemplateParameterSubstitutionCS csTemplateParameterSubstitution : ((TemplateBindingCS)this.csElement).getOwnedParameterSubstitution()) {
                Element pivot;
                ParameterableElementCS csTemplateParameter = csTemplateParameterSubstitution.getOwnedActualParameter();
                if (csTemplateParameter instanceof WildcardTypeRefCS || (pivot = csTemplateParameter.getPivot()) != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public BasicContinuation<?> execute() {
            boolean isSpecialization = ElementUtil.isSpecialization((TemplateBindingCS)this.csElement);
            if (isSpecialization) {
                TypedTypeRefCS csTypedTypeRef = ((TemplateBindingCS)this.csElement).getOwningTemplateBindableElement();
                Type type = (Type)this.context.specializeTemplates(csTypedTypeRef);
            }
            this.context.getTypesHaveSpecializationsInterDependency().setSatisfied(this);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TemplateSignatureContinuation
    extends SingleContinuation<ClassifierCS> {
        public TemplateSignatureContinuation(CS2PivotConversion context, NamedElement pivotParent, ClassifierCS csElement) {
            super(context, (Element)pivotParent, (EStructuralFeature)PivotPackage.Literals.TEMPLATEABLE_ELEMENT__OWNED_TEMPLATE_SIGNATURE, csElement, new Dependency[0]);
            context.getTypesHaveSignaturesInterDependency().addDependency(this);
        }

        @Override
        public BasicContinuation<?> execute() {
            Type pivotElement = (Type)PivotUtil.getPivot(Type.class, (Pivotable)((Pivotable)this.csElement));
            this.context.refreshTemplateSignature((TemplateableElementCS)this.csElement, (TemplateableElement)pivotElement);
            this.context.getTypesHaveSignaturesInterDependency().setSatisfied(this);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TupleContinuation
    extends SingleContinuation<TupleTypeCS> {
        public TupleContinuation(CS2PivotConversion context, TupleTypeCS csElement) {
            super(context, null, null, csElement, context.getPackagesHaveTypesInterDependency());
        }

        @Override
        public boolean canExecute() {
            if (!super.canExecute()) {
                return false;
            }
            for (TuplePartCS csTuplePart : ((TupleTypeCS)this.csElement).getOwnedParts()) {
                TypedRefCS ownedType = csTuplePart.getOwnedType();
                if (ownedType.getPivot() != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public BasicContinuation<?> execute() {
            ArrayList<TypeManager.TuplePart> tupleParts = new ArrayList<TypeManager.TuplePart>();
            for (TuplePartCS csTuplePart : ((TupleTypeCS)this.csElement).getOwnedParts()) {
                Type partType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csTuplePart.getOwnedType());
                tupleParts.add(new TypeManager.TuplePart(csTuplePart.getName(), partType));
            }
            TupleType tupleType = this.context.getTypeManager().getTupleType(((TupleTypeCS)this.csElement).getName(), tupleParts, null, ((TupleTypeCS)this.csElement).getMoniker());
            this.context.reusePivotElement((ModelElementCS)this.csElement, (Element)tupleType);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TypeRefContinuation
    extends SingleContinuation<TypedTypeRefCS> {
        private static Dependency[] computeDependencies(CS2PivotConversion context, TypedTypeRefCS csElement) {
            InterDependency<TemplateSignatureContinuation> typeDependency = context.getTypesHaveSignaturesInterDependency();
            TemplateBindingCS csTemplateBinding = csElement.getOwnedTemplateBinding();
            if (csTemplateBinding == null) {
                return new Dependency[]{typeDependency};
            }
            return new Dependency[]{typeDependency, new TemplateBindingPivotDependency(csTemplateBinding)};
        }

        public TypeRefContinuation(CS2PivotConversion context, TypedTypeRefCS csElement) {
            super(context, null, null, csElement, TypeRefContinuation.computeDependencies(context, csElement));
        }

        @Override
        public boolean canExecute() {
            if (!super.canExecute()) {
                return false;
            }
            this.context.resolveNamespaces((List<Namespace>)((TypedTypeRefCS)this.csElement).getNamespace());
            return true;
        }

        @Override
        public BasicContinuation<?> execute() {
            Type pivotType = ((TypedTypeRefCS)this.csElement).getType();
            if (pivotType.eIsProxy()) {
                InvalidType badType = this.context.addBadTypeError((ModelElementCS)this.csElement, OCLMessages.UnresolvedType_ERROR_, this.csElement);
                ((TypedTypeRefCS)this.csElement).setType((Type)badType);
            } else {
                TemplateBindingCS csTemplateBinding = ((TypedTypeRefCS)this.csElement).getOwnedTemplateBinding();
                if (csTemplateBinding != null && ElementUtil.isSpecialization(csTemplateBinding)) {
                    TemplateBinding pivotTemplateBinding = (TemplateBinding)PivotUtil.getPivot(TemplateBinding.class, (Pivotable)csTemplateBinding);
                    pivotType = pivotTemplateBinding.getBoundElement();
                }
                this.context.installPivotElement((ModelElementCS)this.csElement, (Element)pivotType);
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static final class TemplateBindingPivotDependency
        extends AbstractDependency<TemplateBindingCS> {
            protected TemplateBindingPivotDependency(TemplateBindingCS csElement) {
                super(csElement);
            }

            @Override
            public boolean canExecute() {
                boolean isSpecialization = false;
                TypedTypeRefCS csTypedTypeRef = ((TemplateBindingCS)this.element).getOwningTemplateBindableElement();
                Element type = csTypedTypeRef.getPivot();
                if (type == null) {
                    return false;
                }
                for (TemplateParameterSubstitutionCS csTemplateParameterSubstitution : ((TemplateBindingCS)this.element).getOwnedParameterSubstitution()) {
                    ParameterableElementCS ownedActualParameter = csTemplateParameterSubstitution.getOwnedActualParameter();
                    Class actualParameterClass = (Class)ownedActualParameter.getPivot();
                    if (actualParameterClass == null) {
                        return false;
                    }
                    TemplateParameter owningTemplateParameter = actualParameterClass.getOwningTemplateParameter();
                    if (owningTemplateParameter == null) {
                        isSpecialization = true;
                        continue;
                    }
                    TemplateSignature signature = owningTemplateParameter.getSignature();
                    TemplateableElement template = signature.getTemplate();
                    if (template == type) continue;
                    isSpecialization = true;
                }
                return !isSpecialization || ((TemplateBindingCS)this.element).getPivot() != null;
            }
        }
    }
}

