/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.pivot2cs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.examples.pivot.MonikeredElement;
import org.eclipse.ocl.examples.pivot.internal.impl.MonikeredElementImpl;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.baseCST.MonikeredElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.impl.MonikeredElementCSImpl;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.BaseDeclarationVisitor;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.BaseReferenceVisitor;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.Pivot2CSConversion;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2CS
extends AbstractConversion
implements Adapter {
    private static final Logger logger = Logger.getLogger(Pivot2CS.class);
    private static Map<EClass, Factory> factoryMap = new HashMap<EClass, Factory>();
    protected final TypeManager typeManager;
    protected final Map<? extends Resource, ? extends Resource> cs2pivotResourceMap;
    protected final Map<String, MonikeredElement> moniker2PivotMap;
    protected Map<String, MonikeredElementCS> moniker2PivotCSMap1 = null;

    public static void addFactory(Factory factory) {
        EClass[] eClassArray = factory.getEClasses();
        int n = eClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            factoryMap.put(eClass, factory);
            ++n2;
        }
    }

    public static Pivot2CS findAdapter(ResourceSet resourceSet) {
        if (resourceSet == null) {
            return null;
        }
        return (Pivot2CS)((Object)PivotUtil.getAdapter(Pivot2CS.class, (Notifier)resourceSet));
    }

    public static List<ILeafNode> getDocumentationNodes(ICompositeNode node) {
        ArrayList<ILeafNode> documentationNodes = null;
        for (INode childNode : node.getChildren()) {
            ILeafNode leafNode;
            EObject grammarElement;
            if (!(childNode instanceof ILeafNode) || !((grammarElement = (leafNode = (ILeafNode)childNode).getGrammarElement()) instanceof TerminalRule)) break;
            TerminalRule terminalRule = (TerminalRule)grammarElement;
            String name = terminalRule.getName();
            if ("DOCUMENTATION".equals(name)) {
                if (documentationNodes == null) {
                    documentationNodes = new ArrayList<ILeafNode>();
                }
                documentationNodes.add(leafNode);
                continue;
            }
            if (!"WS".equals(name) && !"SL_COMMENT".equals(name) && !"ML_COMMENT".equals(name)) break;
        }
        return documentationNodes;
    }

    public Pivot2CS(Map<? extends Resource, ? extends Resource> cs2pivotResourceMap, TypeManager typeManager) {
        this.cs2pivotResourceMap = cs2pivotResourceMap;
        this.typeManager = typeManager;
        this.moniker2PivotMap = typeManager.computeMoniker2PivotMap(this.getPivotResources());
        typeManager.getPivotResourceSet().eAdapters().add((Object)this);
    }

    public Pivot2CS(Pivot2CS aConverter) {
        this.cs2pivotResourceMap = aConverter.cs2pivotResourceMap;
        this.typeManager = aConverter.typeManager;
        this.moniker2PivotMap = this.typeManager.computeMoniker2PivotMap(this.getPivotResources());
    }

    public Map<String, MonikeredElementCS> computeMoniker2CSMap(Collection<? extends Resource> csResources) {
        HashMap<String, MonikeredElementCS> map = new HashMap<String, MonikeredElementCS>();
        for (Resource resource : csResources) {
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                if (!(eObject instanceof MonikeredElementCS)) continue;
                MonikeredElementCS monikeredElement = (MonikeredElementCS)eObject;
                String moniker = monikeredElement.getMoniker();
                assert (moniker != null);
                MonikeredElementCS oldMonikeredElement = (MonikeredElementCS)map.get(moniker);
                if (monikeredElement instanceof NamedElementCS) {
                    if (oldMonikeredElement instanceof NamedElementCS) {
                        logger.warn((Object)("Duplicate CS '" + moniker + "'"));
                        continue;
                    }
                    map.put(moniker, monikeredElement);
                    continue;
                }
                if (oldMonikeredElement != null) continue;
                map.put(moniker, monikeredElement);
            }
        }
        return map;
    }

    public Collection<? extends Resource> getCSResources() {
        return this.cs2pivotResourceMap.keySet();
    }

    public Factory getFactory(EClass eClass) {
        return factoryMap.get(eClass);
    }

    public Set<String> getMonikers() {
        return this.moniker2PivotMap.keySet();
    }

    public MonikeredElement getPivotElement(String moniker) {
        return this.moniker2PivotMap.get(moniker);
    }

    public Resource getPivotResource(Resource csResource) {
        return this.cs2pivotResourceMap.get(csResource);
    }

    public Collection<? extends Resource> getPivotResources() {
        return this.cs2pivotResourceMap.values();
    }

    public Notifier getTarget() {
        return this.typeManager.getPivotResourceSet();
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public boolean isAdapterForType(Object type) {
        return type == Pivot2CS.class;
    }

    public void notifyChanged(Notification notification) {
    }

    public MonikeredElement putPivotElement(String moniker, MonikeredElement pivotElement) {
        MonikeredElement oldElement = this.moniker2PivotMap.put(moniker, pivotElement);
        if (oldElement != null) assert (oldElement == pivotElement);
        return oldElement;
    }

    public void resetCSMonikers() {
        for (Resource resource : this.getCSResources()) {
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                if (!(eObject instanceof MonikeredElementCSImpl)) continue;
                ((MonikeredElementCSImpl)eObject).resetMoniker();
            }
        }
    }

    public void resetPivotMonikers() {
        for (Resource resource : this.getPivotResources()) {
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                if (!(eObject instanceof MonikeredElementImpl)) continue;
                ((MonikeredElementImpl)eObject).resetMoniker();
            }
        }
    }

    public void setTarget(Notifier newTarget) {
        assert (newTarget == this.typeManager.getPivotResourceSet());
    }

    public void update() {
        Pivot2CSConversion conversion = new Pivot2CSConversion(this);
        conversion.update(this.getCSResources());
    }

    public BaseDeclarationVisitor createDefaultDeclarationVisitor(Pivot2CSConversion conversion) {
        return new BaseDeclarationVisitor(conversion);
    }

    public BaseReferenceVisitor createDefaultReferenceVisitor(Pivot2CSConversion conversion) {
        return new BaseReferenceVisitor(conversion);
    }

    public static interface Factory {
        public BaseDeclarationVisitor createDeclarationVisitor(Pivot2CSConversion var1);

        public BaseReferenceVisitor createReferenceVisitor(Pivot2CSConversion var1);

        public EClass[] getEClasses();
    }
}

