/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.scope;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.scope.EnvironmentView;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeView;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseScopeView
extends AbstractScope
implements ScopeView {
    protected final TypeManager typeManager;
    protected final ScopeAdapter scopeAdapter;
    protected final EObject child;
    protected final EStructuralFeature containmentFeature;
    protected final EReference targetReference;

    @Deprecated
    private static ScopeView getParent(TypeManager typeManager, ScopeAdapter scopeAdapter, EReference targetReference) {
        ScopeAdapter parent = scopeAdapter.getParent();
        if (parent == null) {
            return ScopeView.NULLSCOPEVIEW;
        }
        EObject target = scopeAdapter.getTarget();
        EStructuralFeature eContainingFeature = target.eContainingFeature();
        return new BaseScopeView(typeManager, parent, target, eContainingFeature, targetReference);
    }

    public BaseScopeView(TypeManager typeManager, ScopeAdapter scopeAdapter, EObject child, EStructuralFeature containmentFeature, EReference targetReference) {
        super((IScope)BaseScopeView.getParent(typeManager, scopeAdapter, targetReference), false);
        this.typeManager = typeManager;
        this.scopeAdapter = scopeAdapter;
        this.child = child;
        this.containmentFeature = containmentFeature;
        this.targetReference = targetReference;
    }

    public BaseScopeView(TypeManager typeManager, ScopeView scopeView) {
        super((IScope)BaseScopeView.getParent(typeManager, scopeView.getScopeAdapter(), scopeView.getTargetReference()), false);
        this.typeManager = typeManager;
        this.scopeAdapter = scopeView.getScopeAdapter();
        this.child = scopeView.getChild();
        this.containmentFeature = scopeView.getContainmentFeature();
        this.targetReference = scopeView.getTargetReference();
    }

    @Override
    public void computeLookupWithParents(EnvironmentView environmentView) {
        ScopeView outerScope = this.scopeAdapter.computeLookup(environmentView, this);
        if (outerScope != null && !environmentView.hasFinalResult()) {
            outerScope.computeLookupWithParents(environmentView);
        }
    }

    public Iterable<IEObjectDescription> getAllElements() {
        EnvironmentView environmentView = new EnvironmentView(this.typeManager, (EStructuralFeature)this.targetReference, null);
        try {
            this.computeLookupWithParents(environmentView);
        }
        catch (IllegalLibraryException illegalLibraryException) {
            // empty catch block
        }
        return environmentView.getDescriptions();
    }

    @Override
    public EObject getChild() {
        return this.child;
    }

    @Override
    public EStructuralFeature getContainmentFeature() {
        return this.containmentFeature;
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        EnvironmentView environmentView = new EnvironmentView(this.typeManager, (EStructuralFeature)this.targetReference, name.toString());
        int size = environmentView.computeLookups(this);
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            return Collections.singletonList(environmentView.getDescription());
        }
        List<IEObjectDescription> contents = environmentView.getDescriptions();
        return contents;
    }

    public Iterable<IEObjectDescription> getElements(EObject object) {
        return super.getElements(object);
    }

    public IEObjectDescription getSingleElement(EObject object) {
        if (object instanceof NamedElement) {
            return EObjectDescription.create((String)((NamedElement)object).getName(), (EObject)object);
        }
        return super.getSingleElement(object);
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        EnvironmentView environmentView = new EnvironmentView(this.typeManager, (EStructuralFeature)this.targetReference, name.toString());
        int size = environmentView.computeLookups(this);
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            return environmentView.getDescription();
        }
        return null;
    }

    @Override
    @Deprecated
    public ScopeView getOuterScope() {
        return (ScopeView)this.getParent();
    }

    @Override
    public ScopeAdapter getScopeAdapter() {
        return this.scopeAdapter;
    }

    @Override
    public final EObject getTarget() {
        return this.scopeAdapter.getTarget();
    }

    @Override
    public EReference getTargetReference() {
        return this.targetReference;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    protected final Iterable<IEObjectDescription> getAllLocalElements() {
        EnvironmentView environmentView = new EnvironmentView(this.typeManager, (EStructuralFeature)this.targetReference, null);
        this.scopeAdapter.computeLookup(environmentView, this);
        return environmentView.getDescriptions();
    }

    public String toString() {
        EObject target = this.getTarget();
        StringBuffer s = new StringBuffer();
        s.append("[");
        s.append(target.eClass().getName());
        if (this.containmentFeature != null) {
            s.append("::");
            s.append(this.containmentFeature.getName());
        }
        s.append("] ");
        s.append(String.valueOf(target));
        return s.toString();
    }
}

