/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.scoping.cs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.MonikeredElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassifierCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.MonikeredElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PrimitiveTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.scoping.cs.MonikeredElementCSScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCSScopeAdapter<CS extends MonikeredElementCS, P extends MonikeredElement>
extends MonikeredElementCSScopeAdapter<CS, P> {
    protected BaseCSScopeAdapter(TypeManager typeManager, CS csElement, Class<P> pivotClass) {
        super(typeManager, csElement, pivotClass);
    }

    protected BaseCSScopeAdapter(TypeManager typeManager, EObject csDocumentElement, CS csElement, Class<P> pivotClass) {
        super(typeManager, csDocumentElement, csElement, pivotClass);
    }

    protected Type commonConformantType(Type firstTypeCS, Type secondTypeCS) {
        return firstTypeCS;
    }

    protected boolean conformsTo(Type candidateType, Type requiredType) {
        if (candidateType == requiredType) {
            return true;
        }
        if (candidateType instanceof org.eclipse.ocl.examples.pivot.Class) {
            for (org.eclipse.ocl.examples.pivot.Class superType : ((org.eclipse.ocl.examples.pivot.Class)candidateType).getSuperClasses()) {
                if (!this.conformsTo((Type)superType, requiredType)) continue;
                return true;
            }
        } else {
            candidateType = this.typeManager.getClassifierType();
            if (candidateType == requiredType) {
                return true;
            }
        }
        return false;
    }

    public List<Type> getConformsTo(ClassCS csClass) {
        EList<TypedRefCS> superTypes = csClass.getOwnedSuperType();
        int size = superTypes.size();
        if (size == 0) {
            ClassifierType libType = this.typeManager.getClassifierType();
            return Collections.singletonList(libType);
        }
        if (size == 1) {
            Type result = this.getLibraryType((ElementCS)superTypes.get(0));
            if (result != null) {
                return Collections.singletonList(result);
            }
        } else {
            ArrayList<Type> results = new ArrayList<Type>(size);
            for (TypedRefCS csTypedRefCS : superTypes) {
                Type result = this.getLibraryType(csTypedRefCS);
                if (result == null) continue;
                results.add(result);
            }
            return results;
        }
        return Collections.emptyList();
    }

    public Type getLibraryType(ElementCS csElement) {
        if (csElement == null) {
            return null;
        }
        if (csElement.eIsProxy()) {
            return null;
        }
        if (csElement instanceof ClassCS) {
            return (Type)csElement;
        }
        if (csElement instanceof ClassifierCS) {
            Element eObject = ((ClassifierCS)csElement).getPivot();
            if (eObject == EcorePackage.Literals.EBIG_DECIMAL) {
                return this.typeManager.getRealType();
            }
            if (eObject == EcorePackage.Literals.EBIG_INTEGER) {
                return this.typeManager.getIntegerType();
            }
            if (eObject == EcorePackage.Literals.EBOOLEAN) {
                return this.typeManager.getBooleanType();
            }
            if (eObject == EcorePackage.Literals.EBOOLEAN_OBJECT) {
                return this.typeManager.getBooleanType();
            }
            if (eObject == EcorePackage.Literals.EDOUBLE) {
                return this.typeManager.getRealType();
            }
            if (eObject == EcorePackage.Literals.EDOUBLE_OBJECT) {
                return this.typeManager.getRealType();
            }
            if (eObject == EcorePackage.Literals.EINT) {
                return this.typeManager.getIntegerType();
            }
            if (eObject == EcorePackage.Literals.EINTEGER_OBJECT) {
                return this.typeManager.getIntegerType();
            }
            if (eObject == EcorePackage.Literals.ESTRING) {
                return this.typeManager.getStringType();
            }
            return (Type)((ClassifierCS)csElement).getPivot();
        }
        if (csElement instanceof TypedElementCS) {
            TypedElementCS typedElement = (TypedElementCS)csElement;
            TypedRefCS type = typedElement.getOwnedType();
            String collectionTypeName = ElementUtil.getCollectionTypeName(typedElement);
            Type csType = this.getLibraryType(type);
            if (collectionTypeName != null) {
                return this.typeManager.getCollectionType(collectionTypeName, csType);
            }
            return csType;
        }
        if (csElement instanceof PrimitiveTypeRefCS) {
            PrimitiveTypeRefCS primitiveTypeRefCS = (PrimitiveTypeRefCS)csElement;
            String name = primitiveTypeRefCS.getName();
            return this.typeManager.getLibraryType(name);
        }
        if (csElement instanceof TypedTypeRefCS) {
            TypedTypeRefCS typedTypeRefCS = (TypedTypeRefCS)csElement;
            Type type = typedTypeRefCS.getType();
            if (type.eIsProxy()) {
                return null;
            }
            return type;
        }
        if (csElement instanceof TypeParameterCS) {
            TypeParameterCS typeParameter = (TypeParameterCS)csElement;
            throw new UnsupportedOperationException("getLibraryType(TypeParameterCS)");
        }
        throw new UnsupportedOperationException("getLibraryType()");
    }
}

