/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.parser.environment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.examples.parser.environment.CSTEnvironment;
import org.eclipse.ocl.examples.parser.environment.ICSTEnvironment;
import org.eclipse.ocl.examples.parser.environment.ICSTNodeEnvironment;
import org.eclipse.ocl.examples.parser.environment.IHasName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CSTNodeEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E, V extends ICSTNodeEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>, AST extends Notifier, CST extends CSTNode>
extends CSTEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E, V>
implements ICSTNodeEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>,
Adapter {
    protected AST ast;
    protected CST cst;

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E, V extends ICSTNodeEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>> V getEnvironmentFromAST(Notifier ast, Class<V> envClass) {
        if (ast != null) {
            ICSTNodeEnvironment adapter = (ICSTNodeEnvironment)EcoreUtil.getAdapter((List)ast.eAdapters(), envClass);
            return (V)adapter;
        }
        return null;
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E, V extends ICSTNodeEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>> V getEnvironmentFromCST(CSTNode cst, Class<V> envClass) {
        Object ast = cst.getAst();
        if (ast instanceof Notifier) {
            ICSTNodeEnvironment adapter = (ICSTNodeEnvironment)EcoreUtil.getAdapter((List)((Notifier)ast).eAdapters(), envClass);
            return (V)adapter;
        }
        return null;
    }

    protected CSTNodeEnvironment(ICSTEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parent, AST astNode, CST cstNode) {
        super(parent);
        assert (cstNode != null);
        this.ast = astNode;
        this.cst = cstNode;
        if (astNode != null) {
            this.internalSetAdapter();
        }
    }

    @Override
    public String formatLookupException(LookupException e) {
        List matches = e.getAmbiguousMatches();
        ArrayList<String> matchNames = new ArrayList<String>();
        for (Object match : matches) {
            matchNames.add(this.formatQualifiedName(match));
        }
        Collections.sort(matchNames);
        StringBuilder s = new StringBuilder();
        s.append(e.getMessage());
        String separator = " { ";
        for (String matchName : matchNames) {
            s.append(separator);
            s.append(matchName);
            separator = ", ";
        }
        s.append(" }");
        return s.toString();
    }

    public String formatName(Object object) {
        return this.getFormatter().formatName(object);
    }

    public String formatPath(List<String> names) {
        return this.getFormatter().formatPath(names);
    }

    @Deprecated
    public String formatPathName(Object object) {
        return this.formatQualifiedName(object);
    }

    public String formatQualifiedName(Object object) {
        return this.getFormatter().formatQualifiedName(object);
    }

    public String formatString(String string) {
        return this.getFormatter().formatString(string);
    }

    public String formatType(Object type) {
        return this.getFormatter().formatType(type);
    }

    @Override
    public AST getASTNode() {
        return this.ast;
    }

    public CST getCSTNode() {
        return this.cst;
    }

    public Notifier getTarget() {
        return this.ast;
    }

    protected void internalSetAST(AST astNode) {
        assert (this.ast == null == (astNode != null));
        this.ast = astNode;
    }

    protected void internalSetAdapter() {
        this.ast.eAdapters().add((Object)this);
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(this.getClass());
    }

    public C lookupClassifier(List<String> names) {
        return this.getFileEnvironment().lookupClassifier(this.getContextPackage(), names);
    }

    public void notifyChanged(Notification notification) {
    }

    @Deprecated
    public CSTNode setCSTNode(CSTNode cstNode) {
        CST oldCSTNode = this.cst;
        this.cst = cstNode;
        return oldCSTNode;
    }

    public final void setTarget(Notifier newTarget) {
        if (newTarget == null) {
            this.internalSetAST(null);
        } else if (newTarget != this.ast) {
            throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".setTarget");
        }
    }

    public String toString() {
        String parentString = this.getInternalParent() != null ? String.valueOf(this.getInternalParent().toString()) + "." : "";
        CST cstNode = this.getCSTNode();
        String childString = cstNode instanceof IHasName ? ((IHasName)cstNode).getName() : this.getClass().getSimpleName();
        return String.valueOf(parentString) + childString;
    }
}

