/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.parser.environment;

import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.lpg.ProblemHandler;

public class ProblemHandlerDiagnosticChain
implements DiagnosticChain {
    protected final BasicEnvironment environment;
    protected final ProblemHandler problemHandler;

    public ProblemHandlerDiagnosticChain(ProblemHandler problemHandler) {
        this.environment = null;
        this.problemHandler = problemHandler;
    }

    public ProblemHandlerDiagnosticChain(BasicEnvironment environment) {
        this.environment = environment;
        this.problemHandler = environment.getProblemHandler();
    }

    public void add(Diagnostic diagnostic) {
        if (diagnostic == null) {
            return;
        }
        List kids = diagnostic.getChildren();
        if (!kids.isEmpty()) {
            for (Diagnostic kid : kids) {
                this.add(kid);
            }
        } else {
            Object object;
            List objects = diagnostic.getData();
            CSTNode cstNode = null;
            if (!objects.isEmpty() && (object = objects.get(0)) != null) {
                if (this.environment != null) {
                    cstNode = this.environment.getASTMapping(object);
                } else if (object instanceof CSTNode) {
                    cstNode = (CSTNode)object;
                }
            }
            int startOffset = cstNode != null ? cstNode.getStartOffset() : 0;
            int endOffset = cstNode != null ? cstNode.getEndOffset() : 0;
            ProblemHandler.Severity problemSeverity = ProblemHandler.Severity.INFO;
            if (diagnostic.getSeverity() >= 4) {
                problemSeverity = ProblemHandler.Severity.ERROR;
            } else if (diagnostic.getSeverity() >= 2) {
                problemSeverity = ProblemHandler.Severity.WARNING;
            }
            String problemMessage = diagnostic.getMessage();
            String problemContext = diagnostic.getSource();
            this.handleProblem(problemSeverity, problemMessage, problemContext, startOffset, endOffset);
        }
    }

    public void addAll(Diagnostic diagnostic) {
        for (Diagnostic child : diagnostic.getChildren()) {
            this.add(child);
        }
    }

    protected void handleProblem(ProblemHandler.Severity problemSeverity, String problemMessage, String problemContext, int startOffset, int endOffset) {
        this.problemHandler.validatorProblem(problemSeverity, problemMessage, problemContext, startOffset, endOffset);
    }

    public void merge(Diagnostic diagnostic) {
        if (diagnostic.getChildren().isEmpty()) {
            this.add(diagnostic);
        } else {
            this.addAll(diagnostic);
        }
    }
}

