/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.pivot.AbstractEnvironmentFactory;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.EvaluationHaltedException;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.InvalidEvaluationException;
import org.eclipse.ocl.examples.pivot.OCLDebugOptions;
import org.eclipse.ocl.examples.pivot.ObjectUtil;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.QueryBase;
import org.eclipse.ocl.examples.pivot.SemanticException;
import org.eclipse.ocl.examples.pivot.StandardLibrary;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.ModelManager;
import org.eclipse.ocl.examples.pivot.util.PivotPlugin;
import org.eclipse.ocl.examples.pivot.utilities.QueryBaseImpl;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OCLBase {
    private final EnvironmentFactory environmentFactory;
    private final Environment rootEnvironment;
    private EvaluationEnvironment evalEnv;
    private ModelManager modelManager;
    private List<Constraint> constraints = new ArrayList<Constraint>();
    private Diagnostic problems;
    private Diagnostic evaluationProblems;
    private int parserRepairCount = 0;
    private boolean traceParsing = PivotPlugin.shouldTrace(OCLDebugOptions.PARSING);
    private boolean traceEvaluation = PivotPlugin.shouldTrace(OCLDebugOptions.EVALUATION);

    protected OCLBase(EnvironmentFactory envFactory) {
        this(envFactory, envFactory.createEnvironment());
    }

    protected OCLBase(Environment env) {
        this(env.getFactory(), env);
    }

    protected OCLBase(EnvironmentFactory envFactory, Resource resource) {
        this(envFactory, envFactory.loadEnvironment(resource));
    }

    protected OCLBase(EnvironmentFactory envFactory, Environment rootEnv) {
        this.environmentFactory = envFactory;
        this.rootEnvironment = rootEnv;
        if (envFactory instanceof AbstractEnvironmentFactory) {
            AbstractEnvironmentFactory abstractFactory = (AbstractEnvironmentFactory)envFactory;
            abstractFactory.setEvaluationTracingEnabled(this.traceEvaluation);
        }
    }

    public Environment getEnvironment() {
        return this.rootEnvironment;
    }

    public EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    public EvaluationEnvironment getEvaluationEnvironment() {
        if (this.evalEnv == null) {
            this.evalEnv = this.environmentFactory.createEvaluationEnvironment();
        }
        return this.evalEnv;
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }

    public void setModelManager(ModelManager modelManager) {
        this.modelManager = modelManager;
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public void validate(OclExpression expression) throws SemanticException {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".validate");
    }

    public void validate(Constraint constraint) throws SemanticException {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".validate");
    }

    public Value evaluate(Object context, ExpressionInOcl expression) {
        Value result;
        this.evaluationProblems = null;
        EvaluationEnvironment localEvalEnv = this.getEvaluationEnvironment();
        ValueFactory valueFactory = localEvalEnv.getValueFactory();
        Value value = valueFactory.valueOf(context);
        localEvalEnv.add(expression.getContextVariable(), value);
        ModelManager extents = this.getModelManager();
        if (extents == null) {
            extents = localEvalEnv.createModelManager(context);
        }
        EvaluationVisitor ev = this.environmentFactory.createEvaluationVisitor(this.rootEnvironment, localEvalEnv, extents);
        try {
            try {
                result = (Value)expression.accept(ev);
            }
            catch (EvaluationHaltedException e) {
                this.evaluationProblems = e.getDiagnostic();
                throw e;
            }
        }
        finally {
            localEvalEnv.remove(expression.getContextVariable());
        }
        if (result == null) {
            return localEvalEnv.throwInvalidEvaluation("Java-Null value");
        }
        if (result.isInvalid()) {
            return localEvalEnv.throwInvalidEvaluation("Invalid Value");
        }
        return result;
    }

    public boolean check(Object context, Constraint constraint) {
        ExpressionInOcl specification = (ExpressionInOcl)constraint.getSpecification();
        return this.check(context, specification);
    }

    public boolean check(Object context, ExpressionInOcl specification) {
        StandardLibrary stdlib = this.getEnvironment().getOCLStandardLibrary();
        if (specification.getBodyExpression().getType() != stdlib.getBooleanType()) {
            throw new IllegalArgumentException("constraint is not boolean");
        }
        try {
            Value result = this.evaluate(context, specification);
            return result.isTrue();
        }
        catch (InvalidEvaluationException e) {
            return false;
        }
    }

    public QueryBase createQuery(ExpressionInOcl specification) {
        return new QueryBaseImpl(this.rootEnvironment, specification, this.modelManager);
    }

    public QueryBase createQuery(Constraint constraint) {
        return new QueryBaseImpl(this.rootEnvironment, (ExpressionInOcl)constraint.getSpecification(), this.modelManager);
    }

    public boolean isParseTracingEnabled() {
        return this.traceParsing;
    }

    public void setParseTracingEnabled(boolean b) {
        this.traceParsing = b;
    }

    public int getParserRepairCount() {
        return this.parserRepairCount;
    }

    public void setParserRepairCount(int parserRepairCount) {
        if (parserRepairCount < 0) {
            throw new IllegalArgumentException("negative repair count");
        }
        this.parserRepairCount = parserRepairCount;
    }

    public boolean isEvaluationTracingEnabled() {
        return this.traceEvaluation;
    }

    public void setEvaluationTracingEnabled(boolean b) {
        this.traceEvaluation = b;
        if (this.environmentFactory instanceof AbstractEnvironmentFactory) {
            AbstractEnvironmentFactory abstractFactory = (AbstractEnvironmentFactory)this.environmentFactory;
            abstractFactory.setEvaluationTracingEnabled(this.traceEvaluation);
        }
    }

    public Diagnostic getProblems() {
        return this.problems;
    }

    public TypeManager getTypeManager() {
        return this.rootEnvironment.getTypeManager();
    }

    public ValueFactory getValueFactory() {
        return this.getTypeManager().getValueFactory();
    }

    public Diagnostic getEvaluationProblems() {
        return this.evaluationProblems;
    }

    public void dispose() {
        for (Constraint constraint : this.getConstraints()) {
            Constraint eObject = constraint;
            if (eObject.eResource() != null) continue;
            ObjectUtil.dispose(constraint);
        }
        this.getConstraints().clear();
        if (this.getEnvironment() instanceof Environment.Internal) {
            Environment.Internal env = (Environment.Internal)this.getEnvironment();
            env.dispose();
        }
        this.getTypeManager().dispose();
    }
}

