/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.ValueSpecification;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.delegate.DelegateDomain;
import org.eclipse.ocl.examples.pivot.delegate.DelegateEPackageAdapter;
import org.eclipse.ocl.examples.pivot.delegate.DelegatedBehavior;
import org.eclipse.ocl.examples.pivot.delegate.InvocationBehavior;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateException;
import org.eclipse.ocl.examples.pivot.delegate.SettingBehavior;
import org.eclipse.ocl.examples.pivot.delegate.ValidationBehavior;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDelegatedBehavior<E extends EModelElement, R, F>
implements DelegatedBehavior<E, R, F> {
    private static List<DelegatedBehavior<?, ?, ?>> delegatedBehaviors = null;

    public static List<DelegatedBehavior<?, ?, ?>> getDelegatedBehaviors() {
        if (delegatedBehaviors == null) {
            delegatedBehaviors = new ArrayList();
            delegatedBehaviors.add(InvocationBehavior.INSTANCE);
            delegatedBehaviors.add(SettingBehavior.INSTANCE);
            delegatedBehaviors.add(ValidationBehavior.INSTANCE);
        }
        return delegatedBehaviors;
    }

    public Constraint getConstraintForStereotype(NamedElement namedElement, String name) {
        for (Constraint constraint : namedElement.getOwnedRules()) {
            String stereotype = constraint.getStereotype();
            if (!name.equals(stereotype)) continue;
            return constraint;
        }
        return null;
    }

    public List<DelegateDomain> getDelegateDomains(E eObject) {
        EPackage ePackage = this.getEPackage(eObject);
        DelegateEPackageAdapter adapter = DelegateEPackageAdapter.getAdapter(ePackage);
        ArrayList<DelegateDomain> delegateDomains = new ArrayList<DelegateDomain>();
        for (DelegateDomain delegateDomain : adapter.getDelegateDomains(this)) {
            String uri = delegateDomain.getURI();
            if (eObject.getEAnnotation(uri) == null) continue;
            delegateDomains.add(delegateDomain);
        }
        return delegateDomains;
    }

    @Override
    public List<F> getFactories(E eObject) {
        EPackage ePackage = this.getEPackage(eObject);
        DelegateEPackageAdapter adapter = DelegateEPackageAdapter.getAdapter(ePackage);
        ArrayList<F> factories = new ArrayList<F>();
        for (DelegateDomain delegateDomain : adapter.getDelegateDomains(this)) {
            String uri = delegateDomain.getURI();
            if (eObject.getEAnnotation(uri) == null) continue;
            F factory = this.getFactory(delegateDomain, eObject);
            if (factory == null) {
                factory = this.getDefaultFactory();
            }
            if (factory == null || factories.contains(factory)) continue;
            factories.add(factory);
        }
        return factories;
    }

    protected abstract F getFactory(DelegateDomain var1, E var2);

    @Override
    public F getFactory(E eObject) {
        EPackage ePackage = this.getEPackage(eObject);
        DelegateEPackageAdapter adapter = DelegateEPackageAdapter.getAdapter(ePackage);
        for (DelegateDomain delegateDomain : adapter.getDelegateDomains(this)) {
            String uri = delegateDomain.getURI();
            if (eObject.getEAnnotation(uri) == null) continue;
            F factory = this.getFactory(delegateDomain, eObject);
            if (factory == null) {
                factory = this.getDefaultFactory();
            }
            return factory;
        }
        return null;
    }

    protected ExpressionInOcl getExpressionInOcl(TypeManager typeManager, NamedElement namedElement, Constraint constraint) {
        ValueSpecification valueSpecification = constraint.getSpecification();
        if (valueSpecification instanceof ExpressionInOcl) {
            return (ExpressionInOcl)valueSpecification;
        }
        if (valueSpecification instanceof OpaqueExpression) {
            OpaqueExpression opaqueExpression = (OpaqueExpression)valueSpecification;
            ExpressionInOcl expressionInOcl = opaqueExpression.getValueExpression();
            if (expressionInOcl != null) {
                return expressionInOcl;
            }
            try {
                String expression = PivotUtil.getBody(opaqueExpression);
                if (expression != null) {
                    URI uriBody = typeManager.getResourceIdentifier(constraint, "body");
                    expressionInOcl = PivotUtil.resolveSpecification(typeManager, uriBody, namedElement, expression);
                    if (expressionInOcl != null) {
                        opaqueExpression.setValueExpression(expressionInOcl);
                        String message = PivotUtil.getMessage(opaqueExpression);
                        if (message != null && message.length() > 0) {
                            URI uriMessage = typeManager.getResourceIdentifier(constraint, "message");
                            ExpressionInOcl resolveSpecification = PivotUtil.resolveSpecification(typeManager, uriMessage, namedElement, message);
                            OclExpression messageExpression = resolveSpecification.getBodyExpression();
                            TreeIterator tit = messageExpression.eAllContents();
                            while (tit.hasNext()) {
                                VariableExp variable;
                                EObject eObject = (EObject)tit.next();
                                if (!(eObject instanceof VariableExp) || (variable = (VariableExp)eObject).getReferredVariable() != resolveSpecification.getContextVariable()) continue;
                                variable.setReferredVariable(expressionInOcl.getContextVariable());
                            }
                            expressionInOcl.setMessageExpression(messageExpression);
                        }
                    }
                    return expressionInOcl;
                }
            }
            catch (ParserException e) {
                throw new OCLDelegateException(e.getLocalizedMessage(), e);
            }
        }
        return null;
    }

    @Override
    public void setDelegates(EPackage ePackage, List<String> delegateURIs) {
        String name = this.getName();
        EAnnotation eAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
        if (delegateURIs == null || delegateURIs.isEmpty()) {
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)name);
            }
        } else {
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore");
                ePackage.getEAnnotations().add((Object)eAnnotation);
            }
            StringBuffer value = new StringBuffer();
            Iterator<String> i = delegateURIs.iterator();
            while (i.hasNext()) {
                value.append(i.next());
                if (!i.hasNext()) continue;
                value.append(' ');
            }
            eAnnotation.getDetails().put((Object)name, (Object)value.toString());
        }
    }

    public String toString() {
        return String.valueOf(this.getName()) + " => " + this.getFactoryClass().getName();
    }
}

