/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.QueryDelegate;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.delegate.DelegateDomain;
import org.eclipse.ocl.examples.pivot.delegate.DelegateResourceAdapter;
import org.eclipse.ocl.examples.pivot.delegate.DelegateResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomainFactory;
import org.eclipse.ocl.examples.pivot.delegate.OCLInvocationDelegateFactory;
import org.eclipse.ocl.examples.pivot.delegate.OCLQueryDelegateFactory;
import org.eclipse.ocl.examples.pivot.delegate.OCLSettingDelegateFactory;
import org.eclipse.ocl.examples.pivot.delegate.OCLValidationDelegateFactory;
import org.eclipse.ocl.examples.pivot.delegate.ValidationDelegate;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.utilities.TypeManagerResourceSetAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLDelegateDomain
implements DelegateDomain {
    public static final String OCL_DELEGATE_URI_LPG = "http://www.eclipse.org/emf/2002/Ecore/OCL";
    public static final String OCL_DELEGATE_URI_PIVOT = "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot";
    private static final String OCL_DELEGATE_URI_SLASH = "http://www.eclipse.org/emf/2002/Ecore/OCL/";
    protected final String uri;
    protected final EPackage ePackage;
    protected final OCL ocl;
    protected final TypeManager typeManager;

    public static EAnnotation getDelegateAnnotation(EModelElement eModelElement) {
        String source;
        EList eAnnotations = eModelElement.getEAnnotations();
        for (EAnnotation eAnnotation : eAnnotations) {
            source = eAnnotation.getSource();
            if (source == null || !source.equals(OCL_DELEGATE_URI_LPG)) continue;
            return eAnnotation;
        }
        for (EAnnotation eAnnotation : eAnnotations) {
            source = eAnnotation.getSource();
            if (source == null || !source.startsWith(OCL_DELEGATE_URI_SLASH)) continue;
            return eAnnotation;
        }
        return null;
    }

    public static String getDelegateAnnotation(EModelElement eModelElement, String key) {
        EAnnotation eAnnotation = OCLDelegateDomain.getDelegateAnnotation(eModelElement);
        return eAnnotation == null ? null : (String)eAnnotation.getDetails().get((Object)key);
    }

    public static void initialize(ResourceSet resourceSet) {
        OCLDelegateDomain.initialize(resourceSet, OCL_DELEGATE_URI_PIVOT);
    }

    public static void initialize(ResourceSet resourceSet, String oclDelegateURI) {
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            EOperation.Internal.InvocationDelegate.Factory.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLInvocationDelegateFactory.Global());
            EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLSettingDelegateFactory.Global());
            EValidator.ValidationDelegate.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLValidationDelegateFactory.Global());
            QueryDelegate.Factory.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLQueryDelegateFactory.Global());
        }
        if (resourceSet != null) {
            DelegateResourceSetAdapter adapter = DelegateResourceSetAdapter.getAdapter(resourceSet);
            DelegateDomain.Factory.Registry.Impl delegateDomainFactory = new DelegateDomain.Factory.Registry.Impl();
            delegateDomainFactory.put(oclDelegateURI, new OCLDelegateDomainFactory());
            adapter.putRegistry(DelegateDomain.Factory.Registry.class, delegateDomainFactory);
            ValidationDelegate.Factory.Registry.Impl validationDelegateFactoryRegistry = new ValidationDelegate.Factory.Registry.Impl();
            validationDelegateFactoryRegistry.put(oclDelegateURI, new OCLValidationDelegateFactory());
            adapter.putRegistry(ValidationDelegate.Factory.Registry.class, validationDelegateFactoryRegistry);
            EStructuralFeature.Internal.SettingDelegate.Factory.Registry.Impl settingDelegateFactoryRegistry = new EStructuralFeature.Internal.SettingDelegate.Factory.Registry.Impl();
            settingDelegateFactoryRegistry.put((Object)oclDelegateURI, (Object)new OCLSettingDelegateFactory());
            adapter.putRegistry(EStructuralFeature.Internal.SettingDelegate.Factory.Registry.class, settingDelegateFactoryRegistry);
            EOperation.Internal.InvocationDelegate.Factory.Registry.Impl invocationDelegateFactoryRegistry = new EOperation.Internal.InvocationDelegate.Factory.Registry.Impl();
            invocationDelegateFactoryRegistry.put((Object)oclDelegateURI, (Object)new OCLInvocationDelegateFactory());
            adapter.putRegistry(EOperation.Internal.InvocationDelegate.Factory.Registry.class, invocationDelegateFactoryRegistry);
            QueryDelegate.Factory.Registry.Impl queryDelegateFactoryRegistry = new QueryDelegate.Factory.Registry.Impl();
            queryDelegateFactoryRegistry.put((Object)oclDelegateURI, (Object)new OCLQueryDelegateFactory());
            adapter.putRegistry(QueryDelegate.Factory.Registry.class, queryDelegateFactoryRegistry);
        }
    }

    public OCLDelegateDomain(String delegateURI, EPackage ePackage) {
        this.uri = delegateURI;
        this.ePackage = ePackage;
        this.ocl = OCL.newInstance(this.getEnvironmentFactory());
        this.typeManager = this.ocl.getEnvironment().getTypeManager();
    }

    @Override
    public void dispose() {
        if (this.ocl != null) {
            this.ocl.dispose();
        }
    }

    private PivotEnvironmentFactory getEnvironmentFactory() {
        Resource res = this.ePackage.eResource();
        PivotEnvironmentFactory envFactory = null;
        if (res != null) {
            TypeManager typeManager = null;
            ResourceSet resourceSet = res.getResourceSet();
            if (resourceSet != null) {
                TypeManagerResourceSetAdapter rsAdapter = TypeManagerResourceSetAdapter.findAdapter(resourceSet);
                if (rsAdapter != null) {
                    typeManager = rsAdapter.getTypeManager();
                }
                EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
                envFactory = new PivotEnvironmentFactory(packageRegistry, typeManager);
                DelegateResourceAdapter.getAdapter(res);
            }
        }
        if (envFactory == null) {
            envFactory = PivotEnvironmentFactory.getGlobalRegistryInstance();
        }
        return envFactory;
    }

    public OCL getOCL() {
        return this.ocl;
    }

    public <T extends Element> T getPivot(Class<T> requiredClass, EObject eObject) {
        Ecore2Pivot ecore2Pivot = Ecore2Pivot.getAdapter(eObject.eResource(), this.typeManager);
        return ecore2Pivot.getCreated(requiredClass, eObject);
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    public String toString() {
        return String.valueOf(this.ePackage.getName()) + " : " + this.getURI();
    }
}

