/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.InvalidEvaluationException;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.delegate.InvocationBehavior;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateException;
import org.eclipse.ocl.examples.pivot.delegate.ValidationBehavior;
import org.eclipse.ocl.examples.pivot.delegate.ValidationDelegate;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.ModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLValidationDelegate
implements ValidationDelegate {
    protected final OCLDelegateDomain delegateDomain;
    protected final EClassifier eClassifier;

    public OCLValidationDelegate(OCLDelegateDomain delegateDomain, EClassifier classifier) {
        this.delegateDomain = delegateDomain;
        this.eClassifier = classifier;
    }

    public EvaluationVisitor createEvaluationVisitor(Object object, ExpressionInOcl query) {
        EnvironmentFactory environmentFactory = this.delegateDomain.getOCL().getEnvironmentFactory();
        Environment rootEnvironment = environmentFactory.createEnvironment();
        EvaluationEnvironment evaluationEnvironment = this.createEvaluationEnvironment(object, query, environmentFactory);
        ModelManager extents = evaluationEnvironment.createModelManager(object);
        EvaluationVisitor evaluationVisitor = environmentFactory.createEvaluationVisitor(rootEnvironment, evaluationEnvironment, extents);
        return evaluationVisitor;
    }

    public EvaluationEnvironment createEvaluationEnvironment(Object object, ExpressionInOcl query, EnvironmentFactory environmentFactory) {
        EvaluationEnvironment evaluationEnvironment = environmentFactory.createEvaluationEnvironment();
        TypeManager typeManager = evaluationEnvironment.getTypeManager();
        ValueFactory valueFactory = typeManager.getValueFactory();
        Value value = valueFactory.valueOf(object);
        evaluationEnvironment.add(query.getContextVariable(), value);
        return evaluationEnvironment;
    }

    protected String evaluateMessage(EvaluationVisitor evaluationVisitor, String constraintName, ExpressionInOcl query) {
        OclExpression messageExpression = query.getMessageExpression();
        if (messageExpression == null) {
            return null;
        }
        try {
            Value result = (Value)messageExpression.accept(evaluationVisitor);
            return result.asString();
        }
        catch (InvalidValueException e) {
            String message = NLS.bind((String)OCLMessages.ValidationMessageIsNotString_ERROR_, (Object)constraintName);
            throw new OCLDelegateException(message);
        }
    }

    public String toString() {
        return "<" + this.delegateDomain.getURI() + ":validate> " + this.eClassifier.getEPackage().getName() + "::" + this.eClassifier.getName();
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, EOperation invariant, String expression) {
        TypeManager typeManager = this.delegateDomain.getTypeManager();
        NamedElement namedElement = this.delegateDomain.getPivot(NamedElement.class, (EObject)invariant);
        if (namedElement instanceof Operation) {
            Operation operation = (Operation)namedElement;
            ExpressionInOcl query = InvocationBehavior.INSTANCE.getExpressionInOcl(typeManager, operation);
            return this.validateExpressionInOcl((EClassifier)eClass, eObject, null, context, invariant.getName(), null, 0, query);
        }
        if (namedElement instanceof Constraint) {
            Constraint constraint = (Constraint)namedElement;
            NamedElement contextType = constraint.getContext();
            ExpressionInOcl query = ValidationBehavior.INSTANCE.getExpressionInOcl(typeManager, contextType, constraint);
            if (query == null) {
                String message = NLS.bind((String)OCLMessages.MissingBodyForInvocationDelegate_ERROR_, (Object)contextType);
                throw new OCLDelegateException(message);
            }
            return this.validateExpressionInOcl((EClassifier)eClass, eObject, null, context, invariant.getName(), null, 0, query);
        }
        throw new ClassCastException(String.valueOf(namedElement.getClass().getName()) + " does not provide a Constraint");
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, String constraintName, String expression) {
        return this.validatePivot((EClassifier)eClass, eObject, null, context, constraintName, null, 0);
    }

    public boolean validate(EDataType eDataType, Object value, Map<Object, Object> context, String constraintName, String expression) {
        return this.validatePivot((EClassifier)eDataType, value, null, context, constraintName, null, 0);
    }

    @Override
    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context, String constraintName, String expression, int severity, String source, int code) {
        return this.validatePivot((EClassifier)eClass, eObject, diagnostics, context, constraintName, source, code);
    }

    @Override
    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context, String constraintName, String expression, int severity, String source, int code) {
        return this.validatePivot((EClassifier)eDataType, value, diagnostics, context, constraintName, source, code);
    }

    protected boolean validatePivot(EClassifier eClassifier, Object value, DiagnosticChain diagnostics, Map<Object, Object> context, String constraintName, String source, int code) {
        TypeManager typeManager = this.delegateDomain.getTypeManager();
        Type type = this.delegateDomain.getPivot(Type.class, (EObject)eClassifier);
        Constraint constraint = ValidationBehavior.INSTANCE.getConstraint(typeManager, eClassifier, constraintName);
        if (constraint == null) {
            String message = NLS.bind((String)OCLMessages.MissingBodyForInvocationDelegate_ERROR_, (Object)type);
            throw new OCLDelegateException(message);
        }
        ExpressionInOcl query = ValidationBehavior.INSTANCE.getExpressionInOcl(typeManager, type, constraint);
        if (query == null) {
            String message = NLS.bind((String)OCLMessages.MissingBodyForInvocationDelegate_ERROR_, (Object)type);
            throw new OCLDelegateException(message);
        }
        return this.validateExpressionInOcl(eClassifier, value, diagnostics, context, constraintName, source, code, query);
    }

    protected boolean check(EvaluationVisitor evaluationVisitor, String constraintName, ExpressionInOcl query) {
        if (query.getType() != evaluationVisitor.getTypeManager().getBooleanType()) {
            String message = NLS.bind((String)OCLMessages.ValidationConstraintIsNotBoolean_ERROR_, (Object)constraintName);
            throw new OCLDelegateException(message);
        }
        try {
            Value result = (Value)query.accept(evaluationVisitor);
            if (result.isNull()) {
                String message = NLS.bind((String)OCLMessages.ValidationResultIsNull_ERROR_, (Object)constraintName);
                throw new OCLDelegateException(message);
            }
            return result.asBoolean();
        }
        catch (InvalidValueException e) {
            String message = NLS.bind((String)OCLMessages.ValidationResultIsNotBoolean_ERROR_, (Object)constraintName);
            throw new OCLDelegateException(message);
        }
        catch (InvalidEvaluationException e) {
            String message = NLS.bind((String)OCLMessages.ValidationResultIsInvalid_ERROR_, (Object)constraintName);
            throw new OCLDelegateException(message);
        }
    }

    protected boolean validateExpressionInOcl(EClassifier eClassifier, Object value, DiagnosticChain diagnostics, Map<Object, Object> context, String constraintName, String source, int code, ExpressionInOcl query) {
        Value result;
        EvaluationVisitor evaluationVisitor = this.createEvaluationVisitor(value, query);
        if (query.getType() != evaluationVisitor.getTypeManager().getBooleanType()) {
            String message = NLS.bind((String)OCLMessages.ValidationConstraintIsNotBoolean_ERROR_, (Object)constraintName);
            throw new OCLDelegateException(message);
        }
        try {
            result = (Value)query.accept(evaluationVisitor);
            if (result.isNull()) {
                if (diagnostics == null) {
                    String message = NLS.bind((String)OCLMessages.ValidationResultIsNull_ERROR_, (Object)constraintName);
                    throw new OCLDelegateException(message);
                }
            } else if (result.asBoolean()) {
                return true;
            }
        }
        catch (InvalidValueException e) {
            String message = NLS.bind((String)OCLMessages.ValidationResultIsNotBoolean_ERROR_, (Object)constraintName);
            throw new OCLDelegateException(message);
        }
        catch (InvalidEvaluationException e) {
            String message = NLS.bind((String)OCLMessages.ValidationResultIsInvalid_ERROR_, (Object)constraintName);
            throw new OCLDelegateException(message);
        }
        if (diagnostics != null) {
            String message = this.evaluateMessage(evaluationVisitor, constraintName, query);
            if (message == null) {
                String objectLabel = eClassifier instanceof EDataType ? EObjectValidator.getValueLabel((EDataType)((EDataType)eClassifier), (Object)value, context) : (value instanceof EObject ? EObjectValidator.getObjectLabel((EObject)((EObject)value), context) : String.valueOf(value));
                message = NLS.bind((String)OCLMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object)constraintName, (Object)objectLabel);
            }
            int severity = result.isNull() ? 4 : 2;
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, source, code, message, new Object[]{value}));
        }
        return false;
    }
}

