/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;

public class PivotInstaller {
    public static void installDelegates(TypeManager typeManager, Package pivotPackage) {
        boolean hasDelegates = false;
        for (Type aType : typeManager.getLocalClasses(pivotPackage)) {
            if (!PivotInstaller.installDelegates(typeManager, aType)) continue;
            hasDelegates = true;
        }
        Package primaryPackage = typeManager.getPrimaryPackage(pivotPackage);
        EObject eTarget = primaryPackage.getETarget();
        if (eTarget instanceof EPackage && hasDelegates) {
            Pivot2Ecore.installDelegates((EPackage)eTarget);
        }
        for (Package nestedPackage : typeManager.getLocalPackages(pivotPackage)) {
            PivotInstaller.installDelegates(typeManager, nestedPackage);
        }
    }

    private static boolean installDelegates(TypeManager typeManager, Type pivotType) {
        boolean hasDelegates = false;
        for (Operation anOperation : typeManager.getLocalOperations(pivotType, null)) {
            if (!PivotInstaller.installDelegates(typeManager, anOperation)) continue;
            hasDelegates = true;
        }
        for (Property aProperty : typeManager.getLocalProperties(pivotType, null)) {
            if (!PivotInstaller.installDelegates(typeManager, aProperty)) continue;
            hasDelegates = true;
        }
        Class primaryClass = typeManager.getPrimaryClass(pivotType);
        EObject eTarget = primaryClass.getETarget();
        if (eTarget instanceof EClassifier) {
            EClassifier eClassifier = (EClassifier)eTarget;
            for (Constraint constraint : typeManager.getLocalConstraints(pivotType)) {
                if (!Pivot2Ecore.installDelegate((EModelElement)eClassifier, constraint)) continue;
                hasDelegates = true;
            }
            if (hasDelegates) {
                Pivot2Ecore.installDelegates(typeManager, eClassifier, pivotType);
            }
        }
        return hasDelegates;
    }

    private static boolean installDelegates(TypeManager typeManager, Property aProperty) {
        return false;
    }

    private static boolean installDelegates(TypeManager typeManager, Operation anOperation) {
        return false;
    }
}

