/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.MonikeredElement;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Moniker;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2PivotDeclarationSwitch;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2PivotReferenceSwitch;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.ocl.examples.pivot.utilities.AliasAdapter;
import org.eclipse.ocl.examples.pivot.utilities.External2Pivot;
import org.eclipse.ocl.examples.pivot.utilities.PivotConstants;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ecore2Pivot
extends AbstractConversion
implements External2Pivot,
PivotConstants {
    public static TypeManager.Factory FACTORY = new Factory();
    private static final Logger logger = Logger.getLogger(Ecore2Pivot.class);
    private Map<EObject, Element> createMap = new HashMap<EObject, Element>();
    private Set<EObject> referencers = new HashSet<EObject>();
    private Set<Ecore2Pivot> allConverters = new HashSet<Ecore2Pivot>();
    private List<EGenericType> genericTypes = new ArrayList<EGenericType>();
    private Map<TemplateableElement, List<TemplateableElement>> specializations = new HashMap<TemplateableElement, List<TemplateableElement>>();
    private List<Resource.Diagnostic> errors = null;
    protected final TypeManager typeManager;
    protected final Resource ecoreResource;
    protected Package pivotRoot = null;
    protected final Ecore2PivotDeclarationSwitch declarationPass = new Ecore2PivotDeclarationSwitch(this);
    protected final Ecore2PivotReferenceSwitch referencePass = new Ecore2PivotReferenceSwitch(this);
    private HashMap<EClassifier, Type> ecore2PivotMap = null;

    public static Ecore2Pivot findAdapter(Resource resource, TypeManager typeManager) {
        assert (typeManager != null);
        if (resource == null) {
            return null;
        }
        for (Adapter adapter : resource.eAdapters()) {
            Ecore2Pivot ecore2Pivot;
            if (!(adapter instanceof Ecore2Pivot) || (ecore2Pivot = (Ecore2Pivot)adapter).getTypeManager() != typeManager) continue;
            return ecore2Pivot;
        }
        return null;
    }

    public static Ecore2Pivot getAdapter(Resource resource, TypeManager typeManager) {
        Ecore2Pivot adapter;
        if (resource == null) {
            return null;
        }
        if (typeManager == null) {
            typeManager = new TypeManager();
        } else {
            adapter = Ecore2Pivot.findAdapter(resource, typeManager);
            if (adapter != null) {
                return adapter;
            }
        }
        adapter = new Ecore2Pivot(resource, typeManager);
        EList eAdapters = resource.eAdapters();
        eAdapters.add(adapter);
        return adapter;
    }

    public static Package importFromEcore(TypeManager typeManager, String alias, Resource ecoreResource) {
        if (ecoreResource == null) {
            return null;
        }
        Ecore2Pivot conversion = Ecore2Pivot.getAdapter(ecoreResource, typeManager);
        return conversion.getPivotRoot();
    }

    public static boolean isEcore(Resource resource) {
        EList contents = resource.getContents();
        for (EObject content : contents) {
            if (!(content instanceof EPackage)) continue;
            return true;
        }
        return false;
    }

    public static Element importFromEcore(TypeManager typeManager, String alias, EObject eObject) {
        if (eObject == null) {
            return null;
        }
        Resource ecoreResource = eObject.eResource();
        Ecore2Pivot conversion = Ecore2Pivot.getAdapter(ecoreResource, typeManager);
        Package pivotRoot = conversion.getPivotRoot();
        if (pivotRoot == null) {
            return null;
        }
        return conversion.createMap.get(eObject);
    }

    public Ecore2Pivot(Resource ecoreResource, TypeManager typeManager) {
        this.ecoreResource = ecoreResource;
        if (typeManager == null) {
            typeManager = new TypeManager();
        }
        this.typeManager = typeManager;
        typeManager.addExternalResource(this);
    }

    public void addCreated(EObject eObject, Element pivotElement) {
        Type pivotType;
        if (eObject instanceof EClassifier && (pivotType = this.getEcore2PivotMap().get(eObject)) != null) {
            pivotElement = pivotType;
        }
        this.createMap.put(eObject, pivotElement);
    }

    public void addGenericType(EGenericType eObject) {
        this.genericTypes.add(eObject);
    }

    public Map<String, MonikeredElement> computeMoniker2PivotMap() {
        HashMap<String, MonikeredElement> map = new HashMap<String, MonikeredElement>();
        TreeIterator it = this.ecoreResource.getAllContents();
        while (it.hasNext()) {
            Element pElement;
            EObject eObject = (EObject)it.next();
            if (!(eObject instanceof EModelElement) || !((pElement = this.createMap.get(eObject)) instanceof MonikeredElement)) continue;
            String moniker = ((MonikeredElement)pElement).getMoniker();
            MonikeredElement oldElement = (MonikeredElement)map.get(moniker);
            if (oldElement != null) {
                logger.warn((Object)("Duplicate moniker " + moniker + " for " + pElement.eClass().getName()));
            }
            map.put(moniker, (MonikeredElement)pElement);
        }
        return map;
    }

    protected void error(String message) {
        if (this.errors == null) {
            this.errors = new ArrayList<Resource.Diagnostic>();
        }
        this.errors.add((Resource.Diagnostic)new XMIException(message));
    }

    public <T extends Element> T getCreated(java.lang.Class<T> requiredClass, EObject eObject) {
        return this.getPivotOfEcore(requiredClass, eObject);
    }

    public Map<EClassifier, Type> getEcore2PivotMap() {
        if (this.ecore2PivotMap == null) {
            this.ecore2PivotMap = new HashMap();
            this.initializeEcore2PivotMap();
        }
        return this.ecore2PivotMap;
    }

    public Resource getEcoreResource() {
        return this.ecoreResource;
    }

    public <T extends Element> T getPivotOfEcore(java.lang.Class<T> requiredClass, EObject eObject) {
        Element element;
        if (this.pivotRoot == null) {
            this.getPivotRoot();
        }
        if ((element = this.createMap.get(eObject)) == null) {
            return null;
        }
        if (!requiredClass.isAssignableFrom(element.getClass())) {
            throw new ClassCastException(String.valueOf(element.getClass().getName()) + " is not assignable to " + requiredClass.getName());
        }
        Element castElement = element;
        return (T)castElement;
    }

    public Type getPivotType(EObject eObject) {
        Element pivotElement = this.createMap.get(eObject);
        if (pivotElement == null) {
            Ecore2Pivot converter;
            Resource resource = eObject.eResource();
            if (resource != this.ecoreResource && resource != null && this.allConverters.add(converter = Ecore2Pivot.getAdapter(resource, this.typeManager))) {
                converter.getPivotRoot();
                for (Map.Entry<EObject, Element> entry : converter.createMap.entrySet()) {
                    this.createMap.put(entry.getKey(), entry.getValue());
                }
            }
            pivotElement = this.createMap.get(eObject);
        }
        if (pivotElement == null) {
            this.error("Unresolved " + eObject);
        } else if (!(pivotElement instanceof Type)) {
            this.error("Incompatible " + eObject);
        } else {
            return (Type)pivotElement;
        }
        return null;
    }

    public Package getPivotRoot() {
        if (this.pivotRoot == null) {
            Resource pivotResource = null;
            for (EObject eObject : this.ecoreResource.getContents()) {
                String nsURI;
                String moniker;
                if (!(eObject instanceof EPackage) || (moniker = this.typeManager.getPackageMoniker(nsURI = ((EPackage)eObject).getNsURI())) == null) continue;
                this.pivotRoot = PivotFactory.eINSTANCE.createPackage();
                this.pivotRoot.setNsURI(nsURI);
                String uri = String.valueOf(EcoreUtil.generateUUID()) + ".pivot";
                this.pivotRoot.setMoniker(uri);
                URI dummyURI = URI.createURI((String)uri);
                pivotResource = this.typeManager.getPivotResourceSet().createResource(dummyURI);
                pivotResource.getContents().add((Object)this.pivotRoot);
                pivotResource.getErrors().add((Object)new XMIException("Unsupported '" + nsURI + "' conflict"));
                return this.pivotRoot;
            }
            if (pivotResource != null) {
                this.pivotRoot = (Package)pivotResource.getContents().get(0);
            } else {
                pivotResource = this.importObjects((Collection<EObject>)this.ecoreResource.getContents(), PivotUtil.getPivotURI(this.ecoreResource.getURI()));
                AliasAdapter ecoreAdapter = AliasAdapter.findAdapter(this.ecoreResource);
                if (ecoreAdapter != null) {
                    Map<EObject, String> ecoreAliasMap = ecoreAdapter.getAliasMap();
                    AliasAdapter pivotAdapter = AliasAdapter.getAdapter(pivotResource);
                    Map<EObject, String> pivotAliasMap = pivotAdapter.getAliasMap();
                    for (EObject eObject : ecoreAliasMap.keySet()) {
                        String alias = ecoreAliasMap.get(eObject);
                        Element element = this.createMap.get(eObject);
                        pivotAliasMap.put(element, alias);
                    }
                }
                this.typeManager.installResource(pivotResource);
            }
        }
        return this.pivotRoot;
    }

    @Override
    public Resource getResource() {
        return this.ecoreResource;
    }

    public Notifier getTarget() {
        return this.ecoreResource;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    @Override
    public URI getURI() {
        return this.ecoreResource.getURI();
    }

    public Resource importObjects(Collection<EObject> ecoreContents, URI ecoreURI) {
        Resource pivotResource = this.typeManager.createResource(ecoreURI, "org.eclipse.ocl.examples.pivot");
        this.pivotRoot = this.typeManager.createPackage(ecoreURI.lastSegment(), null);
        pivotResource.getContents().add((Object)this.pivotRoot);
        EList<Package> packages = this.pivotRoot.getNestedPackages();
        for (EObject eObject : ecoreContents) {
            Object pivotElement = this.declarationPass.doInPackageSwitch(eObject);
            if (pivotElement instanceof Package) {
                packages.add((Package)pivotElement);
                continue;
            }
            this.error("Bad ecore content");
        }
        HashMap<String, Type> resolvedSpecializations = new HashMap<String, Type>();
        for (EGenericType eGenericType : this.genericTypes) {
            Type pivotType = this.resolveType(resolvedSpecializations, eGenericType);
            this.createMap.put((EObject)eGenericType, pivotType);
        }
        for (List list : this.specializations.values()) {
            for (TemplateableElement pivotElement : list) {
                this.typeManager.addOrphanClass((Type)pivotElement);
            }
        }
        for (EObject eObject : this.referencers) {
            this.referencePass.doInPackageSwitch(eObject);
        }
        if (this.errors != null) {
            pivotResource.getErrors().addAll(this.errors);
        }
        return pivotResource;
    }

    public void initializeEcore2PivotMap() {
        this.ecore2PivotMap.put((EClassifier)EcorePackage.Literals.EBOOLEAN, this.typeManager.getBooleanType());
        this.ecore2PivotMap.put((EClassifier)EcorePackage.Literals.EBIG_INTEGER, this.typeManager.getIntegerType());
        this.ecore2PivotMap.put((EClassifier)EcorePackage.Literals.EBIG_DECIMAL, this.typeManager.getRealType());
        this.ecore2PivotMap.put((EClassifier)EcorePackage.Literals.ESTRING, this.typeManager.getStringType());
    }

    public boolean isAdapterForType(Object type) {
        return type == Ecore2Pivot.class;
    }

    public void notifyChanged(Notification notification) {
    }

    public void queueReference(EModelElement eObject) {
        this.referencers.add((EObject)eObject);
    }

    protected <T extends NamedElement> T refreshNamedElement(java.lang.Class<T> pivotClass, EClass pivotEClass, ENamedElement eNamedElement) {
        EFactory eFactoryInstance = pivotEClass.getEPackage().getEFactoryInstance();
        EObject pivotElement = eFactoryInstance.create(pivotEClass);
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException();
        }
        NamedElement castElement = (NamedElement)pivotElement;
        if (eNamedElement != null) {
            castElement.setName(eNamedElement.getName());
        }
        return (T)castElement;
    }

    protected Type resolveDataType(EGenericType eGenericType) {
        assert (eGenericType.getETypeArguments().isEmpty());
        EDataType eClassifier = (EDataType)eGenericType.getEClassifier();
        Type pivotType = this.getEcore2PivotMap().get(eClassifier);
        if (pivotType == null) {
            pivotType = this.getPivotType((EObject)eClassifier);
        }
        return pivotType;
    }

    protected Type resolveGenericType(Map<String, Type> resolvedSpecializations, EGenericType eGenericType) {
        EList eTypeArguments = eGenericType.getETypeArguments();
        assert (!eGenericType.getETypeArguments().isEmpty());
        EClassifier eClassifier = eGenericType.getEClassifier();
        EList eTypeParameters = eClassifier.getETypeParameters();
        assert (eTypeParameters.size() == eTypeArguments.size());
        Type unspecializedPivotType = this.getPivotType((EObject)eClassifier);
        if (unspecializedPivotType == null) {
            return null;
        }
        String moniker = Ecore2Moniker.toString(eGenericType);
        Object specializedPivotElement = this.typeManager.findOrphanClass(unspecializedPivotType.getClass(), moniker);
        if (specializedPivotElement != null) {
            return specializedPivotElement;
        }
        specializedPivotElement = unspecializedPivotType instanceof DataType ? (Type)this.refreshNamedElement(DataType.class, PivotPackage.Literals.DATA_TYPE, null) : (Type)this.refreshNamedElement(Class.class, PivotPackage.Literals.CLASS, null);
        specializedPivotElement.setName(unspecializedPivotType.getName());
        specializedPivotElement.setMoniker(moniker);
        TemplateBinding templateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
        TemplateSignature templateSignature = unspecializedPivotType.getOwnedTemplateSignature();
        templateBinding.setSignature(templateSignature);
        specializedPivotElement.getTemplateBindings().add((Object)templateBinding);
        int i = 0;
        while (i < eTypeParameters.size()) {
            TemplateParameterSubstitution templateParameterSubstitution = PivotFactory.eINSTANCE.createTemplateParameterSubstitution();
            templateParameterSubstitution.setFormal((TemplateParameter)templateSignature.getParameters().get(i));
            EGenericType eTypeArgument = (EGenericType)eTypeArguments.get(i);
            Type typeArgument = this.resolveType(resolvedSpecializations, eTypeArgument);
            if (typeArgument.eContainer() == null) {
                templateParameterSubstitution.setOwnedActual(typeArgument);
            } else {
                templateParameterSubstitution.setActual(typeArgument);
            }
            templateBinding.getParameterSubstitutions().add((Object)templateParameterSubstitution);
            ++i;
        }
        specializedPivotElement.setUnspecializedElement((TemplateableElement)unspecializedPivotType);
        List<TemplateableElement> specializationList = this.specializations.get(unspecializedPivotType);
        if (specializationList == null) {
            specializationList = new ArrayList<TemplateableElement>();
            this.specializations.put(unspecializedPivotType, specializationList);
        }
        specializationList.add((TemplateableElement)specializedPivotElement);
        return specializedPivotElement;
    }

    protected Type resolveSimpleType(EGenericType eGenericType) {
        assert (eGenericType.getETypeArguments().isEmpty());
        EClassifier eClassifier = eGenericType.getEClassifier();
        Type pivotType = this.getPivotType((EObject)eClassifier);
        return pivotType;
    }

    protected Type resolveType(Map<String, Type> resolvedSpecializations, EGenericType eGenericType) {
        Type pivotType = this.getCreated(Type.class, (EObject)eGenericType);
        if (pivotType != null) {
            return pivotType;
        }
        EClassifier eClassifier = eGenericType.getEClassifier();
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        EList eTypeArguments = eGenericType.getETypeArguments();
        if (eTypeParameter != null) {
            pivotType = this.resolveTypeParameter(eGenericType);
        } else if (eClassifier == null) {
            pivotType = this.resolveWildcardType(eGenericType);
        } else if (!eTypeArguments.isEmpty()) {
            String ecoreMoniker = Ecore2Moniker.toString(eGenericType);
            pivotType = resolvedSpecializations.get(ecoreMoniker);
            if (pivotType == null) {
                pivotType = this.resolveGenericType(resolvedSpecializations, eGenericType);
                resolvedSpecializations.put(ecoreMoniker, pivotType);
            }
        } else {
            pivotType = eClassifier instanceof EDataType ? this.resolveDataType(eGenericType) : this.resolveSimpleType(eGenericType);
        }
        this.createMap.put((EObject)eGenericType, pivotType);
        return pivotType;
    }

    protected Type resolveTypeParameter(EGenericType eGenericType) {
        EClassifier eClassifier = eGenericType.getEClassifier();
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        EList eTypeArguments = eGenericType.getETypeArguments();
        assert (eClassifier == null);
        assert (eTypeArguments.isEmpty());
        Type pivotType = this.getCreated(Type.class, (EObject)eTypeParameter);
        return pivotType;
    }

    protected Type resolveWildcardType(EGenericType eGenericType) {
        EObject eContainer;
        List list;
        int index;
        assert (eGenericType.getETypeArguments().isEmpty());
        assert (eGenericType.getEClassifier() == null);
        EClassifier eClassifier = eGenericType.getERawType();
        assert (eClassifier == EcorePackage.Literals.EJAVA_OBJECT);
        Class pivotElement = PivotFactory.eINSTANCE.createClass();
        String name = "wildcard";
        EReference eFeature = eGenericType.eContainmentFeature();
        if (eFeature != null && eFeature.isMany() && (index = (list = (List)(eContainer = eGenericType.eContainer()).eGet(eGenericType.eContainingFeature())).indexOf(eGenericType)) != 0) {
            name = String.valueOf(name) + index;
        }
        pivotElement.setName(name);
        return pivotElement;
    }

    public void setTarget(Notifier newTarget) {
        assert (newTarget == null || newTarget == this.ecoreResource);
    }

    private static final class Factory
    implements TypeManager.Factory {
        private Factory() {
            TypeManager.addFactory(this);
        }

        public boolean canHandle(Resource resource) {
            return Ecore2Pivot.isEcore(resource);
        }

        public void configure(ResourceSet resourceSet) {
        }

        public Element importFromResource(TypeManager typeManager, Resource ecoreResource, String uriFragment) {
            if (ecoreResource == null) {
                return null;
            }
            Ecore2Pivot conversion = Ecore2Pivot.getAdapter(ecoreResource, typeManager);
            Package pivotRoot = conversion.getPivotRoot();
            if (uriFragment == null) {
                return pivotRoot;
            }
            EObject eObject = ecoreResource.getEObject(uriFragment);
            if (eObject == null) {
                return null;
            }
            return (Element)conversion.createMap.get(eObject);
        }
    }
}

