/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ValueSpecification;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2EcoreDeclarationVisitor;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2EcoreReferenceVisitor;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrintExprVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2Ecore
extends AbstractConversion {
    public static final Logger logger = Logger.getLogger(Pivot2Ecore.class);
    private Map<Element, EModelElement> createMap = new HashMap<Element, EModelElement>();
    Set<Element> deferMap = new HashSet<Element>();
    private List<Resource.Diagnostic> errors = null;
    protected final Pivot2EcoreDeclarationVisitor pass1 = new Pivot2EcoreDeclarationVisitor(this);
    protected final Pivot2EcoreReferenceVisitor pass2 = new Pivot2EcoreReferenceVisitor(this);
    protected final TypeManager typeManager;

    public static List<EObject> createResource(TypeManager typeManager, Resource pivotResource) {
        EList pivotRoots = pivotResource.getContents();
        Pivot2Ecore converter = new Pivot2Ecore(typeManager);
        return converter.convertAll((List<? extends EObject>)pivotRoots);
    }

    public static XMLResource createResource(TypeManager typeManager, Resource pivotResource, URI ecoreURI) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        XMLResource ecoreResource = (XMLResource)resourceSet.createResource(ecoreURI);
        ArrayList<EObject> outputObjects = new ArrayList<EObject>(Pivot2Ecore.createResource(typeManager, pivotResource));
        for (EObject eObject : outputObjects) {
            if (!(eObject instanceof EPackage) || "$$".equals(((EPackage)eObject).getName())) continue;
            ecoreResource.getContents().addAll((Collection)((EPackage)eObject).getESubpackages());
        }
        return ecoreResource;
    }

    public static boolean installDelegate(EModelElement eModelElement, Constraint pivotConstraint) {
        ValueSpecification specification = pivotConstraint.getSpecification();
        if (!(specification instanceof OpaqueExpression)) {
            return false;
        }
        String exprString = PivotUtil.getBody((OpaqueExpression)specification);
        if (exprString == null && specification instanceof ExpressionInOcl) {
            exprString = PrettyPrintExprVisitor.prettyPrint(((ExpressionInOcl)specification).getBodyExpression(), PrettyPrintExprVisitor.getNamespace(specification));
        }
        if (exprString == null) {
            return false;
        }
        EAnnotation oclAnnotation = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        if (oclAnnotation == null) {
            oclAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            oclAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
            eModelElement.getEAnnotations().add((Object)oclAnnotation);
        }
        String stereotype = pivotConstraint.getStereotype();
        String name = pivotConstraint.getName();
        if ("invariant".equals(stereotype)) {
            if (eModelElement instanceof EOperation) {
                oclAnnotation.getDetails().put((Object)"body", (Object)exprString);
            } else {
                oclAnnotation.getDetails().put((Object)name, (Object)exprString);
                String messageString = PivotUtil.getMessage((OpaqueExpression)specification);
                if (messageString == null && specification instanceof ExpressionInOcl) {
                    messageString = PrettyPrintExprVisitor.prettyPrint(((ExpressionInOcl)specification).getMessageExpression(), PrettyPrintExprVisitor.getNamespace(specification));
                }
                if (messageString != null && messageString.length() > 0) {
                    oclAnnotation.getDetails().put((Object)(String.valueOf(name) + "$message"), (Object)messageString);
                }
            }
        } else if ("derivation".equals(stereotype)) {
            oclAnnotation.getDetails().put((Object)"derivation", (Object)exprString);
        } else if ("initial".equals(stereotype)) {
            oclAnnotation.getDetails().put((Object)"initial", (Object)exprString);
        } else if ("body".equals(stereotype)) {
            String key = name != null ? "body_" + name : "body";
            oclAnnotation.getDetails().put((Object)key, (Object)exprString);
        } else if ("precondition".equals(stereotype)) {
            oclAnnotation.getDetails().put((Object)("pre_" + name), (Object)exprString);
        } else if ("postcondition".equals(stereotype)) {
            oclAnnotation.getDetails().put((Object)("post_" + name), (Object)exprString);
        }
        return true;
    }

    public static void installDelegates(TypeManager typeManager, EClassifier eClassifier, Type pivotType) {
        StringBuffer s = null;
        for (Constraint pivotConstraint : typeManager.getLocalConstraints((Class)pivotType)) {
            String constraintName = pivotConstraint.getName();
            if (pivotConstraint.isCallable() || constraintName == null) continue;
            if (s == null) {
                s = new StringBuffer();
            } else {
                s.append(" ");
            }
            s.append(constraintName);
        }
        EAnnotation eAnnotation = eClassifier.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
        if (s != null) {
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore");
                eClassifier.getEAnnotations().add(0, (Object)eAnnotation);
            }
            eAnnotation.getDetails().put((Object)"constraints", (Object)s.toString());
        } else {
            eClassifier.getEAnnotations().remove((Object)eAnnotation);
        }
    }

    public static void installDelegates(EPackage ePackage) {
        EAnnotation packageAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
        if (packageAnnotation == null) {
            packageAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            packageAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore");
            ePackage.getEAnnotations().add((Object)packageAnnotation);
        }
        EMap details = packageAnnotation.getDetails();
        details.put((Object)"invocationDelegates", (Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        details.put((Object)"settingDelegates", (Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        details.put((Object)"validationDelegates", (Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
    }

    public Pivot2Ecore(TypeManager typeManager) {
        this.typeManager = typeManager;
    }

    protected EObject convert(Element pivotObject) {
        EObject eObject = (EObject)this.pass1.safeVisit(pivotObject);
        for (Element eKey : this.deferMap) {
            this.pass2.safeVisit(eKey);
        }
        return eObject;
    }

    protected List<EObject> convertAll(List<? extends EObject> pivotObjects) {
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        for (EObject eObject : pivotObjects) {
            if (!(eObject instanceof Element)) continue;
            eObjects.add((EObject)this.pass1.safeVisit((Visitable)eObject));
        }
        for (Element element : this.deferMap) {
            this.pass2.safeVisit(element);
        }
        return eObjects;
    }

    protected void error(String message) {
        if (this.errors == null) {
            this.errors = new ArrayList<Resource.Diagnostic>();
        }
        this.errors.add((Resource.Diagnostic)new XMIException(message));
    }

    public void defer(Element pivotElement) {
        this.deferMap.add(pivotElement);
    }

    public <T extends EObject> T getCreated(java.lang.Class<T> requiredClass, Element pivotElement) {
        EModelElement eModelElement = this.createMap.get(pivotElement);
        if (eModelElement == null) {
            return null;
        }
        if (!requiredClass.isAssignableFrom(eModelElement.getClass())) {
            logger.error((Object)("Ecore " + eModelElement.getClass().getName() + "' element is not a '" + requiredClass.getName() + "'"));
            return null;
        }
        EModelElement castElement = eModelElement;
        return (T)castElement;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public void putCreated(Element pivotElement, EModelElement eModelElement) {
        EModelElement old = this.createMap.put(pivotElement, eModelElement);
        assert (old == null);
    }
}

