/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2EcoreTypeRefVisitor;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2EcoreReferenceVisitor
extends AbstractExtendingVisitor<EObject, Pivot2Ecore> {
    protected final Pivot2EcoreTypeRefVisitor typeRefVisitor;

    public Pivot2EcoreReferenceVisitor(Pivot2Ecore context) {
        super(context);
        this.typeRefVisitor = new Pivot2EcoreTypeRefVisitor(context);
    }

    public <T extends EObject> void safeVisitAll(List<T> eObjects, List<? extends Element> pivotObjects) {
        for (Element element : pivotObjects) {
            EObject eObject = (EObject)this.safeVisit(element);
            if (eObject == null) continue;
            eObjects.add(eObject);
        }
    }

    public <T extends EClassifier> void safeVisitAll(List<EGenericType> eGenericTypes, List<T> eTypes, List<? extends Type> superClasses) {
        if (superClasses.size() > 0) {
            ArrayList superEClasses = new ArrayList(superClasses.size());
            this.typeRefVisitor.safeVisitAll(superEClasses, superClasses);
            eTypes.clear();
            eGenericTypes.clear();
            for (EObject superEClass : superEClasses) {
                if (superEClass instanceof EGenericType) {
                    eGenericTypes.add((EGenericType)superEClass);
                    continue;
                }
                EClassifier castSuperEClass = (EClassifier)superEClass;
                eTypes.add(castSuperEClass);
            }
        } else {
            eGenericTypes.clear();
        }
    }

    @Override
    public EObject visiting(Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for Pivot2Ecore Reference pass");
    }

    @Override
    public EObject visitAnnotation(Annotation pivotAnnotation) {
        EAnnotation eAnnotation = ((Pivot2Ecore)((Object)this.context)).getCreated(EAnnotation.class, pivotAnnotation);
        eAnnotation.getReferences().clear();
        for (Element pivotReference : pivotAnnotation.getReferences()) {
            EObject eReference = ((Pivot2Ecore)((Object)this.context)).getCreated(EObject.class, pivotReference);
            eAnnotation.getReferences().add((Object)eReference);
        }
        return eAnnotation;
    }

    @Override
    public EObject visitClass(Class pivotClass) {
        EClass eClass = ((Pivot2Ecore)((Object)this.context)).getCreated(EClass.class, pivotClass);
        this.safeVisitAll((List<EGenericType>)eClass.getEGenericSuperTypes(), (List)eClass.getESuperTypes(), (List<? extends Type>)pivotClass.getSuperClasses());
        return eClass;
    }

    @Override
    public EObject visitDataType(DataType pivotDataType) {
        EDataType eDataType = ((Pivot2Ecore)((Object)this.context)).getCreated(EDataType.class, pivotDataType);
        return eDataType;
    }

    @Override
    public EObject visitOperation(Operation pivotOperation) {
        EOperation eOperation = ((Pivot2Ecore)((Object)this.context)).getCreated(EOperation.class, pivotOperation);
        this.safeVisitAll((List<EGenericType>)eOperation.getEGenericExceptions(), (List)eOperation.getEExceptions(), (List<? extends Type>)pivotOperation.getRaisedExceptions());
        return (EObject)super.visitOperation(pivotOperation);
    }

    @Override
    public EObject visitPackage(Package pivotPackage) {
        EPackage ePackage = ((Pivot2Ecore)((Object)this.context)).getCreated(EPackage.class, pivotPackage);
        boolean needsDelegates = false;
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            EAnnotation classifierAnnotation = eClassifier.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
            if (classifierAnnotation != null && !classifierAnnotation.getDetails().isEmpty()) {
                needsDelegates = true;
                break;
            }
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            for (EStructuralFeature eFeature : eClass.getEStructuralFeatures()) {
                EAnnotation featureAnnotation = eFeature.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
                if (featureAnnotation == null || featureAnnotation.getDetails().isEmpty()) continue;
                needsDelegates = true;
                break;
            }
            if (needsDelegates) break;
            for (EOperation eOperation : eClass.getEOperations()) {
                EAnnotation operationAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
                if (operationAnnotation == null || operationAnnotation.getDetails().isEmpty()) continue;
                needsDelegates = true;
                break;
            }
            if (needsDelegates) break;
        }
        if (needsDelegates) {
            Pivot2Ecore.installDelegates(ePackage);
        }
        return null;
    }

    @Override
    public EObject visitProperty(Property pivotProperty) {
        if (pivotProperty.isImplicit()) {
            return null;
        }
        EStructuralFeature eStructuralFeature = ((Pivot2Ecore)((Object)this.context)).getCreated(EStructuralFeature.class, pivotProperty);
        if (eStructuralFeature instanceof EReference) {
            EReference eOpposite;
            EReference eReference = (EReference)eStructuralFeature;
            Property pivotOpposite = pivotProperty.getOpposite();
            if (pivotOpposite != null && !pivotOpposite.isImplicit() && (eOpposite = ((Pivot2Ecore)((Object)this.context)).getCreated(EReference.class, pivotOpposite)) != null) {
                eReference.setEOpposite(eOpposite);
            }
            for (Property pivotKey : pivotProperty.getKeys()) {
                EAttribute eAttribute = ((Pivot2Ecore)((Object)this.context)).getCreated(EAttribute.class, pivotKey);
                if (eAttribute == null) continue;
                eReference.getEKeys().add((Object)eAttribute);
            }
        }
        return (EObject)super.visitProperty(pivotProperty);
    }

    @Override
    public EObject visitTypeTemplateParameter(TypeTemplateParameter pivotTypeTemplateParameter) {
        ETypeParameter eTypeParameter = ((Pivot2Ecore)((Object)this.context)).getCreated(ETypeParameter.class, pivotTypeTemplateParameter);
        for (Type constrainingType : pivotTypeTemplateParameter.getConstrainingTypes()) {
            EGenericType eGenericType = this.typeRefVisitor.resolveEGenericType(constrainingType);
            eTypeParameter.getEBounds().add((Object)eGenericType);
        }
        return null;
    }

    @Override
    public EObject visitTypedElement(TypedElement pivotTypedElement) {
        ETypedElement eTypedElement = ((Pivot2Ecore)((Object)this.context)).getCreated(ETypedElement.class, pivotTypedElement);
        Type pivotType = pivotTypedElement.getType();
        if (pivotType == null) {
            return null;
        }
        EObject eObject = (EObject)this.typeRefVisitor.safeVisit(pivotType);
        if (eObject instanceof EGenericType) {
            eTypedElement.setEGenericType((EGenericType)eObject);
        } else if (eObject instanceof EClassifier) {
            eTypedElement.setEType((EClassifier)eObject);
        } else if (eObject instanceof ETypeParameter) {
            EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
            eGenericType.setETypeParameter((ETypeParameter)eObject);
            eTypedElement.setEGenericType(eGenericType);
        } else {
            throw new IllegalArgumentException("Unsupported pivot type '" + pivotType + "' in Pivot2Ecore Reference pass");
        }
        return null;
    }
}

