/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.helper;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.OCLBase;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.helper.OCLHelper;

abstract class OCLBaseHelperImpl
implements OCLHelper {
    private final EnvironmentFactory environmentFactory;
    private Environment env;
    private boolean validating = true;
    private final OCL ocl;
    private Diagnostic problems;

    OCLBaseHelperImpl(OCL ocl) {
        this.ocl = ocl;
        this.environmentFactory = ocl.getEnvironment().getFactory();
    }

    public Environment getEnvironment() {
        return this.env == null ? this.ocl.getEnvironment() : this.env;
    }

    public OCLBase getOCL() {
        return this.ocl;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    private void setEnvironment(Environment env) {
        this.env = env;
    }

    public void setContext(Type context) {
        this.setEnvironment(this.environmentFactory.createClassifierContext(this.ocl.getEnvironment(), context));
    }

    public void setOperationContext(Type context, Operation operation) {
        this.setContext(context);
        this.setEnvironment(this.environmentFactory.createOperationContext(this.env, operation));
    }

    public void setAttributeContext(Type context, Property property) {
        this.setContext(context);
        this.setEnvironment(this.environmentFactory.createAttributeContext(this.env, property));
    }

    public void setInstanceContext(Object instance) {
        this.setEnvironment(this.environmentFactory.createInstanceContext(this.ocl.getEnvironment(), instance));
    }

    public void setInstanceOperationContext(Object instance, Operation operation) {
        this.setInstanceContext(instance);
        this.setEnvironment(this.environmentFactory.createOperationContext(this.env, operation));
    }

    public void setInstanceAttributeContext(Object instance, Property property) {
        this.setInstanceContext(instance);
        this.setEnvironment(this.environmentFactory.createAttributeContext(this.env, property));
    }

    public Diagnostic getProblems() {
        return this.problems;
    }

    void setProblems(Diagnostic problems) {
        this.problems = problems;
    }
}

