/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library;

import java.lang.reflect.Method;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.evaluation.CallableImplementation;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.osgi.util.NLS;

public abstract class JavaComparisonOperation
implements CallableImplementation,
Value.BinaryOperation {
    protected final Method method;

    public JavaComparisonOperation(Method method) {
        this.method = method;
    }

    public Value evaluate(EvaluationVisitor evaluationVisitor, Value sourceValue, CallExp callExp) {
        OperationCallExp operationCall = (OperationCallExp)callExp;
        OclExpression arg = (OclExpression)operationCall.getArguments().get(0);
        Value argVal = (Value)arg.accept(evaluationVisitor);
        try {
            return this.evaluate(evaluationVisitor.getValueFactory(), sourceValue, argVal);
        }
        catch (InvalidValueException e) {
            return evaluationVisitor.throwInvalidEvaluation(e);
        }
    }

    public Value evaluate(ValueFactory valueFactory, Value leftValue, Value rightValue) throws InvalidValueException {
        Object leftObject = leftValue.asObject();
        Object rightObject = rightValue.asObject();
        try {
            Object result = this.method.invoke(leftObject, rightObject);
            if (!(result instanceof Integer)) {
                return this.throwInvalidValueException(EvaluatorMessages.TypedResultRequired, "Integer");
            }
            return valueFactory.booleanValueOf(this.evaluateComparison((Integer)result));
        }
        catch (Exception e) {
            throw new InvalidValueException(e);
        }
    }

    protected abstract boolean evaluateComparison(Integer var1);

    protected Value throwInvalidValueException(String message, Object ... bindings) throws InvalidValueException {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        throw new InvalidValueException(boundMessage);
    }

    public Diagnostic validate(TypeManager typeManager, CallExp callExp) {
        return null;
    }
}

