/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.prettyprint;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrintNameVisitor;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyPrintTypeVisitor
extends AbstractExtendingVisitor<Object, Namespace> {
    public static final String NULL_PLACEHOLDER = "<null>";
    public static Set<String> reservedNames;
    public static Set<String> restrictedNames;
    private static String[] reservedNameList;
    private static String[] restrictedNameList;
    protected final Namespace scope = null;
    protected final StringBuffer s = new StringBuffer();

    static {
        String name;
        reservedNames = new HashSet<String>();
        restrictedNames = new HashSet<String>();
        reservedNameList = new String[]{"and", "else", "endif", "false", "if", "implies", "in", "invalid", "let", "not", "null", "or", "self", "then", "true", "xor"};
        restrictedNameList = new String[]{"Bag", "Boolean", "Collection", "Integer", "OclAny", "OclInvalid", "OclVoid", "OrderedSet", "Real", "Sequence", "Set", "String", "Tuple", "UnlimitedNatural"};
        String[] stringArray = reservedNameList;
        int n = reservedNameList.length;
        int n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            reservedNames.add(name);
            restrictedNames.add(name);
            ++n2;
        }
        stringArray = restrictedNameList;
        n = restrictedNameList.length;
        n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            restrictedNames.add(name);
            ++n2;
        }
    }

    public static String prettyPrint(Visitable element, Namespace scope) {
        PrettyPrintTypeVisitor visitor = new PrettyPrintTypeVisitor(scope);
        try {
            visitor.safeVisit(element);
            return visitor.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(visitor.toString()) + " ... " + e.getClass().getName() + " - " + e.getLocalizedMessage();
        }
    }

    public PrettyPrintTypeVisitor(Namespace scope) {
        super(scope);
    }

    protected void append(Number number) {
        if (number != null) {
            this.s.append(number.toString());
        } else {
            this.s.append(NULL_PLACEHOLDER);
        }
    }

    protected void append(String string) {
        if (string != null) {
            this.s.append(string);
        } else {
            this.s.append(NULL_PLACEHOLDER);
        }
    }

    protected void appendElement(Element element) {
        this.safeVisit(element);
    }

    protected void appendName(NamedElement object) {
        this.appendName(object, restrictedNames);
    }

    protected void appendName(NamedElement object, Set<String> keywords) {
        if (object == null) {
            this.s.append(NULL_PLACEHOLDER);
        } else {
            String name = object.getName();
            if (keywords != null && (keywords.contains(name) || !PivotUtil.isValidIdentifier(name))) {
                this.s.append("_'");
                this.s.append(PivotUtil.convertToOCLString(name));
                this.s.append("'");
            } else {
                this.s.append(name);
            }
        }
    }

    protected void appendParameters(Operation operation) {
        this.append("(");
        String prefix = "";
        if (operation instanceof Iteration) {
            Iteration iteration = (Iteration)operation;
            for (Parameter parameter : iteration.getOwnedIterators()) {
                this.s.append(prefix);
                this.appendTypedMultiplicity(parameter);
                prefix = ",";
            }
            if (iteration.getOwnedAccumulators().size() > 0) {
                prefix = ";";
                for (Parameter parameter : iteration.getOwnedAccumulators()) {
                    this.s.append(prefix);
                    this.appendTypedMultiplicity(parameter);
                    prefix = ",";
                }
            }
            prefix = "|";
        }
        for (Parameter parameter : operation.getOwnedParameters()) {
            this.append(prefix);
            this.appendTypedMultiplicity(parameter);
            prefix = ",";
        }
        this.append(")");
    }

    protected void appendParent(EObject scope, Element element, String parentSeparator) {
        if (element == null) {
            this.append(NULL_PLACEHOLDER);
        } else {
            Namespace parent = PrettyPrintNameVisitor.getNamespace(element.eContainer());
            if (parent instanceof Package && "$$".equals(((Package)parent).getName())) {
                return;
            }
            if (element instanceof Operation && parent instanceof Class && "$$".equals(((Class)parent).getName())) {
                Operation unspecializedOperation = PivotUtil.getUnspecializedTemplateableElement((Operation)element);
                this.append(unspecializedOperation.getClass_().getName());
                this.appendTemplateBindings((Operation)element);
                this.append(parentSeparator);
                return;
            }
            if (parent == scope) {
                return;
            }
            if (parent instanceof Visitable) {
                this.safeVisit(parent);
            } else assert (element instanceof Package || element instanceof ExpressionInOcl) : element.eClass().getName();
        }
        this.append(parentSeparator);
    }

    protected void appendTemplateBindings(TemplateableElement typeRef) {
        boolean useParentheses = typeRef instanceof CollectionType;
        EList<TemplateBinding> templateBindings = typeRef.getTemplateBindings();
        if (!templateBindings.isEmpty()) {
            this.append(useParentheses ? "(" : "<");
            String prefix = "";
            for (TemplateBinding templateBinding : templateBindings) {
                for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitutions()) {
                    this.append(prefix);
                    this.appendElement(templateParameterSubstitution.getActual());
                    prefix = ", ";
                }
            }
            this.append(useParentheses ? ")" : ">");
        }
    }

    public void appendTemplateParameters(TemplateableElement templateableElement) {
        EList<TemplateParameter> templateParameters;
        boolean useParentheses = templateableElement instanceof CollectionType;
        TemplateSignature templateSignature = templateableElement.getOwnedTemplateSignature();
        if (templateSignature != null && !(templateParameters = templateSignature.getOwnedParameters()).isEmpty()) {
            this.s.append(useParentheses ? "(" : "<");
            String prefix = "";
            for (TemplateParameter templateParameter : templateParameters) {
                this.s.append(prefix);
                this.appendName((NamedElement)((Object)templateParameter.getParameteredElement()), restrictedNames);
                prefix = ", ";
            }
            this.s.append(useParentheses ? ")" : ">");
        }
    }

    public void appendTypedMultiplicity(TypedMultiplicityElement object) {
        int lower = object.getLower().intValue();
        int upper = object.getUpper().intValue();
        if (upper != 1) {
            if (object.isOrdered()) {
                if (object.isUnique()) {
                    this.append("OrderedSet<");
                } else {
                    this.append("Sequence<");
                }
            } else if (object.isUnique()) {
                this.append("Set<");
            } else {
                this.append("Bag<");
            }
            this.appendElement(object.getType());
            if (lower > 0 || upper >= 0) {
                PivotUtil.appendMultiplicity(this.s, lower, upper);
            }
            this.append(">");
        } else {
            this.appendElement(object.getType());
            PivotUtil.appendMultiplicity(this.s, lower, upper);
        }
    }

    public String toString() {
        return this.s.toString();
    }

    @Override
    public Object visitLambdaType(LambdaType object) {
        this.appendName(object, restrictedNames);
        this.s.append(" ");
        this.appendElement(object.getContextType());
        this.append("(");
        String prefix = "";
        for (Type parameterType : object.getParameterTypes()) {
            this.append(prefix);
            this.appendElement(parameterType);
            prefix = ",";
        }
        this.append(") : ");
        this.appendElement(object.getResultType());
        return null;
    }

    @Override
    public String visitNamedElement(NamedElement object) {
        this.appendParent(null, object, "::");
        this.appendName(object, reservedNames);
        return null;
    }

    @Override
    public Object visitOperation(Operation operation) {
        this.appendParent(null, operation, "::");
        this.appendName(operation, reservedNames);
        this.appendTemplateParameters(operation);
        this.appendTemplateBindings(operation);
        this.append("(");
        String prefix = "";
        if (operation instanceof Iteration) {
            Iteration iteration = (Iteration)operation;
            for (Parameter parameter : iteration.getOwnedIterators()) {
                this.s.append(prefix);
                this.appendTypedMultiplicity(parameter);
                prefix = ",";
            }
            if (iteration.getOwnedAccumulators().size() > 0) {
                prefix = ";";
                for (Parameter parameter : iteration.getOwnedAccumulators()) {
                    this.s.append(prefix);
                    this.appendTypedMultiplicity(parameter);
                    prefix = ",";
                }
            }
            prefix = "|";
        }
        for (Parameter parameter : operation.getOwnedParameters()) {
            this.append(prefix);
            this.appendTypedMultiplicity(parameter);
            prefix = ",";
        }
        this.append(")");
        return null;
    }

    @Override
    public Object visitTemplateParameter(TemplateParameter object) {
        this.appendName((NamedElement)((Object)object.getParameteredElement()), restrictedNames);
        return null;
    }

    @Override
    public Object visitTupleType(TupleType object) {
        this.appendName(object, null);
        this.s.append("(");
        EList<Property> tupleParts = object.getOwnedAttributes();
        if (!tupleParts.isEmpty()) {
            String prefix = "";
            for (Property tuplePart : tupleParts) {
                this.append(prefix);
                this.appendName(tuplePart, restrictedNames);
                this.append(" : ");
                this.appendElement(tuplePart.getType());
                prefix = ", ";
            }
        }
        this.s.append(")");
        return null;
    }

    @Override
    public Object visitType(Type object) {
        this.appendParent(object.eContainer(), object, "::");
        this.appendName(object, reservedNames);
        this.appendTemplateParameters(object);
        this.appendTemplateBindings(object);
        return null;
    }

    @Override
    public Object visitTypedElement(TypedElement object) {
        this.appendParent(object.eContainer(), object, "::");
        this.appendElement(object.getType());
        return null;
    }

    @Override
    public Object visitTypedMultiplicityElement(TypedMultiplicityElement object) {
        this.appendParent(object.eContainer(), object, "::");
        this.appendTypedMultiplicity(object);
        return null;
    }

    @Override
    public String visiting(Visitable visitable) {
        return visitable == null ? NULL_PLACEHOLDER : visitable.getClass().getName();
    }
}

