/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import com.google.common.collect.Iterators;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompleteElementIterable<O, I>
implements Iterable<I> {
    protected final Iterable<? extends O> iterables;

    public CompleteElementIterable(Iterable<? extends O> iterables) {
        this.iterables = iterables;
    }

    protected abstract Iterable<I> getInnerIterable(O var1);

    protected I getInnerValue(I element) {
        return element;
    }

    @Override
    public java.util.Iterator<I> iterator() {
        if (this.iterables instanceof List) {
            List list = (List)this.iterables;
            if (list.size() == 0) {
                return Iterators.emptyIterator();
            }
            if (list.size() == 1) {
                Iterable<I> innerIterable = this.getInnerIterable(list.get(0));
                if (innerIterable != null) {
                    return innerIterable.iterator();
                }
                return Iterators.emptyIterator();
            }
        }
        if (this.iterables != null) {
            return new Iterator(this.iterables);
        }
        return Iterators.emptyIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Iterator
    implements java.util.Iterator<I> {
        private final java.util.Iterator<? extends O> outerIterator;
        private java.util.Iterator<I> innerIterator;
        private I nextValue;

        public Iterator(Iterable<? extends O> iterables) {
            this.outerIterator = iterables.iterator();
            this.innerIterator = null;
            this.advance();
        }

        protected boolean advance() {
            while (true) {
                if (this.innerIterator != null) {
                    while (this.innerIterator.hasNext()) {
                        this.nextValue = CompleteElementIterable.this.getInnerValue(this.innerIterator.next());
                        if (this.nextValue == null) continue;
                        return true;
                    }
                }
                if (!this.outerIterator.hasNext()) break;
                Iterable innerIterable = CompleteElementIterable.this.getInnerIterable(this.outerIterator.next());
                if (innerIterable == null) continue;
                this.innerIterator = innerIterable.iterator();
            }
            this.nextValue = null;
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.nextValue != null;
        }

        @Override
        public I next() {
            try {
                Object i = this.nextValue;
                return i;
            }
            finally {
                this.advance();
            }
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

