/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotSaver {
    protected final Resource resource;
    private PivotSaveLocateVisitor locateVisitor = new PivotSaveLocateVisitor();
    private Map<String, Type> types = new HashMap<String, Type>();
    private Map<String, Operation> operations = new HashMap<String, Operation>();
    private List<Element> specializingElements = new ArrayList<Element>();
    private Package orphanage = null;
    private Class orphanageClass = null;

    public PivotSaver(Resource resource) {
        this.resource = resource;
    }

    protected Package getOrphanPackage(Resource resource) {
        if (this.orphanage == null) {
            this.orphanage = PivotFactory.eINSTANCE.createPackage();
            this.orphanage.setName("$$");
            this.orphanage.setMoniker("$$");
            resource.getContents().add((Object)this.orphanage);
            this.orphanageClass = PivotFactory.eINSTANCE.createClass();
            this.orphanageClass.setName("$$");
            this.orphanage.getOwnedTypes().add((Object)this.orphanageClass);
        }
        return this.orphanage;
    }

    protected boolean isOrphanOperation(Operation operation) {
        return operation.getTemplateBindings().size() > 0;
    }

    protected boolean isOrphanType(Type type) {
        if (type.getTemplateBindings().size() > 0) {
            return true;
        }
        if (type instanceof LambdaType) {
            return true;
        }
        return type instanceof TupleType;
    }

    public Package localizeSpecializations() {
        this.locateSpecializations((List<? extends EObject>)this.resource.getContents());
        if (this.specializingElements.size() > 0) {
            this.orphanage = this.getOrphanPackage(this.resource);
            PivotSaveResolveVisitor resolveVisitor = new PivotSaveResolveVisitor();
            int i = 0;
            while (i < this.specializingElements.size()) {
                Element element = this.specializingElements.get(i);
                resolveVisitor.safeVisit(element);
                ++i;
            }
            EList<Type> ownedTypes = this.orphanage.getOwnedTypes();
            List<Type> sorted = PivotUtil.sortByMoniker(new ArrayList<Type>((Collection<Type>)ownedTypes));
            ownedTypes.clear();
            ownedTypes.addAll(sorted);
        }
        return this.orphanage;
    }

    protected void locateSpecializations(List<? extends EObject> eObjects) {
        for (EObject eObject : eObjects) {
            if (eObject instanceof Visitable) {
                this.locateVisitor.safeVisit((Visitable)eObject);
            }
            this.locateSpecializations((List<? extends EObject>)eObject.eContents());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PivotSaveLocateVisitor
    extends AbstractExtendingVisitor<Object, Object> {
        protected PivotSaveLocateVisitor() {
            super(null);
        }

        @Override
        public Object visitClass(Class object) {
            for (Class superClass : object.getSuperClasses()) {
                if (superClass.getTemplateBindings().size() <= 0) continue;
                PivotSaver.this.specializingElements.add(object);
                break;
            }
            return null;
        }

        @Override
        public Object visitCollectionType(CollectionType object) {
            Type referredType = object.getElementType();
            if (referredType != null && PivotSaver.this.isOrphanType(referredType)) {
                PivotSaver.this.specializingElements.add(object);
            }
            return super.visitCollectionType(object);
        }

        @Override
        public Object visitLambdaType(LambdaType object) {
            boolean doneIt = false;
            Type referredType = object.getContextType();
            if (referredType != null && PivotSaver.this.isOrphanType(referredType)) {
                PivotSaver.this.specializingElements.add(object);
                doneIt = true;
            }
            if (!doneIt) {
                referredType = object.getResultType();
                if (referredType != null && PivotSaver.this.isOrphanType(referredType)) {
                    PivotSaver.this.specializingElements.add(object);
                    doneIt = true;
                }
                if (!doneIt) {
                    for (Type parameterType : object.getParameterTypes()) {
                        if (parameterType == null || !PivotSaver.this.isOrphanType(parameterType)) continue;
                        PivotSaver.this.specializingElements.add(object);
                        break;
                    }
                }
            }
            return super.visitLambdaType(object);
        }

        @Override
        public Object visitLoopExp(LoopExp object) {
            Iteration referredIteration = object.getReferredIteration();
            if (referredIteration != null && PivotSaver.this.isOrphanOperation(referredIteration)) {
                PivotSaver.this.specializingElements.add(object);
            }
            return super.visitLoopExp(object);
        }

        @Override
        public Object visitOperationCallExp(OperationCallExp object) {
            Operation referredOperation = object.getReferredOperation();
            if (referredOperation != null && PivotSaver.this.isOrphanOperation(referredOperation)) {
                PivotSaver.this.specializingElements.add(object);
            }
            return super.visitOperationCallExp(object);
        }

        @Override
        public Object visitTemplateParameterSubstitution(TemplateParameterSubstitution object) {
            Type referredType;
            ParameterableElement actual = object.getActual();
            if (actual instanceof Type && PivotSaver.this.isOrphanType(referredType = (Type)actual)) {
                PivotSaver.this.specializingElements.add(object);
            }
            return null;
        }

        @Override
        public Object visitTypedElement(TypedElement object) {
            Type referredType = object.getType();
            if (referredType != null && PivotSaver.this.isOrphanType(referredType)) {
                PivotSaver.this.specializingElements.add(object);
            }
            return null;
        }

        @Override
        public Object visitTypeTemplateParameter(TypeTemplateParameter object) {
            for (Type constrainingType : object.getConstrainingTypes()) {
                if (!PivotSaver.this.isOrphanType(constrainingType)) continue;
                PivotSaver.this.specializingElements.add(object);
                break;
            }
            return null;
        }

        @Override
        public Object visiting(Visitable visitable) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PivotSaveResolveVisitor
    extends AbstractExtendingVisitor<Object, Object> {
        protected PivotSaveResolveVisitor() {
            super(null);
        }

        protected <T extends Operation> T resolveOperation(T referredOperation) {
            if (!PivotSaver.this.isOrphanOperation(referredOperation)) {
                return referredOperation;
            }
            String moniker = referredOperation.getMoniker();
            Operation operation = (Operation)PivotSaver.this.operations.get(moniker);
            if (operation != null) {
                Operation castOperation = operation;
                return (T)castOperation;
            }
            Operation resolvedOperation = (Operation)EcoreUtil.copy(referredOperation);
            PivotSaver.this.orphanageClass.getOwnedOperations().add((Object)resolvedOperation);
            PivotSaver.this.operations.put(moniker, resolvedOperation);
            String newMoniker = resolvedOperation.getMoniker();
            assert (moniker.equals(newMoniker));
            PivotSaver.this.locateSpecializations(Collections.singletonList(resolvedOperation));
            return (T)resolvedOperation;
        }

        protected <T extends Type> T resolveType(T referredType) {
            if (!PivotSaver.this.isOrphanType(referredType)) {
                return referredType;
            }
            String moniker = referredType.getMoniker();
            Type type = (Type)PivotSaver.this.types.get(moniker);
            if (type != null) {
                Type castType = type;
                return (T)castType;
            }
            Type resolvedType = (Type)EcoreUtil.copy(referredType);
            PivotSaver.this.orphanage.getOwnedTypes().add((Object)resolvedType);
            PivotSaver.this.types.put(moniker, resolvedType);
            String newMoniker = resolvedType.getMoniker();
            assert (moniker.equals(newMoniker)) : String.valueOf(newMoniker) + " is not equal to " + moniker;
            PivotSaver.this.locateSpecializations(Collections.singletonList(resolvedType));
            return (T)resolvedType;
        }

        @Override
        public Object visitClass(Class object) {
            EList<Class> superClasses = object.getSuperClasses();
            int i = 0;
            while (i < superClasses.size()) {
                Class referredClass = (Class)superClasses.get(i);
                Class resolvedClass = this.resolveType(referredClass);
                if (resolvedClass != null) {
                    superClasses.set(i, resolvedClass);
                }
                ++i;
            }
            return null;
        }

        @Override
        public Object visitClassifierType(ClassifierType object) {
            Type referredType = object.getInstanceType();
            Type resolvedType = this.resolveType(referredType);
            if (resolvedType != null) {
                object.setInstanceType(resolvedType);
            }
            return super.visitClassifierType(object);
        }

        @Override
        public Object visitCollectionType(CollectionType object) {
            Type referredType = object.getElementType();
            Type resolvedType = this.resolveType(referredType);
            if (resolvedType != null) {
                object.setElementType(resolvedType);
            }
            return super.visitCollectionType(object);
        }

        @Override
        public Object visitLambdaType(LambdaType object) {
            Type referredType = object.getContextType();
            Type resolvedType = this.resolveType(referredType);
            if (resolvedType != null) {
                object.setContextType(resolvedType);
            }
            if ((resolvedType = this.resolveType(referredType = object.getResultType())) != null) {
                object.setResultType(resolvedType);
            }
            EList<Type> parameterTypes = object.getParameterTypes();
            int i = 0;
            while (i < parameterTypes.size()) {
                referredType = (Type)parameterTypes.get(i);
                resolvedType = this.resolveType(referredType);
                if (resolvedType != null) {
                    parameterTypes.set(i, resolvedType);
                }
                ++i;
            }
            return super.visitLambdaType(object);
        }

        @Override
        public Object visitLoopExp(LoopExp object) {
            Iteration referredIteration = object.getReferredIteration();
            Iteration resolvedIteration = this.resolveOperation(referredIteration);
            if (resolvedIteration != null) {
                object.setReferredIteration(resolvedIteration);
            }
            return null;
        }

        @Override
        public Object visitOperationCallExp(OperationCallExp object) {
            Operation referredOperation = object.getReferredOperation();
            Operation resolvedOperation = this.resolveOperation(referredOperation);
            if (resolvedOperation != null) {
                object.setReferredOperation(resolvedOperation);
            }
            return null;
        }

        @Override
        public Object visitTemplateParameterSubstitution(TemplateParameterSubstitution object) {
            Type referredType = (Type)object.getActual();
            Type resolvedType = this.resolveType(referredType);
            if (resolvedType != null) {
                object.setActual(resolvedType);
            }
            return null;
        }

        @Override
        public Object visitTypeTemplateParameter(TypeTemplateParameter object) {
            EList<Type> constrainingTypes = object.getConstrainingTypes();
            int i = 0;
            while (i < constrainingTypes.size()) {
                Type referredType = (Type)constrainingTypes.get(i);
                Type resolvedType = this.resolveType(referredType);
                if (resolvedType != null) {
                    constrainingTypes.set(i, resolvedType);
                }
                ++i;
            }
            return null;
        }

        @Override
        public Object visitTypedElement(TypedElement object) {
            Type referredType = object.getType();
            Type resolvedType = this.resolveType(referredType);
            if (resolvedType != null) {
                object.setType(resolvedType);
            }
            return null;
        }

        @Override
        public Object visiting(Visitable visitable) {
            throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for PivotSaver Resolve pass");
        }
    }
}

