/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.BagType;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.OrderedSetType;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.SequenceType;
import org.eclipse.ocl.examples.pivot.SetType;
import org.eclipse.ocl.examples.pivot.StandardLibrary;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.osgi.util.NLS;

public abstract class PivotStandardLibrary
implements StandardLibrary {
    private static final Logger logger = Logger.getLogger(PivotStandardLibrary.class);
    public static final String DEFAULT_OCL_STDLIB_URI = "http://www.eclipse.org/ocl/3.1.0/OCL.oclstdlib";
    protected String defaultStandardLibraryURI = "http://www.eclipse.org/ocl/3.1.0/OCL.oclstdlib";
    private BagType bagType = null;
    private PrimitiveType booleanType = null;
    private ClassifierType classifierType = null;
    private CollectionType collectionType = null;
    private Class enumerationType = null;
    private PrimitiveType integerType = null;
    private AnyType oclAnyType = null;
    private InvalidType oclInvalidType = null;
    private VoidType oclVoidType = null;
    private OrderedSetType orderedSetType = null;
    private PrimitiveType realType = null;
    private SequenceType sequenceType = null;
    private SetType setType = null;
    private PrimitiveType stringType = null;
    private TupleType tupleType = null;
    private PrimitiveType unlimitedNaturalType = null;
    private Map<String, Type> nameToLibraryTypeMap = null;

    protected void defineLibraryType(Type pivotType) {
        String name;
        Type oldType;
        if (this.nameToLibraryTypeMap == null) {
            this.nameToLibraryTypeMap = new HashMap<String, Type>();
        }
        if ((oldType = this.nameToLibraryTypeMap.put(name = pivotType.getName(), pivotType)) != null && oldType != pivotType) {
            logger.warn((Object)("Conflicting pivot type '" + name + "'"));
        }
    }

    public BagType getBagType() {
        if (this.bagType == null) {
            Type type = this.getRequiredLibraryType("Bag");
            if (type instanceof BagType) {
                if (((BagType)type).getOwnedTemplateSignature() == null) {
                    throw new IllegalLibraryException("Bag is not a templated type");
                }
                if (((BagType)type).getOwnedTemplateSignature().getParameters().size() != 1) {
                    throw new IllegalLibraryException("Bag is not a templated type with a single argument");
                }
                this.bagType = (BagType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Bag is not a BagType");
            }
        }
        return this.bagType;
    }

    public PrimitiveType getBooleanType() {
        if (this.booleanType == null) {
            Type type = this.getRequiredLibraryType("Boolean");
            if (type instanceof PrimitiveType) {
                this.booleanType = (PrimitiveType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Boolean is not a PrimitiveType");
            }
        }
        return this.booleanType;
    }

    public ClassifierType getClassifierType() {
        if (this.classifierType == null) {
            Type type = this.getRequiredLibraryType("Classifier");
            if (type instanceof ClassifierType) {
                if (((ClassifierType)type).getOwnedTemplateSignature() == null) {
                    throw new IllegalLibraryException("Classifier is not a templated type");
                }
                if (((ClassifierType)type).getOwnedTemplateSignature().getParameters().size() != 1) {
                    throw new IllegalLibraryException("Classifier is not a templated type with a single argument");
                }
                this.classifierType = (ClassifierType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Classifier is not a ClassifierType");
            }
        }
        return this.classifierType;
    }

    public CollectionType getCollectionType() {
        if (this.collectionType == null) {
            Type type = this.getRequiredLibraryType("Collection");
            if (type instanceof CollectionType) {
                if (((CollectionType)type).getOwnedTemplateSignature() == null) {
                    throw new IllegalLibraryException("Collection is not a templated type");
                }
                if (((CollectionType)type).getOwnedTemplateSignature().getParameters().size() != 1) {
                    throw new IllegalLibraryException("Collection is not a templated type with a single argument");
                }
                this.collectionType = (CollectionType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Collection is not a CollectionType");
            }
        }
        return this.collectionType;
    }

    public Class getEnumerationType() {
        if (this.enumerationType == null) {
            Type type = this.getRequiredLibraryType("Enumeration");
            if (type instanceof Class) {
                this.enumerationType = (Class)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Enumeration is not a Class");
            }
        }
        return this.enumerationType;
    }

    public PrimitiveType getIntegerType() {
        if (this.integerType == null) {
            Type type = this.getRequiredLibraryType("Integer");
            if (type instanceof PrimitiveType) {
                this.integerType = (PrimitiveType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Integer is not a PrimitiveType");
            }
        }
        return this.integerType;
    }

    public Type getLibraryType(String typeName) {
        if (this.nameToLibraryTypeMap == null) {
            this.nameToLibraryTypeMap = new HashMap<String, Type>();
            this.loadDefaultLibrary(this.defaultStandardLibraryURI);
        }
        return this.nameToLibraryTypeMap.get(typeName);
    }

    public AnyType getOclAnyType() {
        if (this.oclAnyType == null) {
            Type type = this.getRequiredLibraryType("OclAny");
            if (type instanceof AnyType) {
                this.oclAnyType = (AnyType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("OclAny is not an AnyType");
            }
        }
        return this.oclAnyType;
    }

    public InvalidType getOclInvalidType() {
        if (this.oclInvalidType == null) {
            Type type = this.getRequiredLibraryType("OclInvalid");
            if (type instanceof InvalidType) {
                this.oclInvalidType = (InvalidType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("OclInvalid is not an InvalidType");
            }
        }
        return this.oclInvalidType;
    }

    public Type getOclMessageType() {
        return this.getRequiredLibraryType("OclMessage");
    }

    public VoidType getOclVoidType() {
        if (this.oclVoidType == null) {
            Type type = this.getRequiredLibraryType("OclVoid");
            if (type instanceof VoidType) {
                this.oclVoidType = (VoidType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("OclVoid is not a VoidType");
            }
        }
        return this.oclVoidType;
    }

    public OrderedSetType getOrderedSetType() {
        if (this.orderedSetType == null) {
            Type type = this.getRequiredLibraryType("OrderedSet");
            if (type instanceof OrderedSetType) {
                if (((OrderedSetType)type).getOwnedTemplateSignature() == null) {
                    throw new IllegalLibraryException("OrderedSet is not a templated type");
                }
                if (((OrderedSetType)type).getOwnedTemplateSignature().getParameters().size() != 1) {
                    throw new IllegalLibraryException("OrderedSet is not a templated type with a single argument");
                }
                this.orderedSetType = (OrderedSetType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("OrderedSet is not an OrderedSetType");
            }
        }
        return this.orderedSetType;
    }

    public PrimitiveType getRealType() {
        if (this.realType == null) {
            Type type = this.getRequiredLibraryType("Real");
            if (type instanceof PrimitiveType) {
                this.realType = (PrimitiveType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Real is not a PrimitiveType");
            }
        }
        return this.realType;
    }

    public Type getRequiredLibraryType(String typeName) {
        Type type = this.getLibraryType(typeName);
        if (type == null) {
            this.nameToLibraryTypeMap = null;
            type = this.getLibraryType(typeName);
            if (this.nameToLibraryTypeMap == null || this.nameToLibraryTypeMap.isEmpty()) {
                throw new IllegalLibraryException(OCLMessages.EmptyLibrary_ERROR_);
            }
            throw new IllegalLibraryException(NLS.bind((String)OCLMessages.MissingLibraryType_ERROR_, (Object)typeName));
        }
        return type;
    }

    public SequenceType getSequenceType() {
        if (this.sequenceType == null) {
            Type type = this.getRequiredLibraryType("Sequence");
            if (type instanceof SequenceType) {
                if (((SequenceType)type).getOwnedTemplateSignature() == null) {
                    throw new IllegalLibraryException("Sequence is not a templated type");
                }
                if (((SequenceType)type).getOwnedTemplateSignature().getParameters().size() != 1) {
                    throw new IllegalLibraryException("Sequence is not a templated type with a single argument");
                }
                this.sequenceType = (SequenceType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Sequence is not a SequenceType");
            }
        }
        return this.sequenceType;
    }

    public SetType getSetType() {
        if (this.setType == null) {
            Type type = this.getRequiredLibraryType("Set");
            if (type instanceof SetType) {
                if (((SetType)type).getOwnedTemplateSignature() == null) {
                    throw new IllegalLibraryException("Set is not a templated type");
                }
                if (((SetType)type).getOwnedTemplateSignature().getParameters().size() != 1) {
                    throw new IllegalLibraryException("Set is not a templated type with a single argument");
                }
                this.setType = (SetType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Set is not a SetType");
            }
        }
        return this.setType;
    }

    public PrimitiveType getStringType() {
        if (this.stringType == null) {
            Type type = this.getRequiredLibraryType("String");
            if (type instanceof PrimitiveType) {
                this.stringType = (PrimitiveType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("String is not a PrimitiveType");
            }
        }
        return this.stringType;
    }

    public TupleType getTupleType() {
        if (this.tupleType == null) {
            Type type = this.getRequiredLibraryType("Tuple");
            if (type instanceof TupleType) {
                this.tupleType = (TupleType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("Tuple is not a TupleType");
            }
        }
        return this.tupleType;
    }

    public PrimitiveType getUnlimitedNaturalType() {
        if (this.unlimitedNaturalType == null) {
            Type type = this.getRequiredLibraryType("UnlimitedNatural");
            if (type instanceof PrimitiveType) {
                this.unlimitedNaturalType = (PrimitiveType)type;
            } else if (type != null) {
                throw new IllegalLibraryException("UnlimitedNatural is not a PrimitiveType");
            }
        }
        return this.unlimitedNaturalType;
    }

    public boolean isOrdered(Type sourceType) {
        if (sourceType instanceof OrderedSetType) {
            return true;
        }
        return sourceType instanceof SequenceType;
    }

    public boolean isUnique(Type sourceType) {
        if (sourceType instanceof OrderedSetType) {
            return true;
        }
        return sourceType instanceof SetType;
    }

    protected abstract Resource loadDefaultLibrary(String var1);

    public void resetLibrary() {
        this.bagType = null;
        this.booleanType = null;
        this.classifierType = null;
        this.collectionType = null;
        this.enumerationType = null;
        this.integerType = null;
        this.oclAnyType = null;
        this.oclInvalidType = null;
        this.oclVoidType = null;
        this.orderedSetType = null;
        this.realType = null;
        this.sequenceType = null;
        this.setType = null;
        this.stringType = null;
        this.tupleType = null;
        this.unlimitedNaturalType = null;
        this.nameToLibraryTypeMap = null;
    }
}

