/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.values.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.ocl.examples.pivot.CollectionKind;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.values.NullValue;
import org.eclipse.ocl.examples.pivot.values.OrderedCollectionValue;
import org.eclipse.ocl.examples.pivot.values.SequenceValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.values.impl.AbstractCollectionValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSequenceValue<L extends List<Value>>
extends AbstractCollectionValue<L>
implements SequenceValue {
    public AbstractSequenceValue(ValueFactory valueFactory, L elements) {
        super(valueFactory, elements);
    }

    @Override
    public List<Value> asList() {
        return (List)this.elements;
    }

    @Override
    public OrderedCollectionValue asOrderedCollectionValue() {
        return this;
    }

    @Override
    public SequenceValue asSequenceValue() {
        return this;
    }

    @Override
    public SequenceValue append(Value object) throws InvalidValueException {
        if (object.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "append");
        }
        ArrayList<Value> result = new ArrayList<Value>(this.elements);
        result.add(object);
        return this.valueFactory.createSequenceValue((List<? extends Value>)result);
    }

    @Override
    public Value at(int index) throws InvalidValueException {
        if (--index < 0 || ((List)this.elements).size() <= index) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.IndexOutOfRange, index + 1, this.size());
        }
        return (Value)((List)this.elements).get(index);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NullValue) {
            return false;
        }
        if (obj instanceof SequenceValue) {
            SequenceValue that = (SequenceValue)obj;
            int i = 0;
            for (Value thisValue : this) {
                try {
                    Value thatValue = that.at(i++);
                    if (thisValue.equals(thatValue)) continue;
                    return false;
                }
                catch (InvalidValueException e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public SequenceValue excluding(Value value) {
        ArrayList<Value> result = new ArrayList<Value>();
        for (Value element : (List)this.elements) {
            if (element.equals(value)) continue;
            result.add(element);
        }
        if (result.size() < ((List)this.elements).size()) {
            return this.valueFactory.createSequenceValue((List<? extends Value>)result);
        }
        return this;
    }

    @Override
    public Value first() throws InvalidValueException {
        if (((List)this.elements).size() <= 0) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.EmptyCollection, "Sequence", "first");
        }
        return (Value)((List)this.elements).get(0);
    }

    @Override
    public SequenceValue flatten() throws InvalidValueException {
        ArrayList<Value> flattened = new ArrayList<Value>();
        if (this.flatten(flattened)) {
            return this.valueFactory.createSequenceValue((List<? extends Value>)flattened);
        }
        return this;
    }

    @Override
    public CollectionKind getKind() {
        return CollectionKind.SEQUENCE;
    }

    @Override
    public SequenceValue including(Value value) throws InvalidValueException {
        if (value.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "including");
        }
        ArrayList<Value> result = new ArrayList<Value>(this.elements);
        result.add(value);
        return this.valueFactory.createSequenceValue((List<? extends Value>)result);
    }

    @Override
    public IntegerValue indexOf(Value object) throws InvalidValueException {
        int index = ((List)this.elements).indexOf(object);
        if (index < 0) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.MissingValue, "indexOf");
        }
        return this.valueFactory.integerValueOf(index + 1);
    }

    @Override
    public SequenceValue insertAt(int index, Value object) throws InvalidValueException {
        if (object.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "insertAt");
        }
        if (--index < 0 || index > ((List)this.elements).size()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.IndexOutOfRange, index + 1, this.size());
        }
        ArrayList<Value> result = new ArrayList<Value>(this.elements);
        result.add(index, object);
        return this.valueFactory.createSequenceValue((List<? extends Value>)result);
    }

    @Override
    public Value last() throws InvalidValueException {
        int size = ((List)this.elements).size();
        if (size <= 0) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.EmptyCollection, "Sequence", "last");
        }
        return (Value)((List)this.elements).get(size - 1);
    }

    @Override
    public SequenceValue prepend(Value object) throws InvalidValueException {
        if (object.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "prepend");
        }
        ArrayList<Value> result = new ArrayList<Value>();
        result.add(object);
        result.addAll(this.elements);
        return this.valueFactory.createSequenceValue((List<? extends Value>)result);
    }

    @Override
    public SequenceValue reverse() {
        ArrayList elements = new ArrayList(this.elements);
        Collections.reverse(elements);
        return this.valueFactory.createSequenceValue(elements);
    }

    @Override
    public SequenceValue sort(Comparator<Value> comparator) {
        ArrayList values = new ArrayList(this.elements);
        Collections.sort(values, comparator);
        return this.valueFactory.createSequenceValue(values);
    }

    @Override
    public SequenceValue subSequence(int lower, int upper) {
        --upper;
        if (--lower < 0) {
            throw new IndexOutOfBoundsException("lower: " + (lower + 1));
        }
        if (upper >= ((List)this.elements).size()) {
            throw new IndexOutOfBoundsException("upper: " + (upper + 1) + ", size: " + this.size());
        }
        if (upper < lower) {
            throw new IllegalArgumentException("lower: " + (lower + 1) + ", upper: " + (upper + 1));
        }
        ArrayList<Value> result = new ArrayList<Value>();
        int curr = 0;
        for (Value object : this) {
            if (curr >= lower && curr <= upper) {
                result.add(object);
            }
            ++curr;
        }
        return this.valueFactory.createSequenceValue((List<? extends Value>)result);
    }

    @Override
    public OrderedCollectionValue toOrderedCollectionValue() {
        return this;
    }

    @Override
    public void toString(StringBuffer s, int lengthLimit) {
        s.append("Sequence");
        super.toString(s, lengthLimit);
    }
}

