/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.values.impl;

import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.values.BagValue;
import org.eclipse.ocl.examples.pivot.values.BooleanValue;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.ElementValue;
import org.eclipse.ocl.examples.pivot.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.values.ObjectValue;
import org.eclipse.ocl.examples.pivot.values.OrderedCollectionValue;
import org.eclipse.ocl.examples.pivot.values.OrderedSetValue;
import org.eclipse.ocl.examples.pivot.values.RealValue;
import org.eclipse.ocl.examples.pivot.values.SequenceValue;
import org.eclipse.ocl.examples.pivot.values.SetValue;
import org.eclipse.ocl.examples.pivot.values.StringValue;
import org.eclipse.ocl.examples.pivot.values.TypeValue;
import org.eclipse.ocl.examples.pivot.values.UniqueCollectionValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValue
implements Value {
    protected final ValueFactory valueFactory;

    protected AbstractValue(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    @Override
    public BagValue asBagValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Bag");
    }

    @Override
    public boolean asBoolean() throws InvalidValueException {
        this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Boolean");
        return false;
    }

    @Override
    public BooleanValue asBooleanValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Boolean");
    }

    @Override
    public CollectionValue asCollectionValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Collection");
    }

    @Override
    public Double asDouble() throws InvalidValueException {
        this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Double");
        return null;
    }

    @Override
    public Element asElement() {
        return null;
    }

    @Override
    public ElementValue<?> asElementValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Element");
    }

    @Override
    public Integer asInteger() throws InvalidValueException {
        this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Integer");
        return null;
    }

    @Override
    public IntegerValue asIntegerValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Integer");
    }

    @Override
    public ObjectValue asObjectValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Object");
    }

    @Override
    public OrderedCollectionValue asOrderedCollectionValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Ordered Collection");
    }

    @Override
    public OrderedSetValue asOrderedSetValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "OrderedSet");
    }

    @Override
    public RealValue asRealValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Real");
    }

    @Override
    public SequenceValue asSequenceValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Sequence");
    }

    @Override
    public SetValue asSetValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Set");
    }

    @Override
    public String asString() throws InvalidValueException {
        this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "String");
        return null;
    }

    @Override
    public StringValue asStringValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "String");
    }

    @Override
    public TypeValue asTypeValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Type");
    }

    @Override
    public UniqueCollectionValue asUniqueCollectionValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Unique Collection");
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    @Override
    public CollectionValue isCollectionValue() {
        return null;
    }

    @Override
    public boolean isFalse() {
        return false;
    }

    @Override
    public IntegerValue isIntegerValue() {
        return null;
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public RealValue isRealValue() {
        return null;
    }

    @Override
    public boolean isTrue() {
        return false;
    }

    @Override
    public boolean isUndefined() {
        return false;
    }

    @Override
    public boolean isUnlimited() {
        return false;
    }

    @Override
    public boolean isUnlimitedNatural() {
        return false;
    }

    @Override
    public String oclToString() {
        return this.toString();
    }

    @Override
    public IntegerValue toIntegerValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.ConvertibleValueRequired, "Integer");
    }

    @Override
    public RealValue toRealValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.ConvertibleValueRequired, "Real");
    }

    @Override
    public void toString(StringBuffer s, int sizeLimit) {
        s.append(this.toString());
    }
}

