/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.values.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ocl.examples.pivot.CollectionKind;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.values.OrderedCollectionValue;
import org.eclipse.ocl.examples.pivot.values.OrderedSet;
import org.eclipse.ocl.examples.pivot.values.OrderedSetValue;
import org.eclipse.ocl.examples.pivot.values.UniqueCollectionValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.values.impl.AbstractCollectionValue;
import org.eclipse.ocl.examples.pivot.values.impl.OrderedSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedSetValueImpl
extends AbstractCollectionValue<OrderedSet<Value>>
implements OrderedSetValue {
    public static OrderedSetValue union(ValueFactory valueFactory, CollectionValue left, CollectionValue right) throws InvalidValueException {
        assert (!left.isUndefined() && !right.isUndefined());
        Collection<Value> leftElements = left.asCollection();
        Collection<Value> rightElements = right.asCollection();
        if (leftElements.isEmpty()) {
            return right.asOrderedSetValue();
        }
        if (rightElements.isEmpty()) {
            return left.asOrderedSetValue();
        }
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>(leftElements);
        result.addAll(rightElements);
        return new OrderedSetValueImpl(valueFactory, (OrderedSet<Value>)result);
    }

    public OrderedSetValueImpl(ValueFactory valueFactory, Value ... elements) {
        super(valueFactory, new OrderedSetImpl());
        if (elements != null) {
            Value[] valueArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Value element = valueArray[n2];
                ((OrderedSet)this.elements).add(element);
                ++n2;
            }
        }
    }

    public OrderedSetValueImpl(ValueFactory valueFactory, Collection<? extends Value> elements) {
        super(valueFactory, new OrderedSetImpl<Value>(elements));
    }

    public OrderedSetValueImpl(ValueFactory valueFactory, OrderedSet<Value> elements) {
        super(valueFactory, elements);
    }

    @Override
    public OrderedSetValue append(Value object) throws InvalidValueException {
        if (object.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "append");
        }
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>(this.elements);
        result.remove(object);
        result.add(object);
        return new OrderedSetValueImpl(this.valueFactory, (OrderedSet<Value>)result);
    }

    @Override
    public OrderedCollectionValue asOrderedCollectionValue() {
        return this;
    }

    @Override
    public OrderedSetValueImpl asOrderedSetValue() {
        return this;
    }

    @Override
    public UniqueCollectionValue asUniqueCollectionValue() {
        return this;
    }

    @Override
    public Value at(int index) throws InvalidValueException {
        if (--index < 0 || index >= ((OrderedSet)this.elements).size()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.IndexOutOfRange, index + 1, this.size());
        }
        int curr = 0;
        for (Value object : this) {
            if (curr++ != index) continue;
            return object;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OrderedSetValueImpl)) {
            return false;
        }
        return ((OrderedSet)this.elements).equals(((OrderedSetValueImpl)obj).elements);
    }

    @Override
    public OrderedSetValue excluding(Value value) {
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>();
        for (Value element : (OrderedSet)this.elements) {
            if (element.equals(value)) continue;
            result.add(element);
        }
        if (result.size() < ((OrderedSet)this.elements).size()) {
            return new OrderedSetValueImpl(this.valueFactory, (OrderedSet<Value>)result);
        }
        return this;
    }

    @Override
    public Value first() throws InvalidValueException {
        if (this.elements == null || ((OrderedSet)this.elements).size() <= 0) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.EmptyCollection, "OrderedSet", "first");
        }
        return (Value)((OrderedSet)this.elements).iterator().next();
    }

    @Override
    public OrderedSetValue flatten() throws InvalidValueException {
        OrderedSetImpl<Value> flattened = new OrderedSetImpl<Value>();
        if (this.flatten(flattened)) {
            return new OrderedSetValueImpl(this.valueFactory, (OrderedSet<Value>)flattened);
        }
        return this;
    }

    @Override
    public CollectionKind getKind() {
        return CollectionKind.ORDERED_SET;
    }

    @Override
    public Type getType(TypeManager typeManager, Type staticType) {
        return staticType;
    }

    @Override
    public OrderedSetValue including(Value value) throws InvalidValueException {
        if (value.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "including");
        }
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>(this.elements);
        result.add(value);
        return new OrderedSetValueImpl(this.valueFactory, (OrderedSet<Value>)result);
    }

    @Override
    public IntegerValue indexOf(Value object) throws InvalidValueException {
        int index = 1;
        for (Value next : (OrderedSet)this.elements) {
            if (object.equals(next)) {
                return this.valueFactory.integerValueOf(index);
            }
            ++index;
        }
        this.valueFactory.throwInvalidValueException(EvaluatorMessages.MissingValue, "indexOf");
        return null;
    }

    @Override
    public OrderedSetValue insertAt(int index, Value object) throws InvalidValueException {
        if (object.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "insertAt");
        }
        boolean isContained = ((OrderedSet)this.elements).contains(object);
        int effectiveSize = ((OrderedSet)this.elements).size() - (isContained ? 1 : 0);
        if (--index < 0 || effectiveSize < index) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.IndexOutOfRange, index + 1, this.size());
        }
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>();
        int curr = 0;
        Iterator<Value> it = this.iterator();
        while (it.hasNext()) {
            Value next;
            if (curr == index) {
                result.add(object);
            }
            if ((next = it.next()).equals(object)) continue;
            result.add(next);
            ++curr;
        }
        if (index == effectiveSize) {
            result.add(object);
        }
        return new OrderedSetValueImpl(this.valueFactory, (OrderedSet<Value>)result);
    }

    @Override
    public Value last() throws InvalidValueException {
        if (this.elements == null || ((OrderedSet)this.elements).size() <= 0) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.EmptyCollection, "OrderedSet", "last");
        }
        Value result = null;
        Iterator iterator = ((OrderedSet)this.elements).iterator();
        while (iterator.hasNext()) {
            Value next;
            result = next = (Value)iterator.next();
        }
        return result;
    }

    @Override
    public OrderedSetValue minus(UniqueCollectionValue set) throws InvalidValueException {
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>(this.elements);
        result.removeAll(set.asCollection());
        return new OrderedSetValueImpl(this.valueFactory, (OrderedSet<Value>)result);
    }

    @Override
    public OrderedSetValue prepend(Value object) throws InvalidValueException {
        if (object.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "prepend");
        }
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>();
        result.add(object);
        result.addAll(this.elements);
        return new OrderedSetValueImpl(this.valueFactory, (OrderedSet<Value>)result);
    }

    @Override
    public OrderedSetValue reverse() {
        List<Value> elements = this.asList();
        Collections.reverse(elements);
        return new OrderedSetValueImpl(this.valueFactory, (Collection<? extends Value>)elements);
    }

    @Override
    public OrderedSetValue sort(Comparator<Value> comparator) {
        ArrayList values = new ArrayList(this.elements);
        Collections.sort(values, comparator);
        return new OrderedSetValueImpl(this.valueFactory, values);
    }

    @Override
    public OrderedSetValue subOrderedSet(int lower, int upper) {
        --upper;
        if (--lower < 0) {
            throw new IndexOutOfBoundsException("lower: " + (lower + 1));
        }
        if (upper >= ((OrderedSet)this.elements).size()) {
            throw new IndexOutOfBoundsException("upper: " + (upper + 1) + ", size: " + this.size());
        }
        if (upper < lower) {
            throw new IllegalArgumentException("lower: " + (lower + 1) + ", upper: " + (upper + 1));
        }
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>();
        int curr = 0;
        for (Value object : (OrderedSet)this.elements) {
            if (curr >= lower && curr <= upper) {
                result.add(object);
            }
            ++curr;
        }
        return new OrderedSetValueImpl(this.valueFactory, (OrderedSet<Value>)result);
    }

    @Override
    public OrderedSetValue symmetricDifference(UniqueCollectionValue set) {
        OrderedSetImpl<Value> result = new OrderedSetImpl<Value>(this.elements);
        for (Value e : set) {
            if (result.contains(e)) {
                result.remove(e);
                continue;
            }
            result.add(e);
        }
        return new OrderedSetValueImpl(this.valueFactory, (OrderedSet<Value>)result);
    }

    @Override
    public OrderedCollectionValue toOrderedCollectionValue() {
        return this;
    }

    @Override
    public void toString(StringBuffer s, int lengthLimit) {
        s.append("OrderedSet");
        super.toString(s, lengthLimit);
    }

    public static class Accumulator
    extends OrderedSetValueImpl
    implements CollectionValue.Accumulator {
        public Accumulator(ValueFactory valueFactory) {
            super(valueFactory, new Value[0]);
        }

        public boolean add(Value value) {
            return ((OrderedSet)this.elements).add(value);
        }
    }
}

