/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.values.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.SequenceValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.values.impl.AbstractSequenceValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceValueImpl
extends AbstractSequenceValue<List<Value>> {
    public static SequenceValue union(ValueFactory valueFactory, CollectionValue left, CollectionValue right) throws InvalidValueException {
        assert (!left.isUndefined() && !right.isUndefined());
        Collection<Value> leftElements = left.asCollection();
        Collection<Value> rightElements = right.asCollection();
        if (leftElements.isEmpty()) {
            return right.asSequenceValue();
        }
        if (rightElements.isEmpty()) {
            return left.asSequenceValue();
        }
        ArrayList<Value> result = new ArrayList<Value>(leftElements);
        result.addAll(rightElements);
        return new SequenceValueImpl(valueFactory, (List<Value>)result);
    }

    public SequenceValueImpl(ValueFactory valueFactory, Value ... elements) {
        super(valueFactory, new ArrayList());
        if (elements != null) {
            Value[] valueArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Value element = valueArray[n2];
                ((List)this.elements).add(element);
                ++n2;
            }
        }
    }

    public SequenceValueImpl(ValueFactory valueFactory, Collection<? extends Value> elements) {
        super(valueFactory, new ArrayList<Value>(elements));
    }

    public SequenceValueImpl(ValueFactory valueFactory, List<Value> elements) {
        super(valueFactory, elements);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SequenceValueImpl) {
            return ((List)this.elements).equals(((SequenceValueImpl)obj).elements);
        }
        return super.equals(obj);
    }

    @Override
    public Type getType(TypeManager typeManager, Type staticType) {
        return staticType;
    }

    public static class Accumulator
    extends SequenceValueImpl
    implements CollectionValue.Accumulator {
        public Accumulator(ValueFactory valueFactory) {
            super(valueFactory, new Value[0]);
        }

        public boolean add(Value value) {
            return ((List)this.elements).add(value);
        }
    }
}

