/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.values.impl;

import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.StringValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.values.impl.AbstractValue;

public class StringValueImpl
extends AbstractValue
implements StringValue {
    private final String value;

    public StringValueImpl(ValueFactory valueFactory, String value) {
        super(valueFactory);
        this.value = value;
    }

    public Object asObject() {
        return this.value;
    }

    public String asString() {
        return this.value;
    }

    public StringValue asStringValue() {
        return this;
    }

    public Value asValidValue() {
        return this;
    }

    public int compareTo(StringValue o) {
        return this.value.compareTo(o.stringValue());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StringValue)) {
            return false;
        }
        return this.value.equals(((StringValue)obj).stringValue());
    }

    public Type getType(TypeManager typeManager, Type staticType) {
        return typeManager.getStringType();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String stringValue() {
        return this.value;
    }

    public String toString() {
        return "'" + this.value + "'";
    }

    public void toString(StringBuffer s, int sizeLimit) {
        s.append("'");
        int length = this.value.length();
        int available = sizeLimit - (length + 1);
        if (length <= available) {
            s.append(this.value);
        } else {
            if (available > 0) {
                s.append(this.value.substring(0, available));
            }
            s.append("...");
        }
        s.append("'");
    }
}

