/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.cs2pivot;

import java.math.BigInteger;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.baseCST.SpecificationCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.BaseCS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeCSAdapter;
import org.eclipse.ocl.examples.xtext.base.util.BaseCSVisitor;
import org.eclipse.ocl.examples.xtext.essentialocl.cs2pivot.EssentialOCLLeft2RightVisitor;
import org.eclipse.ocl.examples.xtext.essentialocl.cs2pivot.EssentialOCLPostOrderVisitor;
import org.eclipse.ocl.examples.xtext.essentialocl.cs2pivot.EssentialOCLPreOrderVisitor;
import org.eclipse.ocl.examples.xtext.essentialocl.cs2pivot.EssentialOCLScopeVisitor;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.EssentialOCLCSTPackage;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InfixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NestedExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.OperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.PrefixExpCS;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLCS2Pivot
extends BaseCS2Pivot {
    public static CS2Pivot.Factory FACTORY = new Factory();

    public EssentialOCLCS2Pivot(Map<? extends Resource, ? extends Resource> cs2pivotResourceMap, TypeManager typeManager) {
        super(cs2pivotResourceMap, typeManager);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Factory
    implements CS2Pivot.Factory {
        private Factory() {
            BaseCS2Pivot.FACTORY.getClass();
            EssentialOCLCS2Pivot.addFactory((CS2Pivot.Factory)this);
            EssentialOCLCS2Pivot.addUnresolvedProxyMessageProvider((CS2Pivot.UnresolvedProxyMessageProvider)new NameExpCSUnresolvedProxyMessageProvider());
        }

        public EssentialOCLLeft2RightVisitor createLeft2RightVisitor(CS2PivotConversion converter) {
            return new EssentialOCLLeft2RightVisitor(converter);
        }

        public EssentialOCLPostOrderVisitor createPostOrderVisitor(CS2PivotConversion converter) {
            return new EssentialOCLPostOrderVisitor(converter);
        }

        public EssentialOCLPreOrderVisitor createPreOrderVisitor(CS2PivotConversion converter) {
            return new EssentialOCLPreOrderVisitor(converter);
        }

        public BaseCSVisitor<ScopeCSAdapter, TypeManager> createScopeVisitor(TypeManager typeManager) {
            return new EssentialOCLScopeVisitor(typeManager);
        }

        public EPackage getEPackage() {
            return EssentialOCLCSTPackage.eINSTANCE;
        }
    }

    private static final class NameExpCSUnresolvedProxyMessageProvider
    extends CS2Pivot.UnresolvedProxyMessageProvider {
        private NameExpCSUnresolvedProxyMessageProvider() {
            super(EssentialOCLCSTPackage.Literals.NAME_EXP_CS__ELEMENT);
        }

        public String getMessage(EObject context, String linkText) {
            Type sourceType;
            String messageTemplate;
            String argumentText = null;
            ExpCS navigationArgument = null;
            if (context.eContainer() instanceof NavigatingExpCS) {
                NavigatingExpCS eContainer = (NavigatingExpCS)context.eContainer();
                navigationArgument = eContainer;
                EList<NavigatingArgCS> arguments = eContainer.getArgument();
                if (arguments.size() <= 0) {
                    messageTemplate = OCLMessages.UnresolvedOperation_ERROR_;
                } else {
                    StringBuffer s = new StringBuffer();
                    for (NavigatingArgCS csArgument : arguments) {
                        TypedElement pivot = (TypedElement)PivotUtil.getPivot(TypedElement.class, (Pivotable)csArgument);
                        if (pivot != null && !pivot.eIsProxy()) {
                            Type type = pivot.getType();
                            if (pivot instanceof TypedMultiplicityElement) {
                                TypedMultiplicityElement typedMultiplicityElement = (TypedMultiplicityElement)pivot;
                                if (typedMultiplicityElement.isOrdered()) {
                                    if (typedMultiplicityElement.isUnique()) {
                                        s.append("OrderedSet<");
                                    } else {
                                        s.append("Sequence<");
                                    }
                                } else if (typedMultiplicityElement.isUnique()) {
                                    s.append("Set<");
                                } else {
                                    s.append("Bag<");
                                }
                                s.append(String.valueOf(type));
                                s.append(">");
                                BigInteger lower = typedMultiplicityElement.getLower();
                                BigInteger upper = typedMultiplicityElement.getUpper();
                                PivotUtil.appendMultiplicity((StringBuffer)s, (int)lower.intValue(), (int)upper.intValue());
                                continue;
                            }
                            s.append(String.valueOf(type));
                            continue;
                        }
                        s.append(csArgument.toString());
                    }
                    argumentText = s.toString();
                    messageTemplate = OCLMessages.UnresolvedOperationCall_ERROR_;
                }
            } else if (context instanceof ExpCS) {
                navigationArgument = (ExpCS)context;
                messageTemplate = OCLMessages.UnresolvedProperty_ERROR_;
            } else {
                messageTemplate = "Unknown unresolved context";
            }
            TypedElement source = null;
            ExpCS csSource = navigationArgument;
            while (csSource != null) {
                OperatorCS csOperator = csSource.getParent();
                if (csOperator != null && csOperator.getSource() != csSource) {
                    csSource = csOperator.getSource();
                    break;
                }
                EObject eContainer = csSource.eContainer();
                if (eContainer instanceof NavigatingArgCS) {
                    csSource = ((NavigatingArgCS)eContainer).getNavigatingExp();
                    continue;
                }
                if (eContainer instanceof InfixExpCS) {
                    csSource = (InfixExpCS)eContainer;
                    continue;
                }
                if (eContainer instanceof PrefixExpCS) {
                    csSource = (PrefixExpCS)eContainer;
                    continue;
                }
                if (eContainer instanceof NestedExpCS) {
                    csSource = (NestedExpCS)eContainer;
                    continue;
                }
                if (!(eContainer instanceof SpecificationCS)) break;
                ExpressionInOcl expression = (ExpressionInOcl)PivotUtil.getPivot(ExpressionInOcl.class, (Pivotable)((SpecificationCS)eContainer));
                source = expression != null ? expression.getContextVariable() : null;
                break;
            }
            if (source == null && csSource != null && csSource != navigationArgument) {
                source = (TypedElement)PivotUtil.getPivot(OclExpression.class, (Pivotable)csSource);
            }
            String typeText = "unknown-type";
            if (source != null && (sourceType = source.getType()) != null) {
                typeText = sourceType.toString();
            }
            if (argumentText == null) {
                return NLS.bind((String)messageTemplate, (Object)linkText, (Object)typeText);
            }
            return NLS.bind((String)messageTemplate, (Object[])new Object[]{linkText, typeText, argumentText});
        }
    }
}

