/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.cs2pivot;

import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.impl.TypedTypeRefCSImpl;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.BasePreOrderVisitor;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.BasicContinuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Dependency;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.SingleContinuation;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionTypeCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ContextCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.OperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.TypeNameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.VariableCS;
import org.eclipse.ocl.examples.xtext.essentialocl.util.AbstractExtendingDelegatingEssentialOCLCSVisitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLPreOrderVisitor
extends AbstractExtendingDelegatingEssentialOCLCSVisitor<Continuation<?>, CS2PivotConversion, BasePreOrderVisitor> {
    public EssentialOCLPreOrderVisitor(CS2PivotConversion context) {
        super(new BasePreOrderVisitor(context), context);
    }

    @Override
    public Continuation<?> visitCollectionTypeCS(CollectionTypeCS csCollectionType) {
        return new CollectionTypeContinuation((CS2PivotConversion)this.context, csCollectionType);
    }

    @Override
    public Continuation<?> visitContextCS(ContextCS csContext) {
        return null;
    }

    @Override
    public Continuation<?> visitExpCS(ExpCS csExp) {
        return null;
    }

    @Override
    public Continuation<?> visitNameExpCS(NameExpCS csNameExp) {
        if (csNameExp.getNamespace().isEmpty()) {
            return null;
        }
        return new NameExpContinuation((CS2PivotConversion)this.context, csNameExp);
    }

    @Override
    public Continuation<?> visitNavigatingArgCS(NavigatingArgCS csNavigatingArg) {
        return null;
    }

    @Override
    public Continuation<?> visitOperatorCS(OperatorCS object) {
        return null;
    }

    @Override
    public Continuation<?> visitTypeNameExpCS(TypeNameExpCS csTypeNameExp) {
        return new TypeNameExpContinuation((CS2PivotConversion)this.context, csTypeNameExp);
    }

    @Override
    public Continuation<?> visitVariableCS(VariableCS csVariable) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CollectionTypeContinuation
    extends SingleContinuation<CollectionTypeCS> {
        public CollectionTypeContinuation(CS2PivotConversion context, CollectionTypeCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[]{context.getPackagesHaveTypesInterDependency()});
        }

        public boolean canExecute() {
            Type unspecializedPivotElement;
            if (!super.canExecute()) {
                return false;
            }
            TypedRefCS csTypedRef = ((CollectionTypeCS)this.csElement).getOwnedType();
            if (csTypedRef == null) {
                return true;
            }
            if (csTypedRef instanceof TypedTypeRefCSImpl && (unspecializedPivotElement = ((TypedTypeRefCSImpl)csTypedRef).basicGetType()) == null) {
                return false;
            }
            return csTypedRef.getPivot() != null;
        }

        public BasicContinuation<?> execute() {
            Type type;
            TypeManager typeManager = this.context.getTypeManager();
            TypedRefCS csElementType = ((CollectionTypeCS)this.csElement).getOwnedType();
            if (csElementType != null) {
                Type elementType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csElementType);
                type = typeManager.getLibraryType(((CollectionTypeCS)this.csElement).getName(), Collections.singletonList(elementType));
            } else {
                type = typeManager.getLibraryType(((CollectionTypeCS)this.csElement).getName());
            }
            this.context.reusePivotElement((ModelElementCS)this.csElement, (Element)type);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NameExpContinuation
    extends SingleContinuation<NameExpCS> {
        public NameExpContinuation(CS2PivotConversion context, NameExpCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[]{context.getPackagesHaveTypesInterDependency()});
        }

        public BasicContinuation<?> execute() {
            this.context.resolveNamespaces(((NameExpCS)this.csElement).getNamespace());
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TypeNameExpContinuation
    extends SingleContinuation<TypeNameExpCS> {
        public TypeNameExpContinuation(CS2PivotConversion context, TypeNameExpCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[]{context.getPackagesHaveTypesInterDependency()});
        }

        public BasicContinuation<?> execute() {
            this.context.resolveNamespaces(((TypeNameExpCS)this.csElement).getNamespace());
            Type element = ((TypeNameExpCS)this.csElement).getElement();
            if (element == null || element.eIsProxy()) {
                String boundMessage = NLS.bind((String)OCLMessages.UnresolvedType_ERROR_, (Object)((TypeNameExpCS)this.csElement).toString());
                this.context.addDiagnostic((ModelElementCS)this.csElement, boundMessage);
                element = this.context.getTypeManager().getOclInvalidType();
            }
            this.context.installPivotElement((ModelElementCS)this.csElement, (Element)element);
            return null;
        }
    }
}

