/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.scoping;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.scope.EnvironmentView;
import org.eclipse.ocl.examples.xtext.essentialocl.scoping.AbstractOperationFilter;

public class BinaryOperationFilter
extends AbstractOperationFilter {
    protected final Type argumentType;

    public BinaryOperationFilter(TypeManager typeManager, Type sourceType, Type argumentType) {
        super(typeManager, sourceType);
        this.argumentType = PivotUtil.getBehavioralType((Type)argumentType);
    }

    public boolean matches(EnvironmentView environmentView, Type forType, EObject eObject) {
        if (eObject instanceof Iteration) {
            return false;
        }
        if (eObject instanceof Operation) {
            Operation candidateOperation = (Operation)eObject;
            EList candidateParameters = candidateOperation.getOwnedParameters();
            if (candidateParameters.size() != 1) {
                return false;
            }
            Parameter candidateParameter = (Parameter)candidateParameters.get(0);
            Type candidateType = candidateParameter.getType();
            if (!this.typeManager.conformsTo(this.argumentType, candidateType, null)) {
                return false;
            }
            Map<TemplateParameter, ParameterableElement> bindings = this.getOperationBindings(candidateOperation);
            if (bindings != null) {
                this.installBindings(environmentView, forType, eObject, bindings);
            }
            return true;
        }
        return false;
    }
}

