/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.scoping;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.scope.EnvironmentView;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigationRole;
import org.eclipse.ocl.examples.xtext.essentialocl.scoping.AbstractOperationFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationFilter
extends AbstractOperationFilter {
    private final List<NavigatingArgCS> csArguments;
    private final int iterators;
    private final int accumulators;
    private final int expressions;

    public OperationFilter(TypeManager typeManager, Type sourceType, NavigatingExpCS csNavigatingExp) {
        super(typeManager, sourceType);
        int accumulators = 0;
        int iterators = 0;
        int expressions = 0;
        this.csArguments = csNavigatingExp.getArgument();
        for (NavigatingArgCS csNavigatingArg : this.csArguments) {
            if (csNavigatingArg.getRole() == NavigationRole.ITERATOR) {
                ++iterators;
                continue;
            }
            if (csNavigatingArg.getRole() == NavigationRole.ACCUMULATOR) {
                ++accumulators;
                continue;
            }
            if (csNavigatingArg.getRole() != NavigationRole.EXPRESSION) continue;
            ++expressions;
        }
        this.iterators = iterators;
        this.accumulators = accumulators;
        this.expressions = expressions;
    }

    protected OclExpression getExpressionArgument(int index) {
        int expIndex = 0;
        for (NavigatingArgCS csNavigatingArg : this.csArguments) {
            if (csNavigatingArg.getRole() != NavigationRole.EXPRESSION) continue;
            if (expIndex == index) {
                return (OclExpression)PivotUtil.getPivot(OclExpression.class, (Pivotable)csNavigatingArg);
            }
            ++expIndex;
        }
        return null;
    }

    protected Map<TemplateParameter, ParameterableElement> getIterationBindings(Iteration candidateIteration) {
        Type sourceType = this.sourceType;
        if (!(sourceType instanceof CollectionType) && candidateIteration.getClass_() instanceof CollectionType) {
            sourceType = this.typeManager.getCollectionType("Set", sourceType);
        }
        if (!(sourceType instanceof CollectionType)) {
            return null;
        }
        HashMap<TemplateParameter, ParameterableElement> bindings = new HashMap<TemplateParameter, ParameterableElement>();
        bindings.put((TemplateParameter)candidateIteration.getClass_().getOwnedTemplateSignature().getOwnedParameters().get(0), (ParameterableElement)((CollectionType)sourceType).getElementType());
        PivotUtil.getAllTemplateParameterSubstitutions(bindings, (TemplateableElement)sourceType);
        TemplateSignature templateSignature = candidateIteration.getOwnedTemplateSignature();
        if (templateSignature != null) {
            EList templateParameters = templateSignature.getOwnedParameters();
            int accIndex = 0;
            for (NavigatingArgCS csArgument : this.csArguments) {
                if (csArgument.getRole() != NavigationRole.ACCUMULATOR) continue;
                if (accIndex < templateParameters.size()) {
                    Variable argument = (Variable)PivotUtil.getPivot(Variable.class, (Pivotable)csArgument);
                    Type argumentType = argument.getType();
                    TemplateParameter accParameter = (TemplateParameter)templateParameters.get(accIndex);
                    bindings.put(accParameter, (ParameterableElement)argumentType);
                }
                ++accIndex;
            }
        }
        return bindings;
    }

    @Override
    protected Map<TemplateParameter, ParameterableElement> getOperationBindings(Operation candidateOperation) {
        Type sourceType = this.sourceType;
        HashMap<TemplateParameter, Type> bindings = null;
        Class containingType = candidateOperation.getClass_();
        if (containingType instanceof CollectionType) {
            if (!(sourceType instanceof CollectionType)) {
                sourceType = this.typeManager.getCollectionType("Set", sourceType);
            }
            Object elementType = sourceType instanceof CollectionType ? ((CollectionType)sourceType).getElementType() : this.typeManager.getOclInvalidType();
            bindings = new HashMap<TemplateParameter, Type>();
            bindings.put((TemplateParameter)containingType.getOwnedTemplateSignature().getOwnedParameters().get(0), (Type)elementType);
        }
        bindings = PivotUtil.getAllTemplateParameterSubstitutions(bindings, (TemplateableElement)sourceType);
        TemplateSignature templateSignature = candidateOperation.getOwnedTemplateSignature();
        if (templateSignature != null) {
            for (TemplateParameter templateParameter : templateSignature.getOwnedParameters()) {
                if (bindings == null) {
                    bindings = new HashMap();
                }
                bindings.put(templateParameter, null);
            }
        }
        return bindings;
    }

    @Override
    protected void installBindings(EnvironmentView environmentView, Type forType, EObject eObject, Map<TemplateParameter, ParameterableElement> bindings) {
        this.installOclSelfBinding(forType, eObject, bindings);
        EList parameters = ((Operation)eObject).getOwnedParameters();
        int iMax = parameters.size();
        if (iMax > 0) {
            int i = 0;
            while (i < iMax) {
                Type parameterType;
                Parameter parameter = (Parameter)parameters.get(i);
                OclExpression argument = this.getExpressionArgument(i);
                if (argument != null && (parameterType = parameter.getType()) instanceof LambdaType) {
                    PivotUtil.getAllTemplateParameterSubstitutions(bindings, (Type)argument.getType(), (LambdaType)((LambdaType)parameterType));
                }
                ++i;
            }
        }
        super.installBindings(environmentView, forType, eObject, bindings);
    }

    public boolean matches(EnvironmentView environmentView, Type forType, EObject eObject) {
        if (eObject instanceof Iteration) {
            Iteration candidateIteration = (Iteration)eObject;
            int iteratorCount = candidateIteration.getOwnedIterators().size();
            if (this.iterators > 0 && iteratorCount != this.iterators) {
                return false;
            }
            int accumulatorCount = candidateIteration.getOwnedAccumulators().size();
            if (accumulatorCount != this.accumulators) {
                return false;
            }
            Map<TemplateParameter, ParameterableElement> bindings = this.getIterationBindings(candidateIteration);
            if (bindings != null) {
                this.installBindings(environmentView, forType, eObject, bindings);
            }
            return true;
        }
        if (eObject instanceof Operation) {
            if (this.iterators > 0) {
                return false;
            }
            if (this.accumulators > 0) {
                return false;
            }
            Operation candidateOperation = (Operation)eObject;
            EList candidateParameters = candidateOperation.getOwnedParameters();
            if (this.expressions != candidateParameters.size()) {
                return false;
            }
            Map<TemplateParameter, ParameterableElement> bindings = this.getOperationBindings(candidateOperation);
            int i = 0;
            while (i < this.expressions) {
                Parameter candidateParameter = (Parameter)candidateParameters.get(i);
                NavigatingArgCS csExpression = this.csArguments.get(i);
                OclExpression expression = (OclExpression)PivotUtil.getPivot(OclExpression.class, (Pivotable)csExpression);
                if (expression == null) {
                    return false;
                }
                Type candidateType = this.typeManager.getTypeWithMultiplicity((TypedMultiplicityElement)candidateParameter);
                Type expressionType = expression.getType();
                if (!this.typeManager.conformsTo(expressionType = PivotUtil.getBehavioralType((Type)expressionType), candidateType, bindings)) {
                    return false;
                }
                ++i;
            }
            if (bindings != null) {
                this.installBindings(environmentView, forType, eObject, bindings);
            }
            return true;
        }
        return false;
    }
}

