/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.util.Bag;
import org.eclipse.ocl.util.BagImpl;
import org.eclipse.ocl.util.ObjectUtil;
import org.eclipse.ocl.util.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtil {
    private CollectionUtil() {
    }

    public static boolean includes(Collection<?> self, Object object) {
        return self.contains(object);
    }

    public static boolean excludes(Collection<?> self, Object object) {
        return !CollectionUtil.includes(self, object);
    }

    public static int count(Collection<?> self, Object object) {
        int count = 0;
        for (Object next : self) {
            if (!ObjectUtil.equal(next, object)) continue;
            ++count;
        }
        return count;
    }

    public static boolean includesAll(Collection<?> self, Collection<?> c) {
        for (Object next : c) {
            if (CollectionUtil.includes(self, next)) continue;
            return false;
        }
        return true;
    }

    public static boolean excludesAll(Collection<?> self, Collection<?> c) {
        for (Object next : c) {
            if (!CollectionUtil.includes(self, next)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Collection<?> self) {
        return self.isEmpty();
    }

    public static boolean notEmpty(Collection<?> self) {
        return !self.isEmpty();
    }

    public static Object sum(Collection<?> self) {
        if (self.isEmpty()) {
            return null;
        }
        Iterator<?> it = self.iterator();
        Object object = it.next();
        if (object instanceof Integer) {
            int currVal = 0;
            it = self.iterator();
            while (it.hasNext()) {
                currVal += ((Integer)it.next()).intValue();
            }
            return new Integer(currVal);
        }
        if (object instanceof Double) {
            double currVal = 0.0;
            it = self.iterator();
            while (it.hasNext()) {
                currVal += ((Double)it.next()).doubleValue();
            }
            return new Double(currVal);
        }
        IllegalArgumentException error = new IllegalArgumentException(OCLMessages.SumOperator_ERROR_);
        OCLPlugin.throwing(CollectionUtil.class, "sum", error);
        throw error;
    }

    public static boolean equals(Collection<?> self, Collection<?> c) {
        if (self.size() != c.size()) {
            return false;
        }
        if (self instanceof Bag && c instanceof Bag) {
            return ((Bag)self).equals(c);
        }
        if (self instanceof List && c instanceof List) {
            return ((List)self).equals(c);
        }
        if (self instanceof LinkedHashSet && c instanceof LinkedHashSet) {
            int size2;
            int size1 = self.size();
            if (size1 != (size2 = c.size())) {
                return false;
            }
            Iterator<?> it1 = self.iterator();
            Iterator<?> it2 = c.iterator();
            while (it1.hasNext()) {
                Object o2;
                Object o1 = it1.next();
                if (o1.equals(o2 = it2.next())) continue;
                return false;
            }
            return true;
        }
        if (self instanceof Set && c instanceof Set) {
            return ((Set)self).equals(c);
        }
        return false;
    }

    public static int hashCode(Collection<?> c) {
        int result = 1;
        for (Object next : c) {
            result = 37 * result + ObjectUtil.hashCode(next);
        }
        return result;
    }

    public static <E> Collection<E> intersection(Collection<? extends E> self, Collection<? extends E> c) {
        int size1 = self.size();
        int size2 = c.size();
        if (size1 == 0 || size2 == 0) {
            if (self instanceof Set || c instanceof Set) {
                return Collections.emptySet();
            }
            return BagImpl.emptyBag();
        }
        Collection<E> result = null;
        if (self instanceof Set || c instanceof Set) {
            if (size1 == 0 || size2 == 0) {
                return Collections.emptySet();
            }
            result = CollectionUtil.createNewSet();
        } else {
            if (size1 == 0 || size2 == 0) {
                return BagImpl.emptyBag();
            }
            result = CollectionUtil.createNewBag();
        }
        if (self.size() > c.size()) {
            for (E e : c) {
                if (!CollectionUtil.includes(self, e)) continue;
                result.add(e);
            }
        } else {
            for (E e : self) {
                if (!CollectionUtil.includes(c, e)) continue;
                result.add(e);
            }
        }
        return result;
    }

    public static <E> Collection<E> union(Collection<? extends E> self, Collection<? extends E> c) {
        if (self.isEmpty()) {
            if (self instanceof Bag || c instanceof Bag) {
                return CollectionUtil.createNewBag(c);
            }
            return CollectionUtil.createNewCollection(c);
        }
        if (c.isEmpty()) {
            if (self instanceof Bag || c instanceof Bag) {
                return CollectionUtil.createNewBag(self);
            }
            return CollectionUtil.createNewCollection(self);
        }
        Collection<Object> result = null;
        result = self instanceof Bag || c instanceof Bag ? CollectionUtil.createNewBag(self) : (self instanceof List || c instanceof List ? CollectionUtil.createNewSequence(self) : CollectionUtil.createNewSet(self));
        result.addAll(c);
        return result;
    }

    public static Collection<?> flatten(Collection<?> self) {
        Iterator<?> it;
        Object object;
        Collection<?> result = self;
        while (!result.isEmpty() && (object = (it = result.iterator()).next()) instanceof Collection) {
            Collection newResult = null;
            newResult = result instanceof Bag ? CollectionUtil.createNewBag() : (result instanceof Set ? CollectionUtil.createNewSet() : CollectionUtil.createNewSequence());
            newResult.addAll((Collection)object);
            while (it.hasNext()) {
                newResult.addAll((Collection)it.next());
            }
            result = newResult;
        }
        return result;
    }

    public static <C> C getFlattenedElementType(CollectionType<C, ?> type) {
        C result = type.getElementType();
        while (result instanceof CollectionType) {
            result = ((CollectionType)result).getElementType();
        }
        return result;
    }

    public static <E> Set<E> minus(Set<? extends E> self, Set<? extends E> set) {
        Set<E> result = CollectionUtil.createNewSet(self);
        result.removeAll(set);
        return result;
    }

    public static <E> Collection<E> excluding(Collection<E> self, Object object) {
        Collection<E> result = null;
        if (self instanceof LinkedHashSet) {
            result = CollectionUtil.createNewOrderedSet(self);
        } else if (self instanceof Set) {
            result = CollectionUtil.createNewSet(self);
        } else if (self instanceof Bag) {
            result = CollectionUtil.createNewBag(self);
        } else {
            if (self instanceof List) {
                List<E> resultSeq = CollectionUtil.createNewSequence(self);
                while (resultSeq.remove(object)) {
                }
                return resultSeq;
            }
            throw new RuntimeException("Unsupported collection type " + self.getClass().getName());
        }
        result.remove(object);
        return result;
    }

    public static <E> Set<E> symmetricDifference(Set<? extends E> self, Set<? extends E> set) {
        Set<E> result = CollectionUtil.createNewSet(self);
        for (E e : set) {
            if (result.contains(e)) {
                result.remove(e);
                continue;
            }
            result.add(e);
        }
        return result;
    }

    public static <E> Collection<E> including(Collection<E> self, E object) {
        Collection<E> result = self instanceof LinkedHashSet ? CollectionUtil.createNewOrderedSet(self) : (self instanceof Set ? CollectionUtil.createNewSet(self) : (self instanceof Bag ? CollectionUtil.createNewBag(self) : CollectionUtil.createNewSequence(self)));
        result.add(object);
        return result;
    }

    public static <E> Set<E> asSet(Collection<E> self) {
        if (self instanceof Set && !(self instanceof LinkedHashSet)) {
            return (Set)self;
        }
        return CollectionUtil.createNewSet(self);
    }

    public static <E> Bag<E> asBag(Collection<E> self) {
        if (self instanceof Bag) {
            return (Bag)self;
        }
        return CollectionUtil.createNewBag(self);
    }

    public static <E> List<E> asSequence(Collection<E> self) {
        if (self instanceof List) {
            return (List)self;
        }
        return CollectionUtil.createNewSequence(self);
    }

    public static <E> LinkedHashSet<E> asOrderedSet(Collection<E> self) {
        if (self instanceof LinkedHashSet) {
            return (LinkedHashSet)self;
        }
        return CollectionUtil.createNewOrderedSet(self);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> Set<Tuple<O, P>> product(EvaluationEnvironment<C, O, P, CLS, E> evalEnv, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, Collection<?> self, Collection<?> c, C tupleType) {
        Set<Tuple<O, P>> result = CollectionUtil.createNewSet();
        HashMap propertyValues = new HashMap();
        P firstProperty = env.lookupProperty(tupleType, "first");
        P secondProperty = env.lookupProperty(tupleType, "second");
        for (Object next1 : self) {
            for (Object next2 : c) {
                propertyValues.put(firstProperty, next1);
                propertyValues.put(secondProperty, next2);
                result.add(evalEnv.createTuple(tupleType, propertyValues));
            }
        }
        return result;
    }

    public static <E> Collection<E> append(Collection<E> self, E object) {
        SequencedCollection<E> result;
        if (self instanceof LinkedHashSet) {
            result = CollectionUtil.createNewOrderedSet(self);
            result.remove(object);
        } else {
            result = CollectionUtil.createNewSequence(self);
        }
        result.add(object);
        return result;
    }

    public static <E> Collection<E> prepend(Collection<E> self, E object) {
        SequencedCollection<E> result = self instanceof LinkedHashSet ? CollectionUtil.createNewOrderedSet() : CollectionUtil.createNewSequence();
        result.add(object);
        result.addAll(self);
        return result;
    }

    public static <E> Collection<E> insertAt(Collection<E> self, int index, E object) {
        if (--index < 0 || index > self.size()) {
            throw new IndexOutOfBoundsException("index: " + (index + 1) + ", size: " + self.size());
        }
        SequencedCollection<E> result = self instanceof LinkedHashSet ? CollectionUtil.createNewOrderedSet() : CollectionUtil.createNewSequence();
        int curr = 0;
        Iterator<E> it = self.iterator();
        while (it.hasNext()) {
            if (curr == index) {
                result.add(object);
            }
            result.add(it.next());
            ++curr;
        }
        if (index == self.size()) {
            result.add(object);
        }
        return result;
    }

    public static <E> Collection<E> subOrderedSet(Collection<E> self, int lower, int upper) {
        --upper;
        if (--lower < 0) {
            throw new IndexOutOfBoundsException("lower: " + (lower + 1));
        }
        if (upper >= self.size()) {
            throw new IndexOutOfBoundsException("upper: " + (upper + 1) + ", size: " + self.size());
        }
        if (upper < lower) {
            throw new IllegalArgumentException("lower: " + (lower + 1) + ", upper: " + (upper + 1));
        }
        SequencedCollection<E> result = self instanceof LinkedHashSet ? CollectionUtil.createNewOrderedSet() : CollectionUtil.createNewSequence();
        int curr = 0;
        for (E object : self) {
            if (curr >= lower && curr <= upper) {
                result.add(object);
            }
            ++curr;
        }
        return result;
    }

    public static <E> Collection<E> subSequence(Collection<E> self, int lower, int upper) {
        --upper;
        if (--lower < 0) {
            throw new IndexOutOfBoundsException("lower: " + (lower + 1));
        }
        if (upper >= self.size()) {
            throw new IndexOutOfBoundsException("upper: " + (upper + 1) + ", size: " + self.size());
        }
        if (upper < lower) {
            throw new IllegalArgumentException("lower: " + (lower + 1) + ", upper: " + (upper + 1));
        }
        List<E> result = CollectionUtil.createNewSequence();
        int curr = 0;
        for (E object : self) {
            if (curr >= lower && curr <= upper) {
                result.add(object);
            }
            ++curr;
        }
        return result;
    }

    public static <E> E at(Collection<E> self, int index) {
        if (--index < 0 || index >= self.size()) {
            throw new IndexOutOfBoundsException("index: " + (index + 1) + ", size: " + self.size());
        }
        int curr = 0;
        for (E object : self) {
            if (curr++ != index) continue;
            return object;
        }
        return null;
    }

    public static <E> E first(Collection<E> self) {
        if (self.isEmpty()) {
            return null;
        }
        return self.iterator().next();
    }

    public static <E> E last(Collection<E> self) {
        if (self.isEmpty()) {
            return null;
        }
        E result = null;
        for (E next : self) {
            result = next;
        }
        return result;
    }

    public static <E> Integer indexOf(Collection<? extends E> self, E object) {
        int index = 1;
        for (E next : self) {
            if (ObjectUtil.equal(object, next)) {
                return index;
            }
            ++index;
        }
        return null;
    }

    public static <E> Set<E> createNewSet() {
        return (Set)CollectionUtil.createNewCollection(CollectionKind.SET_LITERAL);
    }

    public static <E> Set<E> createNewSet(Collection<? extends E> c) {
        return (Set)CollectionUtil.createNewCollection(CollectionKind.SET_LITERAL, c);
    }

    public static <E> Bag<E> createNewBag() {
        return (Bag)CollectionUtil.createNewCollection(CollectionKind.BAG_LITERAL);
    }

    public static <E> Bag<E> createNewBag(Collection<? extends E> c) {
        return (Bag)CollectionUtil.createNewCollection(CollectionKind.BAG_LITERAL, c);
    }

    public static <E> LinkedHashSet<E> createNewOrderedSet() {
        return (LinkedHashSet)CollectionUtil.createNewCollection(CollectionKind.ORDERED_SET_LITERAL);
    }

    public static <E> LinkedHashSet<E> createNewOrderedSet(Collection<? extends E> c) {
        return (LinkedHashSet)CollectionUtil.createNewCollection(CollectionKind.ORDERED_SET_LITERAL, c);
    }

    public static <E> List<E> createNewSequence() {
        return (List)CollectionUtil.createNewCollection(CollectionKind.SEQUENCE_LITERAL);
    }

    public static <E> List<E> createNewSequence(Collection<? extends E> c) {
        return (List)CollectionUtil.createNewCollection(CollectionKind.SEQUENCE_LITERAL, c);
    }

    public static <E> Collection<E> createNewCollectionOfSameKind(Collection<?> c) {
        Collection<E> result = c instanceof Bag ? CollectionUtil.createNewBag() : (c instanceof LinkedHashSet ? CollectionUtil.createNewOrderedSet() : (c instanceof Set ? CollectionUtil.createNewSet() : CollectionUtil.createNewSequence()));
        return result;
    }

    public static <E> Collection<E> createNewCollection(Collection<? extends E> c) {
        Collection<? extends E> result = c instanceof Bag ? CollectionUtil.createNewBag(c) : (c instanceof LinkedHashSet ? CollectionUtil.createNewOrderedSet(c) : (c instanceof Set ? CollectionUtil.createNewSet(c) : CollectionUtil.createNewSequence(c)));
        return result;
    }

    public static <E> Collection<E> createNewCollection(CollectionKind kind) {
        switch (kind) {
            case SET_LITERAL: {
                return new HashSet();
            }
            case SEQUENCE_LITERAL: {
                return new ArrayList();
            }
            case ORDERED_SET_LITERAL: {
                return new LinkedHashSet();
            }
            case BAG_LITERAL: {
                return new BagImpl();
            }
        }
        String message = OCLMessages.bind(OCLMessages.OCLCollectionKindNotImpl_ERROR_, (Object)kind);
        IllegalArgumentException error = new IllegalArgumentException(message);
        OCLPlugin.throwing(CollectionUtil.class, "createNewCollection", error);
        throw error;
    }

    public static <E> Collection<E> createNewCollection(CollectionKind kind, Collection<E> c) {
        switch (kind) {
            case SET_LITERAL: {
                return new HashSet<E>(c);
            }
            case SEQUENCE_LITERAL: {
                return new ArrayList<E>(c);
            }
            case BAG_LITERAL: {
                return new BagImpl<E>(c);
            }
            case ORDERED_SET_LITERAL: {
                return new LinkedHashSet<E>(c);
            }
        }
        String message = OCLMessages.bind(OCLMessages.OCLCollectionKindNotImpl_ERROR_, (Object)kind);
        IllegalArgumentException error = new IllegalArgumentException(message);
        OCLPlugin.throwing(CollectionUtil.class, "createNewCollection", error);
        throw error;
    }

    private static CollectionKind kindOf(Collection<?> c) {
        CollectionKind result = c instanceof List ? CollectionKind.SEQUENCE_LITERAL : (c instanceof LinkedHashSet ? CollectionKind.ORDERED_SET_LITERAL : (c instanceof Set ? CollectionKind.SET_LITERAL : (c instanceof Bag ? CollectionKind.BAG_LITERAL : CollectionKind.COLLECTION_LITERAL)));
        return result;
    }

    public static String toString(Collection<?> c) {
        StringBuilder result = new StringBuilder();
        result.append(CollectionUtil.kindOf(c).getName());
        result.append('{');
        boolean notFirst = false;
        Iterator<?> iter = c.iterator();
        while (iter.hasNext()) {
            if (notFirst) {
                result.append(", ");
            } else {
                notFirst = true;
            }
            Object next = iter.next();
            if (next instanceof Collection) {
                result.append(CollectionUtil.toString((Collection)next));
                continue;
            }
            if (next instanceof String) {
                result.append('\'').append(next).append('\'');
                continue;
            }
            result.append(next);
        }
        result.append('}');
        return result.toString();
    }
}

