/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.cs2pivot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagedAdapter;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerListener;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.scoping.ScopeFilter;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.RootCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.ExceptionAdapter;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.Pivot2CS;
import org.eclipse.ocl.examples.xtext.base.util.BaseCSVisitor;
import org.eclipse.ocl.examples.xtext.base.utilities.CSI2PivotMapping;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CS2Pivot
extends AbstractConversion
implements MetaModelManagedAdapter {
    private static Map<EReference, UnresolvedProxyMessageProvider> unresolvedProxyMessageProviderMap = new HashMap<EReference, UnresolvedProxyMessageProvider>();
    public static boolean showContext = false;
    private static MessageBinder messageBinder = DefaultMessageBinder.INSTANCE;
    protected final Map<? extends Resource, ? extends Resource> cs2pivotResourceMap;
    protected final CSI2PivotMapping cs2PivotMapping;
    private Map<Element, ModelElementCS> pivot2cs = null;

    public static EList<EObject> computeRootContainmentFeatures(RootCS csRoot) {
        BasicEList containmentsList = new BasicEList();
        for (EStructuralFeature eStructuralFeature : csRoot.eClass().getEAllStructuralFeatures()) {
            EReference eReference;
            if (!(eStructuralFeature instanceof EReference) || !(eReference = (EReference)eStructuralFeature).isContainment()) continue;
            containmentsList.add((Object)eReference);
        }
        int index = containmentsList.indexOf((Object)BaseCSTPackage.Literals.ROOT_CS__OWNED_IMPORT);
        if (index > 0) {
            containmentsList.move(0, index);
        }
        if ((index = containmentsList.indexOf((Object)BaseCSTPackage.Literals.ROOT_CS__OWNED_LIBRARY)) > 0) {
            containmentsList.move(0, index);
        }
        return new EContentsEList((EObject)csRoot, (List)containmentsList);
    }

    public static void addUnresolvedProxyMessageProvider(UnresolvedProxyMessageProvider unresolvedProxyMessageProvider) {
        unresolvedProxyMessageProviderMap.put(unresolvedProxyMessageProvider.getEReference(), unresolvedProxyMessageProvider);
    }

    public static Element basicGetType(TypedTypeRefCS csTypedRef) {
        EList<PathElementCS> path = csTypedRef.getPathName().getPath();
        int iLast = path.size() - 1;
        int i = 0;
        while (i < iLast) {
            Element element = ((PathElementCS)path.get(i)).basicGetElement();
            if (element == null) {
                return null;
            }
            ++i;
        }
        Element element = ((PathElementCS)path.get(iLast)).basicGetElement();
        if (element == null) {
            return null;
        }
        return element;
    }

    public static DiagnosticMessage getUnresolvedProxyMessage(EReference eReference, EObject csContext, String linkText) {
        String message = CS2Pivot.getUnresolvedProxyText(eReference, csContext, linkText);
        return message != null ? new DiagnosticMessage(message, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]) : null;
    }

    public static String getUnresolvedProxyText(EReference eReference, EObject csContext, String linkText) {
        EClass referenceType;
        ExceptionAdapter exceptionAdapter = (ExceptionAdapter)((Object)PivotUtil.getAdapter(ExceptionAdapter.class, (Notifier)csContext));
        if (exceptionAdapter != null) {
            return exceptionAdapter.getException().getLocalizedMessage();
        }
        UnresolvedProxyMessageProvider unresolvedProxyMessageProvider = unresolvedProxyMessageProviderMap.get(eReference);
        if (unresolvedProxyMessageProvider != null) {
            return unresolvedProxyMessageProvider.getMessage(csContext, linkText);
        }
        String messageTemplate = OCLMessages.Unresolved_ERROR_;
        String errorContext = "Unknown";
        if (eReference != null && (referenceType = eReference.getEReferenceType()) != null) {
            errorContext = referenceType.getName();
        }
        return messageBinder.bind(csContext, messageTemplate, errorContext, linkText);
    }

    public static CS2Pivot findAdapter(ResourceSet resourceSet) {
        if (resourceSet == null) {
            return null;
        }
        return (CS2Pivot)((Object)PivotUtil.getAdapter(CS2Pivot.class, (Notifier)resourceSet));
    }

    public static List<ILeafNode> getDocumentationNodes(ICompositeNode node) {
        ArrayList<ILeafNode> documentationNodes = null;
        for (INode childNode : node.getChildren()) {
            ILeafNode leafNode;
            EObject grammarElement;
            if (!(childNode instanceof ILeafNode) || !((grammarElement = (leafNode = (ILeafNode)childNode).getGrammarElement()) instanceof TerminalRule)) break;
            TerminalRule terminalRule = (TerminalRule)grammarElement;
            String name = terminalRule.getName();
            if ("WS".equals(name) || "SL_COMMENT".equals(name)) continue;
            if (!"ML_COMMENT".equals(name)) break;
            String text = NodeModelUtils.getTokenText((INode)leafNode);
            if (!text.startsWith("/**")) continue;
            if (documentationNodes == null) {
                documentationNodes = new ArrayList<ILeafNode>();
            }
            documentationNodes.add(leafNode);
        }
        return documentationNodes;
    }

    public static MessageBinder getMessageBinder() {
        return messageBinder;
    }

    public static void setElementType(PathNameCS pathNameCS, EClass elementType, ElementCS csContext, ScopeFilter scopeFilter) {
        pathNameCS.setContext(csContext);
        pathNameCS.setScopeFilter(scopeFilter);
        EList<PathElementCS> path = pathNameCS.getPath();
        int iMax = path.size() - 1;
        ((PathElementCS)path.get(iMax)).setElementType((EClassifier)elementType);
        if (PivotPackage.Literals.FEATURE.isSuperTypeOf(elementType) && iMax > 0) {
            ((PathElementCS)path.get(--iMax)).setElementType((EClassifier)PivotPackage.Literals.TYPE);
        }
        int i = 0;
        while (i < iMax) {
            ((PathElementCS)path.get(i)).setElementType((EClassifier)PivotPackage.Literals.NAMESPACE);
            ++i;
        }
    }

    public static MessageBinder setMessageBinder(MessageBinder messageBinder) {
        MessageBinder savedMessageBinder = CS2Pivot.messageBinder;
        CS2Pivot.messageBinder = messageBinder;
        return savedMessageBinder;
    }

    public CS2Pivot(Map<? extends Resource, ? extends Resource> cs2pivotResourceMap, MetaModelManager metaModelManager) {
        super(metaModelManager);
        Pivot2CS pivot2cs = Pivot2CS.findAdapter(metaModelManager.getPivotResourceSet());
        this.cs2PivotMapping = pivot2cs != null ? pivot2cs.getCs2PivotMapping() : new CSI2PivotMapping(cs2pivotResourceMap.keySet());
        this.cs2pivotResourceMap = cs2pivotResourceMap;
        metaModelManager.addListener((MetaModelManagerListener)this);
        metaModelManager.getPivotResourceSet().eAdapters().add((Object)this);
    }

    protected CS2Pivot(CS2Pivot aConverter) {
        super(aConverter.metaModelManager);
        this.cs2pivotResourceMap = aConverter.cs2pivotResourceMap;
        this.cs2PivotMapping = new CSI2PivotMapping(aConverter.cs2PivotMapping);
    }

    public String bind(EObject csContext, String messageTemplate, Object ... bindings) {
        return messageBinder.bind(csContext, messageTemplate, bindings);
    }

    public Map<Element, ModelElementCS> computePivot2CSMap() {
        HashMap<Element, ModelElementCS> map = new HashMap<Element, ModelElementCS>();
        for (Resource resource : this.cs2pivotResourceMap.keySet()) {
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                if (!(eObject instanceof ModelElementCS)) continue;
                ModelElementCS csElement = (ModelElementCS)eObject;
                Element pivotElement = csElement.getPivot();
                map.put(pivotElement, csElement);
            }
        }
        return map;
    }

    protected abstract BaseCSVisitor<Continuation<?>> createContainmentVisitor(CS2PivotConversion var1);

    protected CS2PivotConversion createConversion(IDiagnosticConsumer diagnosticsConsumer, Collection<? extends Resource> csResources) {
        return new CS2PivotConversion(this, diagnosticsConsumer, csResources);
    }

    protected abstract BaseCSVisitor<Element> createLeft2RightVisitor(CS2PivotConversion var1);

    protected abstract BaseCSVisitor<Continuation<?>> createPostOrderVisitor(CS2PivotConversion var1);

    protected abstract BaseCSVisitor<Continuation<?>> createPreOrderVisitor(CS2PivotConversion var1);

    public void dispose() {
        this.cs2pivotResourceMap.clear();
        this.cs2PivotMapping.clear();
        this.pivot2cs = null;
        this.metaModelManager.getPivotResourceSet().eAdapters().remove((Object)this);
    }

    public ModelElementCS getCSElement(Element pivotElement) {
        if (this.pivot2cs == null) {
            this.pivot2cs = this.computePivot2CSMap();
        }
        return this.pivot2cs.get(pivotElement);
    }

    public Collection<? extends Resource> getCSResources() {
        return this.cs2pivotResourceMap.keySet();
    }

    public Element getPivotElement(ModelElementCS csElement) {
        return this.cs2PivotMapping.get(csElement);
    }

    public <T extends Element> T getPivotElement(Class<T> pivotClass, ModelElementCS csElement) {
        Element pivotElement = this.cs2PivotMapping.get(csElement);
        if (pivotElement == null) {
            return null;
        }
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException(String.valueOf(pivotElement.getClass().getName()) + " is not assignable to " + pivotClass.getName());
        }
        Element castElement = pivotElement;
        return (T)castElement;
    }

    public Resource getPivotResource(Resource csResource) {
        return this.cs2pivotResourceMap.get(csResource);
    }

    public Collection<? extends Resource> getPivotResources() {
        return this.metaModelManager.getPivotResourceSet().getResources();
    }

    public Notifier getTarget() {
        return this.metaModelManager.getPivotResourceSet();
    }

    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    public void installPivotDefinition(ModelElementCS csElement, Element newPivotElement) {
        Element oldPivotElement = csElement.getPivot();
        if (oldPivotElement != newPivotElement) {
            assert (!newPivotElement.eIsProxy());
            csElement.setPivot(newPivotElement);
        }
        this.cs2PivotMapping.put(csElement, newPivotElement);
    }

    public void installPivotReference(ElementRefCS csElement, Element newPivotElement, EReference eReference) {
        assert (eReference.getEContainingClass().isSuperTypeOf(csElement.eClass()));
        Element oldPivotElement = csElement.getPivot();
        if (oldPivotElement != newPivotElement) {
            assert (!newPivotElement.eIsProxy());
            csElement.setPivot(newPivotElement);
        }
    }

    public void installPivotUsage(ModelElementCS csElement, Element newPivotElement) {
        Element oldPivotElement = csElement.getPivot();
        if (oldPivotElement != newPivotElement) {
            assert (!newPivotElement.eIsProxy());
            csElement.setPivot(newPivotElement);
        }
    }

    public boolean isAdapterForType(Object type) {
        if (type instanceof Class) {
            return ((Class)type).isAssignableFrom(((Object)((Object)this)).getClass());
        }
        return false;
    }

    public boolean isAdapterFor(MetaModelManager metaModelManager) {
        return this.metaModelManager == metaModelManager;
    }

    public void metaModelManagerDisposed(MetaModelManager metaModelManager) {
        this.dispose();
    }

    public void notifyChanged(Notification notification) {
    }

    public <T extends Element> T refreshModelElement(Class<T> pivotClass, EClass pivotEClass, ModelElementCS csElement) {
        Element pivotElement;
        Element element = pivotElement = csElement != null ? this.getPivotElement(csElement) : null;
        if (pivotElement == null) {
            pivotElement = (Element)pivotEClass.getEPackage().getEFactoryInstance().create(pivotEClass);
        } else if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            pivotElement = (Element)pivotEClass.getEPackage().getEFactoryInstance().create(pivotEClass);
        }
        if (csElement != null) {
            this.installPivotDefinition(csElement, pivotElement);
        }
        Element castElement = pivotElement;
        return (T)castElement;
    }

    public void setTarget(Notifier newTarget) {
        assert (newTarget == this.metaModelManager.getPivotResourceSet());
    }

    public void unsetTarget(Notifier oldTarget) {
        assert (oldTarget == this.metaModelManager.getPivotResourceSet());
    }

    public synchronized void update(IDiagnosticConsumer diagnosticsConsumer) {
        Map<String, Element> oldCSI2Pivot = this.cs2PivotMapping.getMapping();
        Set<String> newCSIs = this.cs2PivotMapping.computeCSIs(this.cs2pivotResourceMap.keySet());
        Collection<? extends Resource> csResources = this.getCSResources();
        CS2PivotConversion conversion = this.createConversion(diagnosticsConsumer, csResources);
        conversion.update();
        conversion.garbageCollect(this.cs2pivotResourceMap);
        this.cs2PivotMapping.update(this.cs2pivotResourceMap.keySet());
        this.pivot2cs = null;
    }

    public static abstract class AbstractUnresolvedProxyMessageProvider
    implements UnresolvedProxyMessageProvider {
        protected final EReference eReference;

        public AbstractUnresolvedProxyMessageProvider(EReference eReference) {
            this.eReference = eReference;
        }

        public EReference getEReference() {
            return this.eReference;
        }

        public abstract String getMessage(EObject var1, String var2);
    }

    public static class DefaultMessageBinder
    implements MessageBinder {
        public static final MessageBinder INSTANCE = new DefaultMessageBinder();

        public String bind(EObject csContext, String messageTemplate, Object ... bindings) {
            return NLS.bind((String)messageTemplate, (Object[])bindings);
        }
    }

    public static interface MessageBinder {
        public String bind(EObject var1, String var2, Object ... var3);
    }

    public static class MessageBinderWithLineContext
    implements MessageBinder {
        public static final MessageBinder INSTANCE = new MessageBinderWithLineContext();

        public String bind(EObject csContext, String messageTemplate, Object ... bindings) {
            ICompositeNode node;
            String message = NLS.bind((String)messageTemplate, (Object[])bindings);
            if (csContext != null && (node = NodeModelUtils.getNode((EObject)csContext)) != null) {
                int startLine = node.getStartLine();
                String uri = csContext.eResource().getURI().toString();
                return String.valueOf(uri) + ":" + startLine + " " + message;
            }
            return message;
        }
    }

    public static interface UnresolvedProxyMessageProvider {
        public EReference getEReference();

        public String getMessage(EObject var1, String var2);
    }
}

