/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.pivot2cs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PathElement;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.ImportCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.RootPackageCS;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasAnalysis
extends AdapterImpl {
    private Map<String, EObject> allNames = new HashMap<String, EObject>();
    private Map<Package, String> allAliases = new HashMap<Package, String>();

    public static void dispose(Resource resource) {
        EList eAdapters;
        AliasAnalysis adapter;
        if (resource != null && (adapter = (AliasAnalysis)((Object)PivotUtil.getAdapter(AliasAnalysis.class, (List)(eAdapters = resource.eAdapters())))) != null) {
            adapter.dispose();
        }
    }

    public static AliasAnalysis getAdapter(Resource resource) {
        if (resource == null) {
            return null;
        }
        EList eAdapters = resource.eAdapters();
        AliasAnalysis adapter = (AliasAnalysis)((Object)PivotUtil.getAdapter(AliasAnalysis.class, (List)eAdapters));
        if (adapter == null) {
            adapter = new AliasAnalysis(resource);
            HashSet<Package> localPackages = new HashSet<Package>();
            HashSet<Package> otherPackages = new HashSet<Package>();
            MetaModelManager metaModelManager = ElementUtil.findMetaModelManager(resource);
            adapter.computePackages(metaModelManager, localPackages, otherPackages);
            adapter.computeAliases(metaModelManager, localPackages, otherPackages);
        }
        return adapter;
    }

    public AliasAnalysis(Resource resource) {
        resource.eAdapters().add((Object)this);
    }

    private void computeAliases(MetaModelManager metaModelManager, Set<Package> localPackages, Set<Package> otherPackages) {
        String alias;
        for (Package localPackage : localPackages) {
            if (metaModelManager != null) {
                localPackage = metaModelManager.getPrimaryPackage(localPackage);
            }
            if (localPackage.getNsPrefix() == null && localPackage.getNestingPackage() != null || this.allAliases.containsKey(localPackage)) continue;
            alias = this.computeAlias(localPackage);
            this.allAliases.put(localPackage, alias);
        }
        for (Package otherPackage : otherPackages) {
            if (metaModelManager != null) {
                otherPackage = metaModelManager.getPrimaryPackage(otherPackage);
            }
            if (this.allAliases.containsKey(otherPackage)) continue;
            alias = this.computeAlias(otherPackage);
            this.allAliases.put(otherPackage, alias);
        }
    }

    private void addName(String name, EObject primaryElement) {
        if (name != null) {
            if (!this.allNames.containsKey(name)) {
                this.allNames.put(name, primaryElement);
            } else if (this.allNames.get(name) != primaryElement) {
                this.allNames.put(name, null);
            }
        }
    }

    private String computeAlias(Package primaryPackage) {
        String nsPrefix = primaryPackage.getNsPrefix();
        String aliasBase = nsPrefix != null ? nsPrefix : this.getDefaultAlias(primaryPackage.getName());
        int index = 0;
        String alias = aliasBase;
        while (this.allNames.containsKey(alias) && this.allNames.get(alias) != primaryPackage) {
            EObject debugObject = this.allNames.get(alias);
            alias = String.valueOf(aliasBase) + "_" + index++;
        }
        this.addName(alias, (EObject)primaryPackage);
        return alias;
    }

    private void computePackages(MetaModelManager metaModelManager, Set<Package> localPackages, Set<Package> otherPackages) {
        EObject eContainer;
        TreeIterator tit = ((Resource)this.target).getAllContents();
        block0: while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof ImportCS) {
                String name = ((ImportCS)eObject).getName();
                Namespace namespace = ((ImportCS)eObject).getNamespace();
                if (namespace instanceof Package) {
                    this.allAliases.put((Package)namespace, name);
                }
            }
            EObject csObject = eObject;
            if (eObject instanceof Pivotable) {
                eObject = ((Pivotable)eObject).getPivot();
            }
            if (!(eObject instanceof NamedElement)) continue;
            if (metaModelManager != null) {
                eObject = metaModelManager.getPrimaryElement(eObject);
            }
            this.addName(((NamedElement)eObject).getName(), eObject);
            if (eObject instanceof Package && csObject instanceof RootPackageCS) {
                Package pivotPackage = (Package)eObject;
                this.addName(pivotPackage.getNsPrefix(), eObject);
                localPackages.add(pivotPackage);
                continue;
            }
            eContainer = eObject;
            while (eContainer != null) {
                if (eContainer instanceof Package) {
                    otherPackages.add((Package)eContainer);
                    continue block0;
                }
                if (eContainer instanceof Type) {
                    eContainer = PivotUtil.getUnspecializedTemplateableElement((Type)((Type)eContainer));
                }
                eContainer = eContainer.eContainer();
            }
        }
        otherPackages.removeAll(localPackages);
        HashSet<Package> nestedPackages = new HashSet<Package>();
        for (Package localPackage : localPackages) {
            EObject eContainerContainer;
            eContainer = localPackage.eContainer();
            if (!(eContainer instanceof Package) || !((eContainerContainer = eContainer.eContainer()) instanceof Package)) continue;
            nestedPackages.add(localPackage);
        }
        localPackages.removeAll(nestedPackages);
    }

    public void dispose() {
        this.target.eAdapters().remove((Object)this);
    }

    public String getAlias(EObject eObject) {
        if (eObject instanceof Pivotable) {
            eObject = ((Pivotable)eObject).getPivot();
        }
        if (eObject instanceof Package) {
            String alias = this.allAliases.get(eObject);
            if (alias != null) {
                return alias;
            }
            MetaModelManager metaModelManager = ElementUtil.findMetaModelManager((Resource)this.getTarget());
            if (metaModelManager != null) {
                eObject = metaModelManager.getPrimaryElement(eObject);
                return this.allAliases.get(eObject);
            }
        }
        return null;
    }

    protected String getDefaultAlias(String name) {
        if (name == null) {
            return "anon";
        }
        int iMax = name.length();
        if (iMax <= 0) {
            return "anon";
        }
        if (Character.isLowerCase(name.charAt(0))) {
            return name;
        }
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < iMax) {
            char c = name.charAt(i);
            if (!Character.isUpperCase(c)) {
                s.append(name.substring(i));
                break;
            }
            s.append(Character.toLowerCase(c));
            ++i;
        }
        return s.toString();
    }

    public List<PathElement> getPath(Element eObject) {
        if (eObject == null) {
            return null;
        }
        EObject eContainer = eObject.eContainer();
        if (eContainer == null) {
            return new ArrayList<PathElement>();
        }
        List<PathElement> result = this.getPath((Element)eContainer);
        if (eObject instanceof NamedElement) {
            result.add(new PathElement(((NamedElement)eObject).getName(), eObject));
        } else if (eObject instanceof ENamedElement) {
            result.add(new PathElement(((ENamedElement)eObject).getName(), eObject));
        } else if (eObject instanceof NamedElementCS) {
            result.add(new PathElement(((NamedElementCS)eObject).getName(), eObject));
        }
        return result;
    }

    public boolean isAdapterForType(Object type) {
        return type == AliasAnalysis.class;
    }
}

