/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSI2PivotMapping {
    private Map<String, String> csURI2aliasMap = new HashMap<String, String>();
    private Map<String, Element> csi2pivot = new HashMap<String, Element>();

    /*
     * WARNING - void declaration
     */
    public CSI2PivotMapping(Collection<? extends Resource> csResources) {
        ArrayList<String> uris = new ArrayList<String>(csResources.size());
        for (Resource resource : csResources) {
            String uri = resource.getURI().toString();
            uris.add(uri);
        }
        Collections.sort(uris);
        boolean bl = false;
        for (String uri : uris) {
            void var3_6;
            this.csURI2aliasMap.put(uri, Integer.toString((int)(++var3_6)));
        }
    }

    public CSI2PivotMapping(CSI2PivotMapping cs2PivotMapping) {
        for (Map.Entry<String, Element> entry : cs2PivotMapping.csi2pivot.entrySet()) {
            this.csi2pivot.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : cs2PivotMapping.csURI2aliasMap.entrySet()) {
            this.csURI2aliasMap.put(entry.getKey(), (String)entry.getValue());
        }
    }

    public void clear() {
        this.csURI2aliasMap.clear();
        this.csi2pivot.clear();
    }

    public Set<String> computeCSIs(Collection<? extends Resource> csResources) {
        HashSet<String> map = new HashSet<String>();
        for (Resource resource : csResources) {
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                if (!(eObject instanceof ModelElementCS)) continue;
                ModelElementCS csElement = (ModelElementCS)eObject;
                String csURI = this.getCSI(csElement);
                map.add(csURI);
            }
        }
        return map;
    }

    public Element get(ModelElementCS csElement) {
        String csi = this.getCSI(csElement);
        return this.csi2pivot.get(csi);
    }

    private String getCSI(ModelElementCS csElement) {
        String csi = csElement.getCsi();
        if (csi == null) {
            Resource csResource = csElement.eResource();
            String csResourceURI = csResource.getURI().toString();
            String fragment = csResource.getURIFragment((EObject)csElement);
            csi = String.valueOf(this.csURI2aliasMap.get(csResourceURI)) + '#' + fragment;
            csElement.setCsi(csi);
        }
        return csi;
    }

    public Map<String, Element> getMapping() {
        return this.csi2pivot;
    }

    public void put(ModelElementCS csElement, Element pivotElement) {
        String csi = this.getCSI(csElement);
        this.csi2pivot.put(csi, pivotElement);
    }

    public void update(Collection<? extends Resource> csResources) {
        this.csi2pivot.clear();
        for (Resource resource : csResources) {
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                if (!(eObject instanceof ModelElementCS)) continue;
                ModelElementCS csElement = (ModelElementCS)eObject;
                Element pivotElement = csElement.getPivot();
                this.put(csElement, pivotElement);
            }
        }
    }
}

