/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.utilities;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.Model;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.attributes.RootAttribution;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceAdapter;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.scoping.Attribution;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTFactory;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.CollectionTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.MultiplicityCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.OperationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateBindingCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.WildcardTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.LibraryDiagnostic;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementUtil {
    public static MetaModelManager findMetaModelManager(EObject eObject) {
        EObject eRoot = EcoreUtil.getRootContainer((EObject)eObject);
        if (eRoot != null) {
            MetaModelManagerResourceAdapter adapter;
            Resource resource = eRoot.eResource();
            if (eObject instanceof ElementCS && (adapter = MetaModelManagerResourceAdapter.findAdapter((Resource)resource)) != null) {
                return adapter.getMetaModelManager();
            }
            return ElementUtil.findMetaModelManager(resource);
        }
        return null;
    }

    public static MetaModelManager findMetaModelManager(Resource resource) {
        MetaModelManagerResourceSetAdapter adapter;
        ResourceSet resourceSet;
        if (resource != null && (resourceSet = resource.getResourceSet()) != null && (adapter = MetaModelManagerResourceSetAdapter.findAdapter((ResourceSet)resourceSet)) != null) {
            return adapter.getMetaModelManager();
        }
        return null;
    }

    public static String getCollectionTypeName(TypedElementCS csTypedElement) {
        Type csType;
        TypedRefCS csTypeRef = csTypedElement.getOwnedType();
        if (csTypeRef == null) {
            return null;
        }
        if (csTypeRef instanceof CollectionTypeRefCS && (csType = ((CollectionTypeRefCS)csTypeRef).getType()) instanceof CollectionType) {
            return ((CollectionType)csType).getName();
        }
        MultiplicityCS csMultiplicity = csTypeRef.getMultiplicity();
        if (csMultiplicity == null) {
            return null;
        }
        int upper = csMultiplicity.getUpper();
        if (upper == 1) {
            return null;
        }
        EList<String> qualifiers = csTypedElement.getQualifier();
        boolean isOrdered = true;
        boolean isUnique = true;
        if (qualifiers.contains("!ordered")) {
            isOrdered = false;
        } else if (qualifiers.contains("ordered")) {
            isOrdered = true;
        }
        if (qualifiers.contains("!unique")) {
            isUnique = false;
        } else if (qualifiers.contains("unique")) {
            isUnique = true;
        }
        return ElementUtil.getCollectionName(isOrdered, isUnique);
    }

    public static String getCollectionName(boolean ordered, boolean unique) {
        if (ordered) {
            return unique ? "OrderedSet" : "Sequence";
        }
        return unique ? "Set" : "Bag";
    }

    public static ModelElementCS getCsElement(Element obj) {
        Resource resource = obj.eResource();
        if (resource == null) {
            return null;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return null;
        }
        CS2Pivot cs2Pivot = CS2Pivot.findAdapter(resourceSet);
        if (cs2Pivot == null) {
            return null;
        }
        return cs2Pivot.getCSElement(obj);
    }

    public static RootAttribution getDocumentAttribution(ElementCS context) {
        ElementCS parent;
        ElementCS target = context;
        while ((parent = target.getLogicalParent()) != null) {
            Attribution attribution = PivotUtil.getAttribution((EObject)parent);
            if (attribution instanceof RootAttribution) {
                return (RootAttribution)attribution;
            }
            target = parent;
        }
        return null;
    }

    public static TemplateParameter getFormalTemplateParameter(TemplateParameterSubstitutionCS csTemplateParameterSubstitution) {
        TemplateBindingCS csTemplateBinding = csTemplateParameterSubstitution.getOwningTemplateBinding();
        int index = csTemplateBinding.getOwnedParameterSubstitution().indexOf((Object)csTemplateParameterSubstitution);
        if (index < 0) {
            return null;
        }
        TemplateBinding templateBinding = (TemplateBinding)csTemplateBinding.getPivot();
        TemplateSignature templateSignature = templateBinding.getSignature();
        EList templateParameters = templateSignature.getOwnedParameter();
        if (templateParameters.size() <= index) {
            return null;
        }
        return (TemplateParameter)templateParameters.get(index);
    }

    public static ILeafNode getLeafNode(INode node) {
        ILeafNode leafNode = null;
        if (node instanceof ILeafNode) {
            return (ILeafNode)node;
        }
        for (ILeafNode lNode : node.getLeafNodes()) {
            if (lNode.isHidden()) continue;
            leafNode = lNode;
            return leafNode;
        }
        return null;
    }

    public static int getLower(TypedElementCS csTypedElement) {
        TypedRefCS csTypeRef = csTypedElement.getOwnedType();
        if (csTypeRef == null) {
            return 0;
        }
        MultiplicityCS csMultiplicity = csTypeRef.getMultiplicity();
        if (csMultiplicity == null) {
            return 1;
        }
        return csMultiplicity.getLower();
    }

    public static <T extends NamedElementCS> T getNamedElementCS(Collection<T> namedElements, String name) {
        for (NamedElementCS namedElement : namedElements) {
            if (!name.equals(namedElement.getName())) continue;
            return (T)namedElement;
        }
        return null;
    }

    public static boolean getQualifier(List<String> qualifiers, String trueString, String falseString, boolean defaultValue) {
        if (qualifiers.contains(trueString)) {
            return true;
        }
        if (qualifiers.contains(falseString)) {
            return false;
        }
        return defaultValue;
    }

    public static String getText(ElementCS csElement) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        return NodeModelUtils.getTokenText((INode)node);
    }

    public static String getText(TypedTypeRefCS csElement, EReference feature) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)csElement, (EStructuralFeature)feature);
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        if (nodes.size() == 1) {
            return NodeModelUtils.getTokenText((INode)((INode)nodes.get(0)));
        }
        StringBuilder s = new StringBuilder();
        for (INode node : nodes) {
            s.append(NodeModelUtils.getTokenText((INode)node));
        }
        return s.toString();
    }

    public static int getUpper(TypedElementCS csTypedElement) {
        TypedRefCS csTypeRef = csTypedElement.getOwnedType();
        if (csTypeRef == null) {
            return 1;
        }
        MultiplicityCS csMultiplicity = csTypeRef.getMultiplicity();
        if (csMultiplicity == null) {
            return 1;
        }
        return csMultiplicity.getUpper();
    }

    public static boolean hasSyntaxError(List<Resource.Diagnostic> diagnostics) {
        for (Resource.Diagnostic diagnostic : diagnostics) {
            if (diagnostic instanceof LibraryDiagnostic) {
                return true;
            }
            if (!(diagnostic instanceof XtextSyntaxDiagnostic)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInOperation(ElementCS csElement) {
        ElementCS eObject = csElement;
        while (eObject != null) {
            if (eObject instanceof OperationCS) {
                return true;
            }
            if (eObject instanceof ClassCS) {
                return false;
            }
            eObject = eObject.eContainer();
        }
        return false;
    }

    public static boolean isOrdered(TypedElementCS csTypedElement) {
        return csTypedElement.getQualifier().contains((Object)"ordered");
    }

    @Deprecated
    public static NamedElement isPathable(EObject element) {
        if (element instanceof Feature) {
            return (Feature)element;
        }
        if (element instanceof Type) {
            return (Type)element;
        }
        if (element instanceof Namespace) {
            return (Namespace)element;
        }
        return null;
    }

    public static boolean isUnique(TypedElementCS csTypedElement) {
        return ElementUtil.getQualifier(csTypedElement.getQualifier(), "unique", "!unique", true);
    }

    public static boolean isSpecialization(TemplateBindingCS csTemplateBinding) {
        TypedTypeRefCS csTypedTypeRef = csTemplateBinding.getOwningTemplateBindableElement();
        Element type = csTypedTypeRef.getPivot();
        for (TemplateParameterSubstitutionCS csTemplateParameterSubstitution : csTemplateBinding.getOwnedParameterSubstitution()) {
            TypeRefCS ownedActualParameter = csTemplateParameterSubstitution.getOwnedActualParameter();
            if (ownedActualParameter instanceof WildcardTypeRefCS) {
                return true;
            }
            Type actualParameterClass = (Type)ownedActualParameter.getPivot();
            TemplateParameter owningTemplateParameter = actualParameterClass.getOwningTemplateParameter();
            if (owningTemplateParameter == null) {
                return true;
            }
            TemplateSignature signature = owningTemplateParameter.getSignature();
            TemplateableElement template = signature.getTemplate();
            if (template == type) continue;
            return true;
        }
        return false;
    }

    public static void setPathName(PathNameCS csPathName, Element element, EObject scope) {
        EList<PathElementCS> csPath = csPathName.getPath();
        csPath.clear();
        NamedElement namedElement = ElementUtil.isPathable((EObject)element);
        if (namedElement != null) {
            while (true) {
                PathElementCS csSimpleRef = BaseCSTFactory.eINSTANCE.createPathElementCS();
                csPath.add(0, csSimpleRef);
                csSimpleRef.setElement((Element)namedElement);
                EObject eContainer = namedElement.eContainer();
                EObject aScope = scope;
                while (aScope != null) {
                    if (aScope == eContainer) {
                        eContainer = null;
                        break;
                    }
                    aScope = aScope.eContainer();
                }
                if (eContainer instanceof NamedElement && !(eContainer instanceof Model)) {
                    namedElement = (NamedElement)eContainer;
                    continue;
                }
                break;
            }
        } else {
            PathElementCS csSimpleRef = BaseCSTFactory.eINSTANCE.createPathElementCS();
            csPath.add(csSimpleRef);
            csSimpleRef.setElement(element);
        }
    }
}

