/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.markup;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.xtext.markup.BulletElement;
import org.eclipse.ocl.examples.xtext.markup.CompoundElement;
import org.eclipse.ocl.examples.xtext.markup.FigureElement;
import org.eclipse.ocl.examples.xtext.markup.FigureRefElement;
import org.eclipse.ocl.examples.xtext.markup.FontElement;
import org.eclipse.ocl.examples.xtext.markup.HeadingElement;
import org.eclipse.ocl.examples.xtext.markup.MarkupElement;
import org.eclipse.ocl.examples.xtext.markup.NewLineElement;
import org.eclipse.ocl.examples.xtext.markup.TextElement;
import org.eclipse.ocl.examples.xtext.markup.util.MarkupSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupToTree
extends MarkupSwitch<StringBuilder> {
    protected final StringBuilder s = new StringBuilder();
    private int depth = 0;

    public static String toString(MarkupElement element) {
        MarkupToTree toString = new MarkupToTree();
        return ((StringBuilder)toString.doSwitch(element)).toString();
    }

    protected void appendClass(EObject object) {
        int i = 0;
        while (i < this.depth) {
            this.s.append("  ");
            ++i;
        }
        this.s.append(object.eClass().getName());
        this.s.append(": ");
    }

    protected void appendIndented(MarkupElement object) {
        this.s.append("\n");
        ++this.depth;
        this.doSwitch(object);
        --this.depth;
    }

    protected void appendIndented(Iterable<MarkupElement> objects) {
        this.s.append("\n");
        ++this.depth;
        for (MarkupElement element : objects) {
            this.doSwitch(element);
        }
        --this.depth;
    }

    @Override
    public StringBuilder caseBulletElement(BulletElement object) {
        this.appendClass(object);
        this.s.append(" ");
        this.s.append(object.getLevel());
        this.appendIndented((Iterable<MarkupElement>)object.getElements());
        return this.s;
    }

    @Override
    public StringBuilder caseCompoundElement(CompoundElement object) {
        this.appendClass(object);
        this.appendIndented((Iterable<MarkupElement>)object.getElements());
        return this.s;
    }

    @Override
    public StringBuilder caseFigureElement(FigureElement object) {
        this.appendClass(object);
        this.s.append(" ");
        this.s.append(object.getSrc());
        this.s.append(" ");
        this.s.append(object.getAlt());
        this.s.append(" ");
        this.s.append(object.getRequiredWidth());
        this.s.append(" ");
        this.s.append(object.getRequiredHeight());
        this.s.append("\n");
        return this.s;
    }

    @Override
    public StringBuilder caseFigureRefElement(FigureRefElement object) {
        this.appendClass(object);
        this.s.append(" ");
        this.s.append(object.getRef().getDef());
        this.s.append("\n");
        return this.s;
    }

    @Override
    public StringBuilder caseFontElement(FontElement object) {
        String font = object.getFont();
        this.appendClass(object);
        this.s.append(font);
        this.appendIndented((Iterable<MarkupElement>)object.getElements());
        return this.s;
    }

    @Override
    public StringBuilder caseHeadingElement(HeadingElement object) {
        this.appendClass(object);
        this.s.append(" ");
        this.s.append(object.getLevel());
        this.appendIndented((Iterable<MarkupElement>)object.getElements());
        return this.s;
    }

    @Override
    public StringBuilder caseNewLineElement(NewLineElement object) {
        this.appendClass(object);
        this.s.append(object.getText().replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t"));
        this.s.append("\n");
        return this.s;
    }

    @Override
    public StringBuilder caseTextElement(TextElement object) {
        this.appendClass(object);
        for (String text : object.getText()) {
            this.s.append(text.replace("\t", "\\t"));
        }
        this.s.append("\n");
        return this.s;
    }

    @Override
    public StringBuilder defaultCase(EObject object) {
        this.appendClass(object);
        this.s.append("\n");
        return this.s;
    }

    public String toString() {
        return this.s.toString();
    }
}

