/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.markup.services;

import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractDeclarativeValueConverterService;
import org.eclipse.xtext.conversion.impl.AbstractNullSafeConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupValueConverterService
extends AbstractDeclarativeValueConverterService {
    public static String convertFromJavaString(String javaString, boolean useUnicode) {
        char[] convtBuf;
        char[] in = javaString.toCharArray();
        int off = 0;
        int len = javaString.length();
        char[] out = convtBuf = new char[len];
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            char aChar;
            if ((aChar = in[off++]) == '\\') {
                aChar = in[off++];
                if (useUnicode && aChar == 'u') {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = in[off++];
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 't') {
                    aChar = '\t';
                } else if (aChar == 'r') {
                    aChar = '\r';
                } else if (aChar == 'n') {
                    aChar = '\n';
                } else if (aChar == 'f') {
                    aChar = '\f';
                } else if (aChar == 'b') {
                    aChar = '\b';
                } else if (aChar == '<') {
                    aChar = '<';
                } else if (aChar == '>') {
                    aChar = '>';
                } else if (aChar == '\"') {
                    aChar = '\"';
                } else if (aChar == '\'') {
                    aChar = '\'';
                } else if (aChar == '\\') {
                    aChar = '\\';
                } else {
                    throw new IllegalArgumentException("Illegal escape character \\" + aChar);
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    @ValueConverter(rule="STRING")
    public IValueConverter<String> STRING() {
        return new AbstractNullSafeConverter<String>(){

            protected String internalToValue(String string, INode node) {
                try {
                    return MarkupValueConverterService.convertFromJavaString(string.substring(1, string.length() - 1), false);
                }
                catch (IllegalArgumentException e) {
                    throw new ValueConverterException(e.getMessage(), node, (Exception)e);
                }
            }

            protected String internalToString(String value) {
                return String.valueOf('\'') + Strings.convertToJavaString((String)value, (boolean)false) + '\'';
            }
        };
    }

    @ValueConverter(rule="TEXT")
    public IValueConverter<String> TEXT() {
        return new AbstractNullSafeConverter<String>(){

            protected String internalToValue(String string, INode node) {
                try {
                    return MarkupValueConverterService.convertFromJavaString(string.substring(1, string.length() - 1), false);
                }
                catch (IllegalArgumentException e) {
                    throw new ValueConverterException(e.getMessage(), node, (Exception)e);
                }
            }

            protected String internalToString(String value) {
                return String.valueOf('\'') + Strings.convertToJavaString((String)value, (boolean)false) + '\'';
            }
        };
    }
}

