/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.classifier;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractUnaryOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.ObjectValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public class ClassifierOclContainerOperation
extends AbstractUnaryOperation {
    public static final ClassifierOclContainerOperation INSTANCE = new ClassifierOclContainerOperation();

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceVal) throws InvalidValueException {
        ValueFactory valueFactory = evaluator.getValueFactory();
        ObjectValue objectVal = sourceVal.asObjectValue();
        Object object = objectVal.getObject();
        if (object instanceof EObject) {
            EObject eContainer = ((EObject)object).eContainer();
            if (eContainer != null) {
                return valueFactory.valueOf((Object)eContainer);
            }
            return valueFactory.getNull();
        }
        if (object instanceof DomainElement) {
            return valueFactory.getNull();
        }
        return valueFactory.throwInvalidValueException(EvaluatorMessages.EObjectRequired, new Object[]{object.getClass().getName()});
    }
}

