/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.collection;

import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractUnaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryBinaryOperation;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.library.integer.IntegerPlusOperation;
import org.eclipse.ocl.examples.library.real.RealPlusOperation;

public class CollectionSumOperation
extends AbstractUnaryOperation {
    public static final CollectionSumOperation INSTANCE = new CollectionSumOperation();

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceVal) throws InvalidValueException {
        ValueFactory valueFactory = evaluator.getValueFactory();
        CollectionValue collectionValue = sourceVal.asCollectionValue();
        DomainStandardLibrary standardLibrary = valueFactory.getStandardLibrary();
        if (returnType.conformsTo(standardLibrary, standardLibrary.getIntegerType())) {
            return collectionValue.sum(evaluator, returnType, (LibraryBinaryOperation)IntegerPlusOperation.INSTANCE, (Value)valueFactory.integerValueOf(0));
        }
        return collectionValue.sum(evaluator, returnType, (LibraryBinaryOperation)RealPlusOperation.INSTANCE, (Value)valueFactory.realValueOf(0.0));
    }
}

