/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.ecore;

import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.library.ecore.EcoreValueFactory;
import org.eclipse.ocl.examples.library.executor.ExecutorManager;
import org.eclipse.ocl.examples.library.executor.LazyModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreExecutorManager
extends ExecutorManager {
    private final EObject contextObject;
    private final Map<Object, Object> contextMap;
    private LazyModelManager modelManager = null;

    protected static ValueFactory getValueFactory(EObject contextObject, Map<Object, Object> contextMap, DomainStandardLibrary standardLibrary) {
        Object valueFactory;
        if (contextMap != null && (valueFactory = contextMap.get(ValueFactory.class)) instanceof ValueFactory) {
            return (ValueFactory)valueFactory;
        }
        EPackage ePackage = contextObject.eClass().getEPackage();
        EList eAdapters = ePackage.eAdapters();
        for (Adapter adapter : eAdapters) {
            if (!(adapter instanceof ValueFactory)) continue;
            return (ValueFactory)adapter;
        }
        EcoreValueFactory ecoreValueFactory = new EcoreValueFactory(standardLibrary);
        eAdapters.add((Object)ecoreValueFactory);
        return ecoreValueFactory;
    }

    public EcoreExecutorManager(EObject contextObject, DomainStandardLibrary standardLibrary) {
        this(contextObject, null, standardLibrary);
    }

    public EcoreExecutorManager(EObject contextObject, Map<Object, Object> contextMap, DomainStandardLibrary standardLibrary) {
        super(EcoreExecutorManager.getValueFactory(contextObject, contextMap, standardLibrary));
        this.contextObject = contextObject;
        this.contextMap = contextMap;
    }

    public DomainEvaluator createNestedEvaluator() {
        return new EcoreExecutorManager(this.contextObject, this.contextMap, this.valueFactory.getStandardLibrary());
    }

    @Override
    public DomainModelManager getModelManager() {
        if (this.modelManager == null) {
            this.modelManager = new LazyModelManager(this.contextObject){

                protected boolean isInstance(DomainType type, EObject element) {
                    EClass eClass = element.eClass();
                    DomainStandardLibrary standardLibrary = EcoreExecutorManager.this.valueFactory.getStandardLibrary();
                    DomainType elementType = standardLibrary.getType((EClassifier)eClass);
                    return elementType.conformsTo(standardLibrary, type);
                }
            };
        }
        return this.modelManager;
    }
}

