/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.domain.elements.DomainClassifierType;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainTupleType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.types.AbstractCollectionType;
import org.eclipse.ocl.examples.domain.types.AbstractStandardLibrary;
import org.eclipse.ocl.examples.domain.types.AbstractTupleType;
import org.eclipse.ocl.examples.library.oclstdlib.OCLstdlibTables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExecutableStandardLibrary
extends AbstractStandardLibrary {
    private Map<DomainType, DomainClassifierType> classifiers = new HashMap<DomainType, DomainClassifierType>();
    private Map<DomainType, Map<DomainType, AbstractCollectionType>> specializations = new HashMap<DomainType, Map<DomainType, AbstractCollectionType>>();
    private Map<String, List<DomainTupleType>> tupleTypeMap = new HashMap<String, List<DomainTupleType>>();

    protected abstract DomainClassifierType createClassifierType(DomainType var1);

    public abstract DomainEvaluator createEvaluator(EObject var1, Map<Object, Object> var2);

    public DomainType getAnyClassifierType() {
        return OCLstdlibTables.Types._AnyClassifier;
    }

    public DomainType getBagType() {
        return OCLstdlibTables.Types._Bag;
    }

    public DomainCollectionType getBagType(DomainType elementType) {
        return this.getCollectionType(this.getBagType(), elementType);
    }

    public DomainType getBooleanType() {
        return OCLstdlibTables.Types._Boolean;
    }

    public DomainClassifierType getClassifierType(DomainType classType) {
        DomainClassifierType classifierType = this.classifiers.get(classType);
        if (classifierType == null) {
            classifierType = this.createClassifierType(classType);
            this.classifiers.put(classType, classifierType);
        }
        return classifierType;
    }

    public DomainType getCollectionType() {
        return OCLstdlibTables.Types._Collection;
    }

    public DomainCollectionType getCollectionType(DomainType genericType, DomainType elementType) {
        AbstractCollectionType specializedType = null;
        Map<DomainType, AbstractCollectionType> map = this.specializations.get(genericType);
        if (map == null) {
            map = new HashMap<DomainType, AbstractCollectionType>();
            this.specializations.put(genericType, map);
        } else {
            specializedType = map.get(elementType);
        }
        if (specializedType == null) {
            specializedType = new AbstractCollectionType((DomainStandardLibrary)this, genericType.getName(), genericType, elementType);
            map.put(elementType, specializedType);
        }
        return specializedType;
    }

    public DomainType getEnumerationType() {
        return OCLstdlibTables.Types._Enumeration;
    }

    public DomainType getIntegerType() {
        return OCLstdlibTables.Types._Integer;
    }

    public DomainType getOclAnyType() {
        return OCLstdlibTables.Types._OclAny;
    }

    public DomainType getOclComparableType() {
        return OCLstdlibTables.Types._OclComparable;
    }

    public DomainType getOclElementType() {
        return OCLstdlibTables.Types._OclElement;
    }

    public DomainType getOclInvalidType() {
        return OCLstdlibTables.Types._OclInvalid;
    }

    public DomainType getOclMessageType() {
        return OCLstdlibTables.Types._OclMessage;
    }

    public DomainType getOclSelfType() {
        return OCLstdlibTables.Types._OclSelf;
    }

    public DomainType getOclSummableType() {
        return OCLstdlibTables.Types._OclSummable;
    }

    public DomainType getOclTupleType() {
        return OCLstdlibTables.Types._OclTuple;
    }

    public DomainType getOclVoidType() {
        return OCLstdlibTables.Types._OclVoid;
    }

    public DomainType getOrderedSetType() {
        return OCLstdlibTables.Types._OrderedSet;
    }

    public DomainCollectionType getOrderedSetType(DomainType elementType) {
        return this.getCollectionType(this.getOrderedSetType(), elementType);
    }

    public DomainType getRealType() {
        return OCLstdlibTables.Types._Real;
    }

    public DomainType getSequenceType() {
        return OCLstdlibTables.Types._Sequence;
    }

    public DomainCollectionType getSequenceType(DomainType elementType) {
        return this.getCollectionType(this.getSequenceType(), elementType);
    }

    public DomainType getSetType() {
        return OCLstdlibTables.Types._Set;
    }

    public DomainCollectionType getSetType(DomainType elementType) {
        return this.getCollectionType(this.getSetType(), elementType);
    }

    public DomainType getStringType() {
        return OCLstdlibTables.Types._String;
    }

    public DomainTupleType getTupleType(List<? extends DomainTypedElement> parts) {
        StringBuilder s = new StringBuilder();
        for (DomainTypedElement domainTypedElement : parts) {
            s.append(domainTypedElement.getName());
            s.append("\n");
        }
        String string = s.toString();
        List<DomainTupleType> tupleTypes = this.tupleTypeMap.get(string);
        if (tupleTypes != null) {
            for (DomainTupleType tupleType2 : tupleTypes) {
                int i = 0;
                while (i < parts.size()) {
                    List ownedAttributes = tupleType2.getOwnedAttribute();
                    if (((DomainTypedElement)ownedAttributes.get(i)).getType() != parts.get(i).getType()) break;
                    ++i;
                }
                if (i < parts.size()) continue;
                return tupleType2;
            }
        } else {
            tupleTypes = new ArrayList<DomainTupleType>();
            this.tupleTypeMap.put(string, tupleTypes);
        }
        AbstractTupleType tupleType = new AbstractTupleType((DomainStandardLibrary)this, parts);
        tupleTypes.add((DomainTupleType)tupleType);
        return tupleType;
    }

    public DomainType getUnlimitedNaturalType() {
        return OCLstdlibTables.Types._UnlimitedNatural;
    }
}

